/* safe_id_range_list.h.  Generated by configure.  */
#ifndef SAFE_ID_RANGE_LIST_H_
#define SAFE_ID_RANGE_LIST_H_

/*
 * safefile package    http://www.cs.wisc.edu/~kupsch/safefile
 *
 * Copyright 2007-2008, 2011 James A. Kupsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <limits.h>

#ifdef __cplusplus
extern "C"  {
#endif


/* define id_t to uid_t if not defined */
/* #undef id_t */

#ifndef id_t
#define id_t uid_t
#endif

/* maximum uid_t, taking into account sign of id_t and uid_t */
extern const uid_t safe_max_uid_t;

/* maximum gid_t, taking into account sign of id_t and gid_t */
extern const gid_t safe_max_gid_t;


/* id used when an error occurs */
extern const id_t	safe_err_id;


/* declare implementation data structure type */
struct safe_id_range_list_elem;


typedef struct safe_id_range_list
{
    size_t				count;
    size_t				capacity;
    struct safe_id_range_list_elem	*list;
}  safe_id_range_list;


int     safe_init_id_range_list(safe_id_range_list *list);
int     safe_add_id_range_to_list(safe_id_range_list *list, id_t min_id, id_t max_id);
int     safe_add_id_to_list(safe_id_range_list *list, id_t id);
void    safe_destroy_id_range_list(safe_id_range_list *list);
int     safe_is_id_in_list(safe_id_range_list *list, id_t id);
int     safe_is_id_list_empty(safe_id_range_list *list);

uid_t   safe_strto_uid(const char *value, const char **endptr);
gid_t   safe_strto_gid(const char *value, const char **endptr);
id_t    safe_strto_id(const char *value, const char **endptr);
void    safe_strto_id_list(safe_id_range_list *list, const char *value, const char **endptr);
void    safe_strto_uid_list(safe_id_range_list *list, const char *value, const char **endptr);
void    safe_strto_gid_list(safe_id_range_list *list, const char *value, const char **endptr);
int     safe_parse_id_list(safe_id_range_list *list, const char *value);
int     safe_parse_uid_list(safe_id_range_list *list, const char *value);
int     safe_parse_gid_list(safe_id_range_list *list, const char *value);


#ifdef __cplusplus
}
#endif

#endif
