/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyString;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.NativeCallMethod;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.ir.targets.indy.InvokeSite;
import org.jruby.java.invokers.SingletonMethodInvoker;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.ReifiedJavaProxy;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JavaBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(JavaBootstrap.class);
    private static final MethodHandle IS_JAVA_SUBCLASS = InvokeDynamicSupport.findStatic(JavaBootstrap.class, "subclassProxyTest", MethodType.methodType(Boolean.TYPE, Object.class));

    public static boolean subclassProxyTest(Object target2) {
        return target2 instanceof ReifiedJavaProxy;
    }

    private static Object nullValue(Class type2) {
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return false;
        }
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            return (byte)0;
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            return (short)0;
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return 0;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return 0L;
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return 0.0;
        }
        return null;
    }

    public static MethodHandle createJavaHandle(InvokeSite site, DynamicMethod method2) {
        if (!(method2 instanceof NativeCallMethod)) {
            return null;
        }
        DynamicMethod.NativeCall nativeCall = ((NativeCallMethod)((Object)method2)).getNativeCall();
        if (nativeCall == null) {
            return null;
        }
        boolean isStatic = nativeCall.isStatic();
        if (site.signature.lastArgType() == Block.class) {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(site.name() + "\tpassed a closure to Java method " + nativeCall + ": " + Bootstrap.logMethod(method2), new Object[0]);
            }
            return null;
        }
        if (site.arity != nativeCall.getNativeSignature().length) {
            return null;
        }
        Class[] signature = nativeCall.getNativeSignature();
        if (signature.length > 0 && signature[signature.length - 1].isArray()) {
            return null;
        }
        if (method2 instanceof SingletonMethodInvoker) {
            return null;
        }
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget == null) {
            MethodHandle returnFilter;
            MethodType apparentType = MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature());
            nativeTarget = isStatic ? InvokeDynamicSupport.findStatic(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType) : InvokeDynamicSupport.findVirtual(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType);
            MethodType nativeType = nativeTarget.type();
            Class<?>[] nativeParams = nativeType.parameterArray();
            TypeDescriptor.OfField nativeReturn = nativeType.returnType();
            MethodHandle[] argConverters = new MethodHandle[nativeType.parameterCount()];
            for (int i2 = 0; i2 < argConverters.length; ++i2) {
                MethodHandle converter = !isStatic && i2 == 0 ? Binder.from(nativeParams[0], IRubyObject.class, new Class[0]).cast(Object.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy") : Binder.from(nativeParams[i2], IRubyObject.class, new Class[0]).insert(1, nativeParams[i2]).cast(Object.class, IRubyObject.class, Class.class).invokeVirtualQuiet(MethodHandles.lookup(), "toJava");
                argConverters[i2] = converter;
            }
            nativeTarget = MethodHandles.filterArguments(nativeTarget, 0, argConverters);
            Ruby runtime2 = method2.getImplementationClass().getRuntime();
            Class[] convertedParams = CodegenUtils.params(IRubyObject.class, nativeTarget.type().parameterCount());
            if (nativeReturn == Byte.TYPE || nativeReturn == Short.TYPE || nativeReturn == Character.TYPE || nativeReturn == Integer.TYPE || nativeReturn == Long.TYPE) {
                nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Long.TYPE, convertedParams));
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFixnum.class, "newFixnum", MethodType.methodType(RubyFixnum.class, Ruby.class, Long.TYPE)), 0, runtime2);
            } else if (nativeReturn == Byte.class || nativeReturn == Short.class || nativeReturn == Character.class || nativeReturn == Integer.class || nativeReturn == Long.class) {
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaBootstrap.class, "fixnumOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime2);
            } else if (nativeReturn == Float.TYPE || nativeReturn == Double.TYPE) {
                nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Double.TYPE, convertedParams));
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFloat.class, "newFloat", MethodType.methodType(RubyFloat.class, Ruby.class, Double.TYPE)), 0, runtime2);
            } else if (nativeReturn == Float.class || nativeReturn == Double.class) {
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaBootstrap.class, "floatOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime2);
            } else if (nativeReturn == Boolean.TYPE) {
                nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Boolean.TYPE, convertedParams));
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyBoolean.class, "newBoolean", MethodType.methodType(RubyBoolean.class, Ruby.class, Boolean.TYPE)), 0, runtime2);
            } else if (nativeReturn == Boolean.class) {
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaBootstrap.class, "booleanOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, Boolean.class)), 0, runtime2);
            } else if (CharSequence.class.isAssignableFrom((Class<?>)nativeReturn)) {
                nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(CharSequence.class, convertedParams));
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaBootstrap.class, "stringOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, CharSequence.class)), 0, runtime2);
            } else if (nativeReturn == Void.TYPE) {
                returnFilter = MethodHandles.constant(IRubyObject.class, runtime2.getNil());
            } else if (nativeReturn == ByteList.class) {
                nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(ByteList.class, convertedParams));
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaBootstrap.class, "stringOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, ByteList.class)), 0, runtime2);
            } else if (nativeReturn == BigInteger.class) {
                nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(BigInteger.class, convertedParams));
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaBootstrap.class, "bignumOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, BigInteger.class)), 0, runtime2);
            } else {
                nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Object.class, convertedParams));
                returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaUtil.class, "convertJavaToUsableRubyObject", MethodType.methodType(IRubyObject.class, Ruby.class, Object.class)), 0, runtime2);
            }
            nativeTarget = MethodHandles.filterReturnValue(nativeTarget, returnFilter);
            method2.setHandle(nativeTarget);
        }
        int dropCount = isStatic ? (site.functional ? 2 : 3) : (site.functional ? 1 : 2);
        return Binder.from(site.type()).drop(0, dropCount).invoke(nativeTarget);
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Byte b2) {
        return b2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, b2.byteValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Short s2) {
        return s2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, s2.shortValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Character c) {
        return c == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, c.charValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Integer i2) {
        return i2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, i2);
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Long l) {
        return l == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, l);
    }

    public static IRubyObject floatOrNil(Ruby runtime2, Float f) {
        return f == null ? runtime2.getNil() : RubyFloat.newFloat(runtime2, f.floatValue());
    }

    public static IRubyObject floatOrNil(Ruby runtime2, Double d) {
        return d == null ? runtime2.getNil() : RubyFloat.newFloat(runtime2, d);
    }

    public static IRubyObject booleanOrNil(Ruby runtime2, Boolean b2) {
        return b2 == null ? runtime2.getNil() : RubyBoolean.newBoolean(runtime2, (boolean)b2);
    }

    public static IRubyObject stringOrNil(Ruby runtime2, CharSequence cs) {
        return cs == null ? runtime2.getNil() : RubyString.newUnicodeString(runtime2, cs);
    }

    public static IRubyObject stringOrNil(Ruby runtime2, ByteList bl) {
        return bl == null ? runtime2.getNil() : RubyString.newString(runtime2, bl);
    }

    public static IRubyObject bignumOrNil(Ruby runtime2, BigInteger bi) {
        return bi == null ? runtime2.getNil() : RubyBignum.newBignum(runtime2, bi);
    }
}

