﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanrooms/model/ListProtectedQueriesResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CleanRooms::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListProtectedQueriesResult::ListProtectedQueriesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListProtectedQueriesResult& ListProtectedQueriesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("protectedQueries")) {
    Aws::Utils::Array<JsonView> protectedQueriesJsonList = jsonValue.GetArray("protectedQueries");
    for (unsigned protectedQueriesIndex = 0; protectedQueriesIndex < protectedQueriesJsonList.GetLength(); ++protectedQueriesIndex) {
      m_protectedQueries.push_back(protectedQueriesJsonList[protectedQueriesIndex].AsObject());
    }
    m_protectedQueriesHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
