/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.InternalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.AbstractPolymorphicSerializerKt;
import org.jetbrains.annotations.NotNull;

@InternalSerializationApi
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00032\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J%\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lkotlinx/serialization/internal/AbstractPolymorphicSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "()V", "baseClass", "Lkotlin/reflect/KClass;", "getBaseClass", "()Lkotlin/reflect/KClass;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Ljava/lang/Object;", "findPolymorphicSerializer", "Lkotlinx/serialization/CompositeDecoder;", "klassName", "", "encoder", "Lkotlinx/serialization/Encoder;", "value", "(Lkotlinx/serialization/Encoder;Ljava/lang/Object;)Lkotlinx/serialization/KSerializer;", "serialize", "", "obj", "(Lkotlinx/serialization/Encoder;Ljava/lang/Object;)V", "kotlinx-serialization-runtime"})
public abstract class AbstractPolymorphicSerializer<T>
implements KSerializer<T> {
    @NotNull
    public abstract KClass<T> getBaseClass();

    @Override
    public final void serialize(@NotNull Encoder encoder2, @NotNull T obj) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        KSerializer<T> actualSerializer = this.findPolymorphicSerializer(encoder2, obj);
        CompositeEncoder compositeEncoder = encoder2.beginStructure(this.getDescriptor(), new KSerializer[0]);
        compositeEncoder.encodeStringElement(this.getDescriptor(), 0, actualSerializer.getDescriptor().getName());
        KSerializer<T> kSerializer = actualSerializer;
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
        }
        compositeEncoder.encodeSerializableElement(this.getDescriptor(), 1, (SerializationStrategy)kSerializer, obj);
        compositeEncoder.endStructure(this.getDescriptor());
    }

    @Override
    @NotNull
    public final T deserialize(@NotNull Decoder decoder) {
        T value;
        Object klassName;
        CompositeDecoder compositeDecoder;
        block6: {
            int index;
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            compositeDecoder = decoder.beginStructure(this.getDescriptor(), new KSerializer[0]);
            klassName = null;
            value = null;
            while (true) {
                KSerializer<T> serializer2;
                if ((index = compositeDecoder.decodeElementIndex(this.getDescriptor())) == -2) {
                    klassName = compositeDecoder.decodeStringElement(this.getDescriptor(), 0);
                    serializer2 = this.findPolymorphicSerializer(compositeDecoder, (String)klassName);
                    value = compositeDecoder.decodeSerializableElement(this.getDescriptor(), 1, serializer2);
                    break block6;
                }
                if (index == -1) break block6;
                if (index == 0) {
                    klassName = compositeDecoder.decodeStringElement(this.getDescriptor(), index);
                    continue;
                }
                if (index != 1) break;
                serializer2 = klassName;
                boolean bl = false;
                boolean bl2 = false;
                if (serializer2 == null) {
                    boolean bl3 = false;
                    String string = "Cannot read polymorphic value before its type token";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                KSerializer<T> kSerializer = serializer2;
                klassName = kSerializer;
                serializer2 = this.findPolymorphicSerializer(compositeDecoder, (String)klassName);
                value = compositeDecoder.decodeSerializableElement(this.getDescriptor(), index, serializer2);
            }
            StringBuilder stringBuilder = new StringBuilder().append("Invalid index in polymorphic deserialization of ");
            Object object = klassName;
            if (object == null) {
                object = "unknown class";
            }
            throw (Throwable)new SerializationException(stringBuilder.append(object).append("\n Expected 0, 1, READ_ALL(-2) or READ_DONE(-1), but found ").append(index).toString(), null, 2, null);
        }
        compositeDecoder.endStructure(this.getDescriptor());
        boolean bl = false;
        boolean bl4 = false;
        if (value == null) {
            boolean bl5 = false;
            String string = "Polymorphic value has not been read for class " + (String)klassName;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return value;
    }

    @NotNull
    public KSerializer<? extends T> findPolymorphicSerializer(@NotNull CompositeDecoder decoder, @NotNull String klassName) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull((Object)klassName, (String)"klassName");
        KSerializer<T> kSerializer = decoder.getContext().getPolymorphic(this.getBaseClass(), klassName);
        if (kSerializer == null) {
            Void void_ = AbstractPolymorphicSerializerKt.access$throwSubtypeNotRegistered(klassName, this.getBaseClass());
            throw null;
        }
        return kSerializer;
    }

    @NotNull
    public KSerializer<? extends T> findPolymorphicSerializer(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)encoder2, (String)"encoder");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        KSerializer<T> kSerializer = encoder2.getContext().getPolymorphic(this.getBaseClass(), value);
        if (kSerializer == null) {
            Void void_ = AbstractPolymorphicSerializerKt.access$throwSubtypeNotRegistered(Reflection.getOrCreateKotlinClass(value.getClass()), this.getBaseClass());
            throw null;
        }
        return kSerializer;
    }

    @Override
    @NotNull
    public T patch(@NotNull Decoder decoder, @NotNull T old) {
        Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
        Intrinsics.checkParameterIsNotNull(old, (String)"old");
        return KSerializer.DefaultImpls.patch(this, decoder, old);
    }
}

