// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteSpoeMessageNoContentCode is the HTTP code returned for type DeleteSpoeMessageNoContent
const DeleteSpoeMessageNoContentCode int = 204

/*
DeleteSpoeMessageNoContent Spoe message deleted

swagger:response deleteSpoeMessageNoContent
*/
type DeleteSpoeMessageNoContent struct {
}

// NewDeleteSpoeMessageNoContent creates DeleteSpoeMessageNoContent with default headers values
func NewDeleteSpoeMessageNoContent() *DeleteSpoeMessageNoContent {

	return &DeleteSpoeMessageNoContent{}
}

// WriteResponse to the client
func (o *DeleteSpoeMessageNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteSpoeMessageNotFoundCode is the HTTP code returned for type DeleteSpoeMessageNotFound
const DeleteSpoeMessageNotFoundCode int = 404

/*
DeleteSpoeMessageNotFound The specified resource was not found

swagger:response deleteSpoeMessageNotFound
*/
type DeleteSpoeMessageNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteSpoeMessageNotFound creates DeleteSpoeMessageNotFound with default headers values
func NewDeleteSpoeMessageNotFound() *DeleteSpoeMessageNotFound {

	return &DeleteSpoeMessageNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete spoe message not found response
func (o *DeleteSpoeMessageNotFound) WithConfigurationVersion(configurationVersion string) *DeleteSpoeMessageNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete spoe message not found response
func (o *DeleteSpoeMessageNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete spoe message not found response
func (o *DeleteSpoeMessageNotFound) WithPayload(payload *models.Error) *DeleteSpoeMessageNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete spoe message not found response
func (o *DeleteSpoeMessageNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteSpoeMessageNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteSpoeMessageDefault General Error

swagger:response deleteSpoeMessageDefault
*/
type DeleteSpoeMessageDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteSpoeMessageDefault creates DeleteSpoeMessageDefault with default headers values
func NewDeleteSpoeMessageDefault(code int) *DeleteSpoeMessageDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteSpoeMessageDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete spoe message default response
func (o *DeleteSpoeMessageDefault) WithStatusCode(code int) *DeleteSpoeMessageDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete spoe message default response
func (o *DeleteSpoeMessageDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete spoe message default response
func (o *DeleteSpoeMessageDefault) WithConfigurationVersion(configurationVersion string) *DeleteSpoeMessageDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete spoe message default response
func (o *DeleteSpoeMessageDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete spoe message default response
func (o *DeleteSpoeMessageDefault) WithPayload(payload *models.Error) *DeleteSpoeMessageDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete spoe message default response
func (o *DeleteSpoeMessageDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteSpoeMessageDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
