// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetQUICInitialRuleFrontendOKCode is the HTTP code returned for type GetQUICInitialRuleFrontendOK
const GetQUICInitialRuleFrontendOKCode int = 200

/*
GetQUICInitialRuleFrontendOK Successful operation

swagger:response getQuicInitialRuleFrontendOK
*/
type GetQUICInitialRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.QUICInitialRule `json:"body,omitempty"`
}

// NewGetQUICInitialRuleFrontendOK creates GetQUICInitialRuleFrontendOK with default headers values
func NewGetQUICInitialRuleFrontendOK() *GetQUICInitialRuleFrontendOK {

	return &GetQUICInitialRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Quic initial rule frontend o k response
func (o *GetQUICInitialRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetQUICInitialRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Quic initial rule frontend o k response
func (o *GetQUICInitialRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Quic initial rule frontend o k response
func (o *GetQUICInitialRuleFrontendOK) WithPayload(payload *models.QUICInitialRule) *GetQUICInitialRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Quic initial rule frontend o k response
func (o *GetQUICInitialRuleFrontendOK) SetPayload(payload *models.QUICInitialRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetQUICInitialRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetQUICInitialRuleFrontendNotFoundCode is the HTTP code returned for type GetQUICInitialRuleFrontendNotFound
const GetQUICInitialRuleFrontendNotFoundCode int = 404

/*
GetQUICInitialRuleFrontendNotFound The specified resource was not found

swagger:response getQuicInitialRuleFrontendNotFound
*/
type GetQUICInitialRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetQUICInitialRuleFrontendNotFound creates GetQUICInitialRuleFrontendNotFound with default headers values
func NewGetQUICInitialRuleFrontendNotFound() *GetQUICInitialRuleFrontendNotFound {

	return &GetQUICInitialRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Quic initial rule frontend not found response
func (o *GetQUICInitialRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *GetQUICInitialRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Quic initial rule frontend not found response
func (o *GetQUICInitialRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Quic initial rule frontend not found response
func (o *GetQUICInitialRuleFrontendNotFound) WithPayload(payload *models.Error) *GetQUICInitialRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Quic initial rule frontend not found response
func (o *GetQUICInitialRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetQUICInitialRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetQUICInitialRuleFrontendDefault General Error

swagger:response getQuicInitialRuleFrontendDefault
*/
type GetQUICInitialRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetQUICInitialRuleFrontendDefault creates GetQUICInitialRuleFrontendDefault with default headers values
func NewGetQUICInitialRuleFrontendDefault(code int) *GetQUICInitialRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetQUICInitialRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get QUIC initial rule frontend default response
func (o *GetQUICInitialRuleFrontendDefault) WithStatusCode(code int) *GetQUICInitialRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get QUIC initial rule frontend default response
func (o *GetQUICInitialRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get QUIC initial rule frontend default response
func (o *GetQUICInitialRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetQUICInitialRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get QUIC initial rule frontend default response
func (o *GetQUICInitialRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get QUIC initial rule frontend default response
func (o *GetQUICInitialRuleFrontendDefault) WithPayload(payload *models.Error) *GetQUICInitialRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get QUIC initial rule frontend default response
func (o *GetQUICInitialRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetQUICInitialRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
