// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package mailer_entry

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteMailerEntryAcceptedCode is the HTTP code returned for type DeleteMailerEntryAccepted
const DeleteMailerEntryAcceptedCode int = 202

/*
DeleteMailerEntryAccepted Configuration change accepted and reload requested

swagger:response deleteMailerEntryAccepted
*/
type DeleteMailerEntryAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteMailerEntryAccepted creates DeleteMailerEntryAccepted with default headers values
func NewDeleteMailerEntryAccepted() *DeleteMailerEntryAccepted {

	return &DeleteMailerEntryAccepted{}
}

// WithReloadID adds the reloadId to the delete mailer entry accepted response
func (o *DeleteMailerEntryAccepted) WithReloadID(reloadID string) *DeleteMailerEntryAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete mailer entry accepted response
func (o *DeleteMailerEntryAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteMailerEntryAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteMailerEntryNoContentCode is the HTTP code returned for type DeleteMailerEntryNoContent
const DeleteMailerEntryNoContentCode int = 204

/*
DeleteMailerEntryNoContent MailerEntry deleted

swagger:response deleteMailerEntryNoContent
*/
type DeleteMailerEntryNoContent struct {
}

// NewDeleteMailerEntryNoContent creates DeleteMailerEntryNoContent with default headers values
func NewDeleteMailerEntryNoContent() *DeleteMailerEntryNoContent {

	return &DeleteMailerEntryNoContent{}
}

// WriteResponse to the client
func (o *DeleteMailerEntryNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteMailerEntryNotFoundCode is the HTTP code returned for type DeleteMailerEntryNotFound
const DeleteMailerEntryNotFoundCode int = 404

/*
DeleteMailerEntryNotFound The specified resource was not found

swagger:response deleteMailerEntryNotFound
*/
type DeleteMailerEntryNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteMailerEntryNotFound creates DeleteMailerEntryNotFound with default headers values
func NewDeleteMailerEntryNotFound() *DeleteMailerEntryNotFound {

	return &DeleteMailerEntryNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete mailer entry not found response
func (o *DeleteMailerEntryNotFound) WithConfigurationVersion(configurationVersion string) *DeleteMailerEntryNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete mailer entry not found response
func (o *DeleteMailerEntryNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete mailer entry not found response
func (o *DeleteMailerEntryNotFound) WithPayload(payload *models.Error) *DeleteMailerEntryNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete mailer entry not found response
func (o *DeleteMailerEntryNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteMailerEntryNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteMailerEntryDefault General Error

swagger:response deleteMailerEntryDefault
*/
type DeleteMailerEntryDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteMailerEntryDefault creates DeleteMailerEntryDefault with default headers values
func NewDeleteMailerEntryDefault(code int) *DeleteMailerEntryDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteMailerEntryDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete mailer entry default response
func (o *DeleteMailerEntryDefault) WithStatusCode(code int) *DeleteMailerEntryDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete mailer entry default response
func (o *DeleteMailerEntryDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete mailer entry default response
func (o *DeleteMailerEntryDefault) WithConfigurationVersion(configurationVersion string) *DeleteMailerEntryDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete mailer entry default response
func (o *DeleteMailerEntryDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete mailer entry default response
func (o *DeleteMailerEntryDefault) WithPayload(payload *models.Error) *DeleteMailerEntryDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete mailer entry default response
func (o *DeleteMailerEntryDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteMailerEntryDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
