// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package information

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHaproxyProcessInfoOKCode is the HTTP code returned for type GetHaproxyProcessInfoOK
const GetHaproxyProcessInfoOKCode int = 200

/*
GetHaproxyProcessInfoOK Success

swagger:response getHaproxyProcessInfoOK
*/
type GetHaproxyProcessInfoOK struct {

	/*
	  In: Body
	*/
	Payload *models.ProcessInfo `json:"body,omitempty"`
}

// NewGetHaproxyProcessInfoOK creates GetHaproxyProcessInfoOK with default headers values
func NewGetHaproxyProcessInfoOK() *GetHaproxyProcessInfoOK {

	return &GetHaproxyProcessInfoOK{}
}

// WithPayload adds the payload to the get haproxy process info o k response
func (o *GetHaproxyProcessInfoOK) WithPayload(payload *models.ProcessInfo) *GetHaproxyProcessInfoOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get haproxy process info o k response
func (o *GetHaproxyProcessInfoOK) SetPayload(payload *models.ProcessInfo) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHaproxyProcessInfoOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHaproxyProcessInfoDefault General Error

swagger:response getHaproxyProcessInfoDefault
*/
type GetHaproxyProcessInfoDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHaproxyProcessInfoDefault creates GetHaproxyProcessInfoDefault with default headers values
func NewGetHaproxyProcessInfoDefault(code int) *GetHaproxyProcessInfoDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHaproxyProcessInfoDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get haproxy process info default response
func (o *GetHaproxyProcessInfoDefault) WithStatusCode(code int) *GetHaproxyProcessInfoDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get haproxy process info default response
func (o *GetHaproxyProcessInfoDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get haproxy process info default response
func (o *GetHaproxyProcessInfoDefault) WithConfigurationVersion(configurationVersion string) *GetHaproxyProcessInfoDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get haproxy process info default response
func (o *GetHaproxyProcessInfoDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get haproxy process info default response
func (o *GetHaproxyProcessInfoDefault) WithPayload(payload *models.Error) *GetHaproxyProcessInfoDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get haproxy process info default response
func (o *GetHaproxyProcessInfoDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHaproxyProcessInfoDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
