// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllHTTPRequestRuleBackendOKCode is the HTTP code returned for type GetAllHTTPRequestRuleBackendOK
const GetAllHTTPRequestRuleBackendOKCode int = 200

/*
GetAllHTTPRequestRuleBackendOK Successful operation

swagger:response getAllHttpRequestRuleBackendOK
*/
type GetAllHTTPRequestRuleBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.HTTPRequestRules `json:"body,omitempty"`
}

// NewGetAllHTTPRequestRuleBackendOK creates GetAllHTTPRequestRuleBackendOK with default headers values
func NewGetAllHTTPRequestRuleBackendOK() *GetAllHTTPRequestRuleBackendOK {

	return &GetAllHTTPRequestRuleBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Http request rule backend o k response
func (o *GetAllHTTPRequestRuleBackendOK) WithConfigurationVersion(configurationVersion string) *GetAllHTTPRequestRuleBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Http request rule backend o k response
func (o *GetAllHTTPRequestRuleBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Http request rule backend o k response
func (o *GetAllHTTPRequestRuleBackendOK) WithPayload(payload models.HTTPRequestRules) *GetAllHTTPRequestRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Http request rule backend o k response
func (o *GetAllHTTPRequestRuleBackendOK) SetPayload(payload models.HTTPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPRequestRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllHTTPRequestRuleBackendDefault General Error

swagger:response getAllHttpRequestRuleBackendDefault
*/
type GetAllHTTPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllHTTPRequestRuleBackendDefault creates GetAllHTTPRequestRuleBackendDefault with default headers values
func NewGetAllHTTPRequestRuleBackendDefault(code int) *GetAllHTTPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllHTTPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all HTTP request rule backend default response
func (o *GetAllHTTPRequestRuleBackendDefault) WithStatusCode(code int) *GetAllHTTPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all HTTP request rule backend default response
func (o *GetAllHTTPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all HTTP request rule backend default response
func (o *GetAllHTTPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *GetAllHTTPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all HTTP request rule backend default response
func (o *GetAllHTTPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all HTTP request rule backend default response
func (o *GetAllHTTPRequestRuleBackendDefault) WithPayload(payload *models.Error) *GetAllHTTPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all HTTP request rule backend default response
func (o *GetAllHTTPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
