// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package declare_capture

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceDeclareCapturesOKCode is the HTTP code returned for type ReplaceDeclareCapturesOK
const ReplaceDeclareCapturesOKCode int = 200

/*
ReplaceDeclareCapturesOK All Declare capture lines replaced

swagger:response replaceDeclareCapturesOK
*/
type ReplaceDeclareCapturesOK struct {

	/*
	  In: Body
	*/
	Payload models.Captures `json:"body,omitempty"`
}

// NewReplaceDeclareCapturesOK creates ReplaceDeclareCapturesOK with default headers values
func NewReplaceDeclareCapturesOK() *ReplaceDeclareCapturesOK {

	return &ReplaceDeclareCapturesOK{}
}

// WithPayload adds the payload to the replace declare captures o k response
func (o *ReplaceDeclareCapturesOK) WithPayload(payload models.Captures) *ReplaceDeclareCapturesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace declare captures o k response
func (o *ReplaceDeclareCapturesOK) SetPayload(payload models.Captures) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDeclareCapturesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Captures{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceDeclareCapturesAcceptedCode is the HTTP code returned for type ReplaceDeclareCapturesAccepted
const ReplaceDeclareCapturesAcceptedCode int = 202

/*
ReplaceDeclareCapturesAccepted Configuration change accepted and reload requested

swagger:response replaceDeclareCapturesAccepted
*/
type ReplaceDeclareCapturesAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.Captures `json:"body,omitempty"`
}

// NewReplaceDeclareCapturesAccepted creates ReplaceDeclareCapturesAccepted with default headers values
func NewReplaceDeclareCapturesAccepted() *ReplaceDeclareCapturesAccepted {

	return &ReplaceDeclareCapturesAccepted{}
}

// WithReloadID adds the reloadId to the replace declare captures accepted response
func (o *ReplaceDeclareCapturesAccepted) WithReloadID(reloadID string) *ReplaceDeclareCapturesAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace declare captures accepted response
func (o *ReplaceDeclareCapturesAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace declare captures accepted response
func (o *ReplaceDeclareCapturesAccepted) WithPayload(payload models.Captures) *ReplaceDeclareCapturesAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace declare captures accepted response
func (o *ReplaceDeclareCapturesAccepted) SetPayload(payload models.Captures) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDeclareCapturesAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Captures{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceDeclareCapturesBadRequestCode is the HTTP code returned for type ReplaceDeclareCapturesBadRequest
const ReplaceDeclareCapturesBadRequestCode int = 400

/*
ReplaceDeclareCapturesBadRequest Bad request

swagger:response replaceDeclareCapturesBadRequest
*/
type ReplaceDeclareCapturesBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceDeclareCapturesBadRequest creates ReplaceDeclareCapturesBadRequest with default headers values
func NewReplaceDeclareCapturesBadRequest() *ReplaceDeclareCapturesBadRequest {

	return &ReplaceDeclareCapturesBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace declare captures bad request response
func (o *ReplaceDeclareCapturesBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceDeclareCapturesBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace declare captures bad request response
func (o *ReplaceDeclareCapturesBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace declare captures bad request response
func (o *ReplaceDeclareCapturesBadRequest) WithPayload(payload *models.Error) *ReplaceDeclareCapturesBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace declare captures bad request response
func (o *ReplaceDeclareCapturesBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDeclareCapturesBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceDeclareCapturesDefault General Error

swagger:response replaceDeclareCapturesDefault
*/
type ReplaceDeclareCapturesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceDeclareCapturesDefault creates ReplaceDeclareCapturesDefault with default headers values
func NewReplaceDeclareCapturesDefault(code int) *ReplaceDeclareCapturesDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceDeclareCapturesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace declare captures default response
func (o *ReplaceDeclareCapturesDefault) WithStatusCode(code int) *ReplaceDeclareCapturesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace declare captures default response
func (o *ReplaceDeclareCapturesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace declare captures default response
func (o *ReplaceDeclareCapturesDefault) WithConfigurationVersion(configurationVersion string) *ReplaceDeclareCapturesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace declare captures default response
func (o *ReplaceDeclareCapturesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace declare captures default response
func (o *ReplaceDeclareCapturesDefault) WithPayload(payload *models.Error) *ReplaceDeclareCapturesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace declare captures default response
func (o *ReplaceDeclareCapturesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDeclareCapturesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
