// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package configuration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"
)

// GetHAProxyConfigurationOKCode is the HTTP code returned for type GetHAProxyConfigurationOK
const GetHAProxyConfigurationOKCode int = 200

/*
GetHAProxyConfigurationOK Operation successful

swagger:response getHAProxyConfigurationOK
*/
type GetHAProxyConfigurationOK struct {
	/*Cluster configuration version

	 */
	ClusterVersion string `json:"Cluster-Version"`
	/*Configuration file md5 checksum

	 */
	ConfigurationChecksum string `json:"Configuration-Checksum"`
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload string `json:"body,omitempty"`
}

// NewGetHAProxyConfigurationOK creates GetHAProxyConfigurationOK with default headers values
func NewGetHAProxyConfigurationOK() *GetHAProxyConfigurationOK {

	return &GetHAProxyConfigurationOK{}
}

// WithClusterVersion adds the clusterVersion to the get h a proxy configuration o k response
func (o *GetHAProxyConfigurationOK) WithClusterVersion(clusterVersion string) *GetHAProxyConfigurationOK {
	o.ClusterVersion = clusterVersion
	return o
}

// SetClusterVersion sets the clusterVersion to the get h a proxy configuration o k response
func (o *GetHAProxyConfigurationOK) SetClusterVersion(clusterVersion string) {
	o.ClusterVersion = clusterVersion
}

// WithConfigurationChecksum adds the configurationChecksum to the get h a proxy configuration o k response
func (o *GetHAProxyConfigurationOK) WithConfigurationChecksum(configurationChecksum string) *GetHAProxyConfigurationOK {
	o.ConfigurationChecksum = configurationChecksum
	return o
}

// SetConfigurationChecksum sets the configurationChecksum to the get h a proxy configuration o k response
func (o *GetHAProxyConfigurationOK) SetConfigurationChecksum(configurationChecksum string) {
	o.ConfigurationChecksum = configurationChecksum
}

// WithConfigurationVersion adds the configurationVersion to the get h a proxy configuration o k response
func (o *GetHAProxyConfigurationOK) WithConfigurationVersion(configurationVersion string) *GetHAProxyConfigurationOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get h a proxy configuration o k response
func (o *GetHAProxyConfigurationOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get h a proxy configuration o k response
func (o *GetHAProxyConfigurationOK) WithPayload(payload string) *GetHAProxyConfigurationOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get h a proxy configuration o k response
func (o *GetHAProxyConfigurationOK) SetPayload(payload string) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHAProxyConfigurationOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Cluster-Version

	clusterVersion := o.ClusterVersion
	if clusterVersion != "" {
		rw.Header().Set("Cluster-Version", clusterVersion)
	}

	// response header Configuration-Checksum

	configurationChecksum := o.ConfigurationChecksum
	if configurationChecksum != "" {
		rw.Header().Set("Configuration-Checksum", configurationChecksum)
	}

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetHAProxyConfigurationDefault General Error

swagger:response getHAProxyConfigurationDefault
*/
type GetHAProxyConfigurationDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload string `json:"body,omitempty"`
}

// NewGetHAProxyConfigurationDefault creates GetHAProxyConfigurationDefault with default headers values
func NewGetHAProxyConfigurationDefault(code int) *GetHAProxyConfigurationDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHAProxyConfigurationDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get h a proxy configuration default response
func (o *GetHAProxyConfigurationDefault) WithStatusCode(code int) *GetHAProxyConfigurationDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get h a proxy configuration default response
func (o *GetHAProxyConfigurationDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get h a proxy configuration default response
func (o *GetHAProxyConfigurationDefault) WithConfigurationVersion(configurationVersion string) *GetHAProxyConfigurationDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get h a proxy configuration default response
func (o *GetHAProxyConfigurationDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get h a proxy configuration default response
func (o *GetHAProxyConfigurationDefault) WithPayload(payload string) *GetHAProxyConfigurationDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get h a proxy configuration default response
func (o *GetHAProxyConfigurationDefault) SetPayload(payload string) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHAProxyConfigurationDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}
