// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteBindFrontendAcceptedCode is the HTTP code returned for type DeleteBindFrontendAccepted
const DeleteBindFrontendAcceptedCode int = 202

/*
DeleteBindFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteBindFrontendAccepted
*/
type DeleteBindFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteBindFrontendAccepted creates DeleteBindFrontendAccepted with default headers values
func NewDeleteBindFrontendAccepted() *DeleteBindFrontendAccepted {

	return &DeleteBindFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete bind frontend accepted response
func (o *DeleteBindFrontendAccepted) WithReloadID(reloadID string) *DeleteBindFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete bind frontend accepted response
func (o *DeleteBindFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteBindFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteBindFrontendNoContentCode is the HTTP code returned for type DeleteBindFrontendNoContent
const DeleteBindFrontendNoContentCode int = 204

/*
DeleteBindFrontendNoContent Bind deleted

swagger:response deleteBindFrontendNoContent
*/
type DeleteBindFrontendNoContent struct {
}

// NewDeleteBindFrontendNoContent creates DeleteBindFrontendNoContent with default headers values
func NewDeleteBindFrontendNoContent() *DeleteBindFrontendNoContent {

	return &DeleteBindFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteBindFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteBindFrontendNotFoundCode is the HTTP code returned for type DeleteBindFrontendNotFound
const DeleteBindFrontendNotFoundCode int = 404

/*
DeleteBindFrontendNotFound The specified resource was not found

swagger:response deleteBindFrontendNotFound
*/
type DeleteBindFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteBindFrontendNotFound creates DeleteBindFrontendNotFound with default headers values
func NewDeleteBindFrontendNotFound() *DeleteBindFrontendNotFound {

	return &DeleteBindFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete bind frontend not found response
func (o *DeleteBindFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteBindFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete bind frontend not found response
func (o *DeleteBindFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete bind frontend not found response
func (o *DeleteBindFrontendNotFound) WithPayload(payload *models.Error) *DeleteBindFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete bind frontend not found response
func (o *DeleteBindFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteBindFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteBindFrontendDefault General Error

swagger:response deleteBindFrontendDefault
*/
type DeleteBindFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteBindFrontendDefault creates DeleteBindFrontendDefault with default headers values
func NewDeleteBindFrontendDefault(code int) *DeleteBindFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteBindFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete bind frontend default response
func (o *DeleteBindFrontendDefault) WithStatusCode(code int) *DeleteBindFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete bind frontend default response
func (o *DeleteBindFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete bind frontend default response
func (o *DeleteBindFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteBindFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete bind frontend default response
func (o *DeleteBindFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete bind frontend default response
func (o *DeleteBindFrontendDefault) WithPayload(payload *models.Error) *DeleteBindFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete bind frontend default response
func (o *DeleteBindFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteBindFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
