/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.api.Util;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class StringUtil {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StringUtil() {
    }

    public static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String replaceVariable(String string, String string2, String string3, ReplacementCallback replacementCallback) {
        return StringUtil.replaceVariable(string, string2, string3, replacementCallback, null);
    }

    public static String replaceVariable(String string, String string2, String string3, ReplacementCallback replacementCallback, Object object) {
        int n;
        int n2;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n3)) >= 0 && (n = string.indexOf(string3, n2 + 1)) >= 0) {
            int n4 = string.indexOf(string2, n2 + 1);
            if (n4 > -1 && n4 < n) {
                stringBuffer.append(string.substring(n3, n4));
                n3 = n4;
                continue;
            }
            String string4 = string.substring(n2 + string2.length(), n);
            String string5 = replacementCallback.getReplacement(string4, object);
            if (string5 == null) {
                stringBuffer.append(string.substring(n3, n + string3.length()));
            } else {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append(string5);
            }
            n3 = n + string3.length();
        }
        stringBuffer.append(string.substring(n3));
        String string6 = stringBuffer.toString();
        if (!string.equals(string6) && string6.indexOf(string2) > -1) {
            return StringUtil.replaceVariable(string6, string2, string3, replacementCallback, object);
        }
        return string6;
    }

    public static void splitupCommandLine(List list, String string) {
        StringUtil.splitupQuotedList(list, string, " ");
    }

    public static void splitupQuotedList(List list, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2 + "\"", true);
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("\"")) {
                if (bl && stringBuffer.length() > 0) {
                    list.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                bl = !bl;
                continue;
            }
            if (string2.indexOf(string3) > -1) {
                if (bl) {
                    stringBuffer.append(string2);
                    continue;
                }
                if (stringBuffer.length() <= 0) continue;
                list.add(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(string3);
        }
        if (stringBuffer.length() > 0) {
            list.add(stringBuffer.toString());
        }
    }

    public static String trimLineSeparators(String string) {
        return StringUtil.trimPattern(StringUtil.trimPattern(string, "\n"), "\r\n");
    }

    private static String trimPattern(String string, String string2) {
        if (string.length() < string2.length()) {
            return string;
        }
        int n = 0;
        int n2 = string2.length();
        while (string.substring(n, n + n2).equals(string2)) {
            n += n2;
        }
        int n3 = string.length();
        if (n + n2 == n3) {
            return "";
        }
        while (string.substring(n3 - n2, n3).equals(string2)) {
            n3 -= n2;
        }
        return string.substring(n, n3);
    }

    public static String escapeForPropertyFile(String string, boolean bl, boolean bl2) {
        int n = string.length();
        int n2 = n * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        if (bl2) {
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(StringUtil.toHex(c >> 12 & 0xF));
                        stringBuffer.append(StringUtil.toHex(c >> 8 & 0xF));
                        stringBuffer.append(StringUtil.toHex(c >> 4 & 0xF));
                        stringBuffer.append(StringUtil.toHex(c & 0xF));
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    public static String padLeft(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string.substring(0, Math.min(n, string.length())));
        return stringBuffer.toString();
    }

    public static String padRight(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string.substring(0, Math.min(n, string.length())));
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String makeCommandLine(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String replaceHomeDir(String string) {
        if (string.startsWith("~")) {
            string = Util.getUserHome() + string.substring(1);
        }
        return string;
    }

    public static String formatTextWithoutHtmlTags(String string) {
        if (string.indexOf("<html") > -1) {
            return StringUtil.convertHtmlToText(string);
        }
        return string;
    }

    private static String convertHtmlToText(String string) {
        final StringBuffer stringBuffer = new StringBuffer();
        final Stack stack = new Stack();
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

            public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag.equals(HTML.Tag.TITLE)) {
                    stack.push(new IndentedTag(tag, 0));
                } else if (tag.equals(HTML.Tag.P) || tag.equals(HTML.Tag.H1) || tag.equals(HTML.Tag.H2) || tag.equals(HTML.Tag.H3) || tag.equals(HTML.Tag.H4) || tag.equals(HTML.Tag.H5) || tag.equals(HTML.Tag.H6) || tag.equals(HTML.Tag.TH) || tag.equals(HTML.Tag.TR)) {
                    if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                        this.newLine();
                    }
                    this.newLine();
                } else if (tag.equals(HTML.Tag.DL) || tag.equals(HTML.Tag.DT)) {
                    this.newLine();
                } else if (tag.equals(HTML.Tag.OL) || tag.equals(HTML.Tag.UL) || tag.equals(HTML.Tag.BLOCKQUOTE) || tag.equals(HTML.Tag.DD)) {
                    stack.push(new IndentedTag(tag));
                    this.newLine();
                } else if (tag.equals(HTML.Tag.LI)) {
                    IndentedTag indentedTag = (IndentedTag)stack.peek();
                    if (indentedTag.getTag().equals(HTML.Tag.OL)) {
                        String string = indentedTag.nextOrder() + ".";
                        stringBuffer.append(string);
                        for (int i = 0; i < 3 - string.length(); ++i) {
                            stringBuffer.append("\u00a0");
                        }
                    } else {
                        stringBuffer.append("*\u00a0\u00a0");
                    }
                    stack.push(new IndentedTag(tag));
                }
            }

            private void newLine() {
                stringBuffer.append('\n');
                for (int i = 0; i < stack.size(); ++i) {
                    IndentedTag indentedTag = (IndentedTag)stack.get(i);
                    for (int j = 0; j < indentedTag.getIndentation(); ++j) {
                        stringBuffer.append("\u00a0");
                    }
                }
            }

            public void handleEndTag(HTML.Tag tag, int n) {
                if (tag.equals(HTML.Tag.P) || tag.equals(HTML.Tag.H1) || tag.equals(HTML.Tag.H2) || tag.equals(HTML.Tag.H3) || tag.equals(HTML.Tag.H4) || tag.equals(HTML.Tag.H5) || tag.equals(HTML.Tag.H6) || tag.equals(HTML.Tag.TH) || tag.equals(HTML.Tag.TR)) {
                    this.newLine();
                }
                if (tag.equals(HTML.Tag.TD)) {
                    stringBuffer.append("\u00a0");
                } else if (tag.equals(HTML.Tag.OL) || tag.equals(HTML.Tag.UL) || tag.equals(HTML.Tag.LI) || tag.equals(HTML.Tag.BLOCKQUOTE)) {
                    stack.pop();
                    this.newLine();
                } else if (tag.equals(HTML.Tag.DD) || tag.equals(HTML.Tag.TITLE)) {
                    stack.pop();
                }
            }

            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag.equals(HTML.Tag.BR)) {
                    this.newLine();
                }
            }

            public void handleText(char[] cArray, int n) {
                if (stack.size() == 0 || ((IndentedTag)stack.peek()).getTag() != HTML.Tag.TITLE) {
                    stringBuffer.append(cArray);
                }
            }
        };
        StringReader stringReader = new StringReader(string);
        ParserDelegator parserDelegator = new ParserDelegator();
        try {
            parserDelegator.parse(stringReader, parserCallback, true);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    private static class IndentedTag {
        private HTML.Tag tag;
        private int indentation;
        private int order;

        public IndentedTag(HTML.Tag tag) {
            this.tag = tag;
            this.order = 0;
        }

        public IndentedTag(HTML.Tag tag, int n) {
            this.tag = tag;
            this.indentation = n;
            this.order = 0;
        }

        public int nextOrder() {
            return ++this.order;
        }

        public HTML.Tag getTag() {
            return this.tag;
        }

        public int getIndentation() {
            return this.indentation;
        }
    }

    public static interface ReplacementCallback {
        public String getReplacement(String var1, Object var2);
    }
}

