/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractNameAndIdConfig;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.w3c.dom.Element;

public abstract class ComponentNodeConfig
extends AbstractNameAndIdConfig {
    private ComponentNodeConfig parent;
    private boolean selected = true;
    private String description = "";
    private boolean displayDescription;
    private boolean hideHelpButton = true;
    private boolean hidden;
    private transient WeakHashMap listeners = new WeakHashMap();
    private transient Boolean initialDisplayDescription;

    protected ComponentNodeConfig(ComponentNodeConfig componentNodeConfig) {
        this.parent = componentNodeConfig;
        this.displayDescription = this.getDefaultDisplayDescriptionValue();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.selected;
        this.selected = bl;
        if (bl2 != bl) {
            this.fireSelectionChanged();
        }
    }

    public String getDescription() {
        return InstallerVariables.replaceVariables(this.description);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isDisplayDescription() {
        return this.displayDescription;
    }

    public void setDisplayDescription(boolean bl) {
        this.displayDescription = bl;
        if (this.initialDisplayDescription == null) {
            this.initialDisplayDescription = bl;
        }
    }

    public boolean isHideHelpButton() {
        return this.hideHelpButton;
    }

    public void setHideHelpButton(boolean bl) {
        this.hideHelpButton = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        boolean bl2 = this.hidden;
        this.hidden = bl;
        if (bl != bl2) {
            this.fireHiddenChanged();
        }
    }

    public boolean isIncluded() {
        return this.isSelected() || this.parent != null && this.parent.isIncluded();
    }

    protected boolean getDefaultDisplayDescriptionValue() {
        return false;
    }

    protected void read(Element element) {
        super.read(element);
        this.selected = ComponentNodeConfig.readAttribute(element, "selected", this.selected);
        this.displayDescription = ComponentNodeConfig.readAttribute(element, "displayDescription", this.displayDescription);
        this.initialDisplayDescription = this.displayDescription;
        this.hideHelpButton = ComponentNodeConfig.readAttribute(element, "hideHelpButton", this.hideHelpButton);
        this.hidden = ComponentNodeConfig.readAttribute(element, "hidden", this.hidden);
        Iterator iterator = ComponentNodeConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getTagName();
            if (!string.equals("description")) continue;
            this.description = XmlHelper.getTextValue(element2);
        }
    }

    public void addComponentChangeListener(ComponentChangeListener componentChangeListener) {
        this.listeners.put(componentChangeListener, null);
    }

    protected void fireSelectionChanged() {
        Iterator iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            ComponentChangeListener componentChangeListener = (ComponentChangeListener)iterator.next();
            if (componentChangeListener == null) continue;
            componentChangeListener.selectionChanged(this);
        }
    }

    protected void fireChangeableChanged() {
        Iterator iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            ComponentChangeListener componentChangeListener = (ComponentChangeListener)iterator.next();
            if (componentChangeListener == null) continue;
            componentChangeListener.changeableChanged(this);
        }
    }

    protected void fireHiddenChanged() {
        Iterator iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            ComponentChangeListener componentChangeListener = (ComponentChangeListener)iterator.next();
            if (componentChangeListener == null) continue;
            componentChangeListener.hiddenChanged(this);
        }
    }

    public boolean isInitialDisplayDescription() {
        if (this.initialDisplayDescription == null) {
            return this.getDefaultDisplayDescriptionValue();
        }
        return this.initialDisplayDescription;
    }

    public static interface ComponentChangeListener {
        public void selectionChanged(ComponentNodeConfig var1);

        public void changeableChanged(ComponentNodeConfig var1);

        public void hiddenChanged(ComponentNodeConfig var1);
    }
}

