/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.AbstractListComponent;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class DropdownListComponent
extends AbstractListComponent
implements ActionListener {
    private JComboBox comboBox;

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.comboBox != null && formEnvironment != null) {
            this.comboBox.setName(formEnvironment.getId(this));
        }
    }

    public JComponent createCenterComponent() {
        this.comboBox = new JComboBox();
        this.comboBox.setAlignmentX(0.0f);
        return this.comboBox;
    }

    public void initialize() {
        super.initialize();
        this.comboBox.removeActionListener(this);
        this.comboBox.setModel(new DefaultComboBoxModel<String>(this.getListEntries()));
        this.applyComboBoxProperties(this.comboBox);
        this.comboBox.addActionListener(this);
        this.selectionChanged(this.comboBox.getSelectedItem());
        this.adjustMinimumSize(this.comboBox, this.comboBox);
    }

    protected void applyComboBoxProperties(JComboBox jComboBox) {
        int n = (Integer)this.getInitValue(new Integer(this.getInitiallySelectedIndex()), this.getVariableName(), Integer.class);
        if (n < this.getListEntries().length) {
            jComboBox.setSelectedIndex(n);
        }
        Dimension dimension = jComboBox.getPreferredSize();
        dimension.width += 10;
        jComboBox.setPreferredSize(dimension);
    }

    protected JComboBox getComboBox() {
        return this.comboBox;
    }

    public Object getConfigurationObject() {
        return this.comboBox;
    }

    public Class getConfigurationObjectClass() {
        return JComboBox.class;
    }

    public boolean checkCompleted() {
        this.getContext().setVariable(this.getVariableName(), new Integer(this.comboBox.getSelectedIndex()));
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    protected boolean getInitialFillHorizontal() {
        return false;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        int n;
        String[] stringArray = new String[this.comboBox.getItemCount()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.comboBox.getItemAt(n).toString();
        }
        n = console.askOption(this.getConsoleLabelText(false), stringArray, null, this.comboBox.getSelectedIndex(), true, true);
        this.comboBox.setSelectedIndex(n);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.comboBox) {
            this.selectionChanged(this.comboBox.getSelectedItem());
        }
    }
}

