/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.CoupledComponentsHolder;
import com.install4j.runtime.beans.formcomponents.CoupledComponentsUtil;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class CheckboxComponent
extends LeadingLabelComponent
implements CoupledComponentsHolder {
    private String variableName = "";
    private String checkboxText = "";
    private boolean initiallySelected;
    private List coupledComponentIds = new ArrayList();
    private boolean inverseCoupling = false;
    private ScriptProperty selectionScript;
    private JCheckBox checkbox;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getCheckboxText() {
        return CheckboxComponent.replaceVariables(this.checkboxText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setCheckboxText(String string) {
        this.checkboxText = string;
    }

    public boolean isInitiallySelected() {
        return this.initiallySelected;
    }

    public void setInitiallySelected(boolean bl) {
        this.initiallySelected = bl;
    }

    public ScriptProperty getSelectionScript() {
        return this.selectionScript;
    }

    public void setSelectionScript(ScriptProperty scriptProperty) {
        this.selectionScript = scriptProperty;
    }

    public List getCoupledComponentIds() {
        return this.coupledComponentIds;
    }

    public void setCoupledComponentIds(List list) {
        this.coupledComponentIds = list;
    }

    public boolean isInverseCoupling() {
        return this.inverseCoupling;
    }

    public void setInverseCoupling(boolean bl) {
        this.inverseCoupling = bl;
    }

    public Boolean isEnableCoupledComponents() {
        if (this.checkbox == null) {
            return null;
        }
        return this.checkbox.isSelected();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        CoupledComponentsUtil.enableCoupledComponents(this);
    }

    public void migrateIds(Map map) {
        super.migrateIds(map);
        CoupledComponentsUtil.migrateCoupledIds(this, map);
    }

    public void initialize() {
        super.initialize();
        if (this.checkboxText.trim().length() > 0) {
            this.checkbox.setText(this.getCheckboxText());
        }
        if (((Boolean)this.getInitValue(this.isInitiallySelected(), this.getVariableName(), Boolean.class)).booleanValue()) {
            this.checkbox.setSelected(true);
        }
    }

    public void formWillActivate() {
        super.formWillActivate();
        CoupledComponentsUtil.enableCoupledComponents(this);
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.checkbox != null && formEnvironment != null) {
            this.checkbox.setName(formEnvironment.getId(this));
        }
    }

    public JComponent createCenterComponent() {
        this.checkbox = new JCheckBox();
        this.checkbox.setAlignmentX(0.0f);
        this.checkbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoupledComponentsUtil.enableCoupledComponents(CheckboxComponent.this);
                CheckboxComponent.this.executeSelectionScript();
            }
        });
        return this.checkbox;
    }

    private void executeSelectionScript() {
        try {
            this.getContext().runScript(this.selectionScript, this, new Object[]{this.getFormEnvironment(), this.checkbox.isSelected()});
        }
        catch (Exception exception) {
            Util.printAnnotatedStackTrace(exception);
            Logger.getInstance().log(exception);
        }
    }

    public boolean isFillCenterHorizontal() {
        return false;
    }

    public Object getConfigurationObject() {
        return this.checkbox;
    }

    public Class getConfigurationObjectClass() {
        return JCheckBox.class;
    }

    public boolean checkCompleted() {
        this.getContext().setVariable(this.getVariableName(), this.checkbox.isSelected());
        this.getContext().registerResponseFileVariable(this.getVariableName());
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        this.checkbox.setSelected(console.askYesNo(this.getConsoleLabelText(true) + this.appendConditional(this.checkbox.getText(), "?", false), this.checkbox.isSelected()));
        CoupledComponentsUtil.enableCoupledComponents(this);
        this.executeSelectionScript();
        return true;
    }

    public boolean handleUnattended() {
        CoupledComponentsUtil.enableCoupledComponents(this);
        return super.handleUnattended();
    }
}

