/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.file.visitor;

import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.util.ClassUtil;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.ResourceJavaReference;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;

public class ResourceJavaReferenceClassInitializer
implements ResourceFileVisitor {
    private final ClassPool programClassPool;

    public ResourceJavaReferenceClassInitializer(ClassPool programClassPool) {
        this.programClassPool = programClassPool;
    }

    @Override
    public void visitResourceFile(ResourceFile resourceFile) {
        Set<ResourceJavaReference> references = resourceFile.references;
        if (references != null) {
            for (ResourceJavaReference reference : references) {
                String externalClassName = reference.externalClassName;
                String internalClassName = ClassUtil.internalClassName(externalClassName);
                reference.referencedClass = this.programClassPool.getClass(internalClassName);
            }
        }
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
    }
}

