/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.domain.arg.ArgProgramLocationDependentAbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public class JvmMemoryLocationAbstractState
implements LatticeAbstractState<JvmMemoryLocationAbstractState>,
ProgramLocationDependent<JvmCfaNode, JvmCfaEdge, MethodSignature> {
    public static final JvmMemoryLocationAbstractState top = new JvmMemoryLocationAbstractState();
    private final JvmMemoryLocation memoryLocation;
    private final Set<JvmMemoryLocation> sourceLocations;

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation) {
        this(memoryLocation, new HashSet<JvmMemoryLocation>());
    }

    public JvmMemoryLocationAbstractState(JvmMemoryLocation memoryLocation, Set<JvmMemoryLocation> sourceLocations) {
        this.memoryLocation = memoryLocation;
        this.sourceLocations = sourceLocations;
    }

    private JvmMemoryLocationAbstractState() {
        this(null);
    }

    @Override
    public JvmMemoryLocationAbstractState join(JvmMemoryLocationAbstractState abstractState) {
        if (!this.memoryLocation.equals(abstractState.memoryLocation)) {
            return top;
        }
        JvmMemoryLocationAbstractState result = this.copy();
        result.sourceLocations.addAll(abstractState.sourceLocations);
        return this.equals(result) ? this : result;
    }

    @Override
    public boolean isLessOrEqual(JvmMemoryLocationAbstractState abstractState) {
        return abstractState == top || this.memoryLocation.equals(abstractState.memoryLocation) && abstractState.sourceLocations.containsAll(this.sourceLocations);
    }

    @Override
    public JvmCfaNode getProgramLocation() {
        return (JvmCfaNode)this.memoryLocation.getProgramLocation();
    }

    @Override
    public void setProgramLocation(JvmCfaNode programLocation) {
        this.memoryLocation.setProgramLocation(programLocation);
    }

    public ArgProgramLocationDependentAbstractState<JvmCfaNode, JvmCfaEdge, MethodSignature> getArgNode() {
        return this.memoryLocation.getArgNode();
    }

    public JvmMemoryLocation getMemoryLocation() {
        return this.memoryLocation;
    }

    public void addSourceLocation(JvmMemoryLocation sourceLocation) {
        this.sourceLocations.add(sourceLocation);
    }

    public Set<JvmMemoryLocation> getSourceLocations() {
        return this.sourceLocations;
    }

    @Override
    public JvmMemoryLocationAbstractState copy() {
        return new JvmMemoryLocationAbstractState(this.memoryLocation, new HashSet<JvmMemoryLocation>(this.sourceLocations));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmMemoryLocationAbstractState)) {
            return false;
        }
        JvmMemoryLocationAbstractState other = (JvmMemoryLocationAbstractState)obj;
        return this.memoryLocation.equals(other.memoryLocation) && this.sourceLocations.equals(other.sourceLocations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.memoryLocation);
    }
}

