/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2020-2021 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
; generated by igemm_codegen.py (2c97a12e9f49260c2ce1b87c12cf7e05adcaf403)
;
.include "igemm_fwd_gtcx35_nhwc_int8_utils.inc"

;----------------------------------------------------------
; starting of kernel igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64
; tensor_layout              : 'nhwc'
; gemm_m_per_block           : 256
; gemm_n_per_block           : 128
; gemm_k_per_block           : 64
; wave_tile_m                : 32
; wave_step_m                : 2
; wave_repeat_m              : 2
; wave_tile_n                : 32
; wave_step_n                : 1
; wave_repeat_n              : 2
; wave_tile_k                : 16
; tensor_a_thread_lengths    : [1, 16, 4, 1]
; tensor_a_cluster_lengths   : [1, 4, 1, 64]
; tensor_b_thread_lengths    : [1, 16, 2, 1]
; tensor_b_cluster_lengths   : [1, 4, 1, 64]
; direction                  : 'fwd'
; precision                  : 'int8'
; nxb                        : 0
; nxe                        : 0
; vector_c                   : 1
; 
; block_size                 : 256
; lds_total                  : 32768
; lds_buffer_num             : 1
; 
.set k_p_in, 0
.set k_p_wei, 8
.set k_p_out, 16
.set k_hi, 24
.set k_wi, 28
.set k_n, 32
.set k_k, 36
.set k_c, 40
.set k_ho, 44
.set k_wo, 48
.set k_stride_h, 52
.set k_stride_w, 56
.set k_dilation_h, 60
.set k_dilation_w, 64
.set k_pad_h, 68
.set k_pad_w, 72
.set k_y, 76
.set k_x, 80
.set k_group, 84
.set k_magic_0, 88
.set k_magic_1, 92
.set k_magic_2, 96
.set k_magic_3, 100
.set k_magic_4, 104
.set k_magic_5, 108
.set k_shift_pack_0, 112
.set k_shift_pack_1, 116
.set k_gemm_k_global_split, 120
.set k__pack_0, 124
.set k_end, 128
.set k_gload_in_c_stride, 16

.set s_ka, 0
.set s_bx, 2
.set s_by, 3
.set s_p_in, 4
.set s_p_wei, 8
.set s_p_out, 12
.set s_hi, 16
.set s_wi, 17
.set s_n, 18
.set s_k, 19
.set s_c, 20
.set s_group, 21
.set s_in_stride_wi, 22
.set s_in_stride_n, 23
.set s_wei_stride_k0, 24
.set s_wei_stride_k, 25
.set s_out_stride_wo, 26
.set s_out_stride_n, 27
.set s_block_gtc_ig, 28
.set s_block_gtc_ik, 29
.set s_block_gtc_inb, 30
.set s_move_slice_k_stride_c, 31
.set s_knum, 3
.set s_dim_br, 32
.set s_dim_mp, 33
.set s_dim_mr, 34
.set s_dim_np, 35
.set s_gemm_k_num_c, 35
.set s_in_diff_hi, 29
.set s_in_diff_wi, 28
.set s_dilation_w_x, 36
.set s_move_slice_k_ix, 32
.set s_flag_need_acc_yx, 33
.set s_kitr, 1
.set s_0xff, 37
.set s_in_offset, 38
.set s_wei_offset, 39
.set s_magic_0, 6
.set s_magic_1, 7
.set s_magic_2, 14
.set s_magic_3, 15
.set s_shift_pack_0, 39
.set s_tmp, 40
.set s_end, 46

.set v_c, 0  ; coalescing:64, needed:0, resuable:66
.set v_a, 0
.set v_b, 16
.set v_gld_a, 24
.set v_gld_b, 40
.set v_sst_a_os, 48
.set v_sld_a_os, 49
.set v_sst_b_os, 50
.set v_sld_b_os, 51
.set v_in_os, 52
.set v_in_ihi_list, 56
.set v_in_iwi_list, 60
.set v_in_flag, 64
.set v_in_flag_n, 68
.set v_wei_os, 69
.set v_out_os, 70
.set v_gtc_ic, 71
.set v_in_inb, 72
.set v_in_in, 73
.set v_wei_ik, 74
.set v_co_sst, 73
.set v_co_sld, 75
.set v_out_flag, 74
.set v_out_inb, 72
.set v_gemm_in, 76
.set v_gemm_im, 77
.set v_co_sub_m_index, 77
.set v_co_sub_n_index, 76
.set v_tmp, 78
.set v_wei_tmp_pack, 23
.set v_wei_flag, 78
.set v_end, 212

.set a_c, 84
.set a_end, 212

.text
.globl igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64
.p2align 8
.type igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64,@function
igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64:
    s_load_dwordx2  s[s_p_in+0:s_p_in+1],    s[s_ka+0:s_ka+1],    0+k_p_in
    s_load_dwordx2  s[s_p_wei+0:s_p_wei+1],   s[s_ka+0:s_ka+1],    0+k_p_wei
    s_load_dwordx2  s[s_p_out+0:s_p_out+1],   s[s_ka+0:s_ka+1],    0+k_p_out
    s_load_dwordx4 s[s_hi+0:s_hi+3],    s[s_ka+0:s_ka+1],    0+k_hi
    s_load_dword s[s_c],    s[s_ka+0:s_ka+1],    0+k_c
    s_load_dword s[s_group],    s[s_ka+0:s_ka+1],    0+k_group
    s_load_dwordx2 s[s_magic_0+0:s_magic_0+1],  s[s_ka+0:s_ka+1],  0+k_magic_0
    s_load_dwordx2 s[s_magic_2+0:s_magic_2+1],  s[s_ka+0:s_ka+1],  0+k_magic_2
    s_load_dword s[s_shift_pack_0], s[s_ka+0:s_ka+1],  0+k_shift_pack_0
    ; in(e, c, nb0, nb1) thread_lengths: 1x16x4x1, cluster_length: 1x4x1x64, k_pack:16
    v_mov_b32 v[v_tmp], v0
    v_and_b32 v[v_gtc_ic], 3, v[v_tmp]
    v_lshlrev_b32 v[v_gtc_ic], 4, v[v_gtc_ic]
    v_lshrrev_b32 v[v_tmp], 2, v[v_tmp]
    v_and_b32 v[v_in_inb], 63, v[v_tmp]
    ; wei(e, c, k0, k1) thread_length: 1x16x2x1, cluster_length: 1x4x1x64, k_pack:16
    v_lshrrev_b32 v[v_tmp], 2, v0
    v_and_b32 v[v_wei_ik], 63, v[v_tmp]

    s_mov_b32 s[s_0xff], 0xff
    s_waitcnt lgkmcnt(0)

    ; calculate index
    s_mul_i32 s[s_in_stride_wi], s[s_c], s[s_group]
    s_mul_i32 s[s_tmp+2], s[s_wi], s[s_in_stride_wi]
    s_mul_i32 s[s_in_stride_n], s[s_hi], s[s_tmp+2]
    s_mov_b32 s[s_wei_stride_k], s[s_c]
    s_lshl_b32 s[s_wei_stride_k0], s[s_wei_stride_k], 6
    s_mul_i32 s[s_out_stride_wo], s[s_k], s[s_group]
    s_mul_i32 s[s_tmp+1], s[s_wi], s[s_out_stride_wo]
    s_mul_i32 s[s_out_stride_n], s[s_hi], s[s_tmp+1]
    s_mul_i32  s[s_tmp], s[s_n], s[s_in_stride_n]
    s_mul_i32  s[s_tmp+1], s[s_n], s[s_out_stride_n]
    s_lshl_b32 s[s_tmp+4], s[s_tmp], 0
    s_lshl_b32 s[s_tmp+5], s[s_tmp+1], 0
    s_mul_i32 s[s_tmp], s[s_by], s[s_tmp+4]
    s_mul_hi_u32 s[s_tmp+1], s[s_by], s[s_tmp+4]
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], s[s_tmp+1]
    s_mul_i32 s[s_tmp], s[s_by], s[s_tmp+5]
    s_mul_hi_u32 s[s_tmp+1], s[s_by], s[s_tmp+5]
    s_add_u32 s[s_p_out], s[s_p_out], s[s_tmp]
    s_addc_u32 s[s_p_out+1], s[s_p_out+1], s[s_tmp+1]
    s_mov_b32 s[s_knum], s[s_wei_stride_k]
    s_mul_i32 s[s_dim_br], s[s_hi], s[s_wi]
    s_mul_i32 s[s_dim_mr], s[s_n], s[s_dim_br]
    s_add_u32 s[s_tmp], 255, s[s_dim_mr]
    s_lshr_b32 s[s_tmp+1], s[s_tmp], 8
    s_lshl_b32 s[s_dim_mp], s[s_tmp+1], 8
    s_add_u32 s[s_tmp], 127, s[s_k]
    s_lshr_b32 s[s_tmp+1], s[s_tmp], 7
    s_lshl_b32 s[s_dim_np], s[s_tmp+1], 7

    ; gemm_m_per_block:256, gemm_n_per_block:128, source_access_order:0
    s_lshr_b32 s[s_tmp], s[s_dim_mp], 8
    s_lshr_b32 s[s_tmp+1], s[s_dim_np], 7
    s_mul_i32 s[0], s[s_tmp+1], s[s_tmp]
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080018 ; offset:24, width:8
    .mdiv_u32_rem_ss s_tmp+4,s_block_gtc_ig,s_bx,s_magic_3,s_tmp+3,0,s_tmp
    s_mov_b32 s[s_bx], s[s_tmp+4]
    s_lshr_b32 s[0], s[s_dim_np], 7
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080000 ; offset:0, width:8
    .mdiv_u32_rem_ss s_tmp+4,s_tmp+5,s_bx,s_magic_0,s_tmp+3,0,s_tmp
    ; s_tmp+4:block_gtc_in, s_tmp+5:block_gtc_im
    s_lshl_b32 s[s_block_gtc_ik], s[s_tmp+4], 7
    s_lshl_b32 s[s_block_gtc_inb], s[s_tmp+5], 8
    v_add_u32 v[v_tmp+5], s[s_block_gtc_inb], v[v_in_inb]
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080008 ; offset:8, width:8
    .mdiv_u32_rem_vs v_tmp+4,v_in_in,v_tmp+5,s_magic_1,s_tmp+3,s_dim_br,v_tmp
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080010 ; offset:16, width:8
    .mdiv_u32_rem_vs v_in_iwi_list,v_in_ihi_list,v_tmp+4,s_magic_2,s_tmp+3,s_wi,v_tmp
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp], 0, 1, vcc
    v_lshlrev_b32 v[v_in_flag_n], 0, v[v_tmp]
    s_lshl_b32 s[s_block_gtc_ig], s[s_block_gtc_ig], 0
    ; calculate wei offset
    s_mul_i32 s[s_tmp+2], s[s_k], s[s_wei_stride_k]
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_tmp+2]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_tmp+2]
    s_add_u32 s[s_p_wei], s[s_p_wei], s[s_tmp]
    s_addc_u32 s[s_p_wei+1], s[s_p_wei+1], s[s_tmp+1]
    v_add_u32 v[v_tmp+5], s[s_block_gtc_ik], v[v_wei_ik]
    v_mul_lo_u32 v[v_tmp], s[s_wei_stride_k], v[v_tmp+5]
    v_add_lshl_u32 v[v_wei_os], v[v_tmp], v[v_gtc_ic], 0
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp+5]
    v_cndmask_b32 v[v_wei_flag], 0, 1, vcc
    v_mov_b32 v[v_wei_tmp_pack], v[v_wei_flag]
    s_mov_b32 s[s_tmp], 64
    v_add_u32 v[v_tmp+5], s[s_tmp], v[v_tmp+5]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp+5]
    v_cndmask_b32 v[v_wei_flag+1], 0, 1, vcc
    v_lshl_or_b32 v[v_wei_tmp_pack], v[v_wei_flag+1], 1, v[v_wei_tmp_pack]

    s_lshl_b32 s[s_wei_stride_k0], s[s_wei_stride_k0], 0

    
    .v_clear_nc v_gld_b, 8
    s_mov_b32 s[s_p_wei+2], 0xffffffff
    s_mov_b32 s[s_p_wei+3], 0x27000
    ; load weight
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dwordx4 v[v_gld_b:v_gld_b+3], v[v_wei_os], s[s_p_wei:s_p_wei+3], 0 offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dwordx4 v[v_gld_b+4:v_gld_b+4+3], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_stride_k0] offen offset:0
    s_mov_b64 exec, -1

    ; calculate in offset
    s_mov_b32 s[s_in_offset], 0
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_c]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_c]
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], s[s_tmp+1]

    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    s_lshl_b32 s[s_in_stride_wi], s[s_in_stride_wi], 0
    v_add_lshl_u32 v[v_tmp+4], v[v_gtc_ic], v[v_tmp+1], 0
    v_mul_lo_u32 v[v_tmp], s[s_wi], v[v_in_ihi_list]
    v_add_u32 v[v_tmp], v[v_in_iwi_list], v[v_tmp]
    v_mul_lo_u32 v[v_tmp], s[s_in_stride_wi], v[v_tmp]
    v_add_u32 v[v_in_os], v[v_tmp+4], v[v_tmp]
    v_bfe_u32 v[v_tmp+1], v[v_in_flag_n],  0, 1
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi_list]
    v_cndmask_b32 v[v_in_flag], 0, v[v_tmp+1], vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi_list]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag], vcc

    s_mov_b32 s1, 64
    v_add_u32 v[v_tmp], s1, v[v_in_inb]
    v_add_u32 v[v_tmp+5], s[s_block_gtc_inb], v[v_tmp]
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080008 ; offset:8, width:8
    .mdiv_u32_rem_vs v_tmp+4,v_in_in,v_tmp+5,s_magic_1,s_tmp+3,s_dim_br,v_tmp
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080010 ; offset:16, width:8
    .mdiv_u32_rem_vs v_in_iwi_list+1,v_in_ihi_list+1,v_tmp+4,s_magic_2,s_tmp+3,s_wi,v_tmp
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_lshl_u32 v[v_tmp+4], v[v_gtc_ic], v[v_tmp+1], 0
    v_mul_lo_u32 v[v_tmp], s[s_wi], v[v_in_ihi_list+1]
    v_add_u32 v[v_tmp], v[v_in_iwi_list+1], v[v_tmp]
    v_mul_lo_u32 v[v_tmp], s[s_in_stride_wi], v[v_tmp]
    v_add_u32 v[v_in_os+1], v[v_tmp+4], v[v_tmp]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp], 0, 1, vcc
    v_lshl_or_b32 v[v_in_flag_n], v[v_tmp], 1, v[v_in_flag_n]
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi_list+1]
    v_cndmask_b32 v[v_in_flag+1], 0, v[v_tmp], vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi_list+1]
    v_cndmask_b32 v[v_in_flag+1], 0, v[v_in_flag+1], vcc
    s_mov_b32 s1, 128
    v_add_u32 v[v_tmp], s1, v[v_in_inb]
    v_add_u32 v[v_tmp+5], s[s_block_gtc_inb], v[v_tmp]
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080008 ; offset:8, width:8
    .mdiv_u32_rem_vs v_tmp+4,v_in_in,v_tmp+5,s_magic_1,s_tmp+3,s_dim_br,v_tmp
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080010 ; offset:16, width:8
    .mdiv_u32_rem_vs v_in_iwi_list+2,v_in_ihi_list+2,v_tmp+4,s_magic_2,s_tmp+3,s_wi,v_tmp
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_lshl_u32 v[v_tmp+4], v[v_gtc_ic], v[v_tmp+1], 0
    v_mul_lo_u32 v[v_tmp], s[s_wi], v[v_in_ihi_list+2]
    v_add_u32 v[v_tmp], v[v_in_iwi_list+2], v[v_tmp]
    v_mul_lo_u32 v[v_tmp], s[s_in_stride_wi], v[v_tmp]
    v_add_u32 v[v_in_os+2], v[v_tmp+4], v[v_tmp]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp], 0, 1, vcc
    v_lshl_or_b32 v[v_in_flag_n], v[v_tmp], 2, v[v_in_flag_n]
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi_list+2]
    v_cndmask_b32 v[v_in_flag+2], 0, v[v_tmp], vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi_list+2]
    v_cndmask_b32 v[v_in_flag+2], 0, v[v_in_flag+2], vcc
    s_mov_b32 s1, 192
    v_add_u32 v[v_tmp], s1, v[v_in_inb]
    v_add_u32 v[v_tmp+5], s[s_block_gtc_inb], v[v_tmp]
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080008 ; offset:8, width:8
    .mdiv_u32_rem_vs v_tmp+4,v_in_in,v_tmp+5,s_magic_1,s_tmp+3,s_dim_br,v_tmp
    s_bfe_u32 s[s_tmp+3], s[s_shift_pack_0], 0x00080010 ; offset:16, width:8
    .mdiv_u32_rem_vs v_in_iwi_list+3,v_in_ihi_list+3,v_tmp+4,s_magic_2,s_tmp+3,s_wi,v_tmp
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_n], v[v_in_in]
    v_add_lshl_u32 v[v_tmp+4], v[v_gtc_ic], v[v_tmp+1], 0
    v_mul_lo_u32 v[v_tmp], s[s_wi], v[v_in_ihi_list+3]
    v_add_u32 v[v_tmp], v[v_in_iwi_list+3], v[v_tmp]
    v_mul_lo_u32 v[v_tmp], s[s_in_stride_wi], v[v_tmp]
    v_add_u32 v[v_in_os+3], v[v_tmp+4], v[v_tmp]
    v_cmp_gt_u32 vcc, s[s_n], v[v_in_in]
    v_cndmask_b32 v[v_tmp], 0, 1, vcc
    v_lshl_or_b32 v[v_in_flag_n], v[v_tmp], 3, v[v_in_flag_n]
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi_list+3]
    v_cndmask_b32 v[v_in_flag+3], 0, v[v_tmp], vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi_list+3]
    v_cndmask_b32 v[v_in_flag+3], 0, v[v_in_flag+3], vcc
    s_mov_b32 s[s_p_in+2], 0xffffffff
    s_mov_b32 s[s_p_in+3], 0x27000
    ; load input, nxe:0
    .v_clear_nc v_gld_a, 16
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_load_dwordx4 v[v_gld_a:v_gld_a+3], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_in_flag+1]
    buffer_load_dwordx4 v[v_gld_a+4:v_gld_a+4+3], v[v_in_os+1], s[s_p_in:s_p_in+3], s[s_in_offset] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_in_flag+2]
    buffer_load_dwordx4 v[v_gld_a+8:v_gld_a+8+3], v[v_in_os+2], s[s_p_in:s_p_in+3], s[s_in_offset] offen offset:0
    s_mov_b64 exec, -1
    v_cmpx_le_u32 vcc, 1, v[v_in_flag+3]
    buffer_load_dwordx4 v[v_gld_a+12:v_gld_a+12+3], v[v_in_os+3], s[s_p_in:s_p_in+3], s[s_in_offset] offen offset:0
    s_mov_b64 exec, -1

    v_mov_b32 v[v_tmp+5], v0
    ; xdlops mapping, get source matrix gemm index, k_pack:16, v_pack:1, k_pack_per_thread:2
    v_and_b32 v[v_gemm_in], 31, v[v_tmp+5]           ; block_n index 
    v_and_b32 v[v_gemm_im], 31, v[v_tmp+5]           ; block_m index 
    v_lshlrev_b32 v[v_gemm_in], 4, v[v_gemm_in]   ; shift left k_pack:16
    v_lshlrev_b32 v[v_gemm_im], 4, v[v_gemm_im]   ; shift left k_pack:16
    v_lshrrev_b32 v[v_tmp+5], 5, v[v_tmp+5]
    v_and_b32 v[v_tmp + 0], 1, v[v_tmp+5]          ; block_k_per_wave index
    v_lshl_or_b32 v[v_gemm_in],  v[v_tmp + 0], 3, v[v_gemm_in]  ; or lanegroup_k_per_thread:8
    v_lshl_or_b32 v[v_gemm_im],  v[v_tmp + 0], 3, v[v_gemm_im]  ; or lanegroup_k_per_thread:8
    v_lshrrev_b32 v[v_tmp+5], 1, v[v_tmp+5]
    v_and_b32 v[v_tmp + 2], 1, v[v_tmp+5]  ; waves_per_n index
    v_lshl_or_b32 v[v_gemm_in], v[v_tmp + 2], 9, v[v_gemm_in]
    v_lshrrev_b32 v[v_tmp+5], 1, v[v_tmp+5]
    v_and_b32 v[v_tmp + 3], 1, v[v_tmp+5]  ; waves_per_m index
    v_lshl_or_b32 v[v_gemm_im], v[v_tmp + 3], 10, v[v_gemm_im]

    v_mov_b32 v[v_tmp+5], v0
    ; xdlops mapping, get dst matrix gemm index
    v_and_b32 v[v_tmp+0], 31, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 5, v[v_tmp+5]
    v_and_b32 v[v_tmp+1], 1, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 1, v[v_tmp+5]
    v_mov_b32 v[v_co_sst], v[v_tmp+0]
    v_lshlrev_b32 v[v_co_sld], 2, v[v_tmp+1]
    v_and_b32 v[v_tmp+0], 1, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 1, v[v_tmp+5]
    v_and_b32 v[v_tmp+1], 1, v[v_tmp+5]
    v_lshl_or_b32 v[v_co_sst], v[v_tmp+0], 5, v[v_co_sst]
    v_lshl_or_b32 v[v_co_sld], v[v_tmp+1], 6, v[v_co_sld]

    ; LDS store, in: e,c,nb0,nb1: 1x16x4x1, 1x4x1x64, k_pack:16, k_pack_gld_a:16, int8
    v_lshlrev_b32 v[v_tmp+2], 4,  v[v_in_inb]
    v_lshrrev_b32 v[v_tmp+1], 4,  v[v_gtc_ic]
    v_lshl_or_b32 v[v_tmp], v[v_tmp+1], 12, v[v_tmp+2]
    v_lshlrev_b32 v[v_sst_a_os], 0, v[v_tmp]

    v_lshlrev_b32 v[v_sld_a_os], 0, v[v_gemm_im] ; LDS load in
    ; LDS store, wei: e,c,k: 1x16x2x1, 1x4x1x64, k_pack:16, k_pack_gld_b:16, int8
    v_lshlrev_b32 v[v_tmp+2], 4,  v[v_wei_ik]
    v_lshrrev_b32 v[v_tmp+1], 4,  v[v_gtc_ic]
    v_lshl_or_b32 v[v_tmp], v[v_tmp+1], 11, v[v_tmp+2]
    v_lshlrev_b32 v[v_sst_b_os], 0, v[v_tmp]
    v_add_u32 v[v_sst_b_os], 16384, v[v_sst_b_os]

    v_lshlrev_b32 v[v_sld_b_os], 0, v[v_gemm_in] ; LDS load wei
    v_add_u32 v[v_sld_b_os], 16384, v[v_sld_b_os]
    v_mov_b32 v[v_gemm_in], v[v_co_sst]
    v_mov_b32 v[v_gemm_im], v[v_co_sld]
    ; init_co_lds_offset for xdlops
    v_lshrrev_b32 v[v_tmp], 2, v[v_gemm_im]
    v_and_b32 v[v_tmp],  1 v[v_tmp]   ; thread id of lanegroup_m_per_cluster
    v_lshlrev_b32 v[v_co_sst], 2, v[v_tmp]
    v_lshrrev_b32 v[v_tmp+2], 6, v[v_gemm_im]  ; thread id of waves_per_m
    v_lshl_or_b32 v[v_co_sst], v[v_tmp+2], 6, v[v_co_sst]
    v_lshl_or_b32 v[v_co_sst], v[v_co_sst], 7, v[v_gemm_in]
    v_lshlrev_b32 v[v_co_sst], 0, v[v_co_sst]
    v_lshlrev_b32 v[v_co_sld], 4, v[0]
    ; init_co_sub_m_index xdlops, block_size:256, macro-tile:256x128 sub_m_index:[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31]
    ; g_mr:1, g_ms:1, g_mw:1, g_mb:1, g_mt:1 | l_mr:2, l_ms:2, l_mw:1, l_mb:4, l_mt:4 | n_mc:2, n_ml:1, n_mv:2
    ; nd_stride:[4, 2, 1, 4, 1, 2, 2, 1]
    v_lshlrev_b32 v[v_tmp], 4, v[0]
    v_lshrrev_b32 v[v_co_sub_m_index], 7, v[v_tmp]  ; get tid along m
    v_and_b32 v[v_tmp+0], 3, v[v_co_sub_m_index]                   ; => x_mt
    v_lshrrev_b32 v[v_co_sub_m_index], 2  ,v[v_co_sub_m_index]
    v_and_b32 v[v_tmp+1], 1, v[v_co_sub_m_index]                   ; => x_mc
    v_lshrrev_b32 v[v_co_sub_m_index], 1  ,v[v_co_sub_m_index]
    v_and_b32 v[v_tmp+2], 3, v[v_co_sub_m_index]                   ; => x_mb
    v_mov_b32 v[v_co_sub_m_index], v[v_tmp+0]      ; => accumulate x_mt
    v_lshl_or_b32 v[v_co_sub_m_index], v[v_tmp+1], 2, v[v_co_sub_m_index]      ; => accumulate x_mc
    v_lshl_or_b32 v[v_co_sub_m_index], v[v_tmp+2], 3, v[v_co_sub_m_index]      ; => accumulate x_mb
    ; init_co_sub_n_index xdlops
    v_lshlrev_b32 v[v_tmp], 4, v[0]
    v_and_b32 v[v_co_sub_n_index], 127, v[v_tmp]

    v_add_u32 v[v_tmp], s[s_block_gtc_ik], v[v_co_sub_n_index]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp]
    v_cndmask_b32 v[v_out_flag], 0, 1, vcc
    ; output offset
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_k]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_k]
    s_add_u32 s[s_p_out], s[s_p_out], s[s_tmp]
    s_addc_u32 s[s_p_out+1], s[s_p_out+1], s[s_tmp+1]

    s_lshl_b32 s[s_tmp+3], s[s_block_gtc_ik], 0
    s_add_u32 s[s_p_out], s[s_p_out], s[s_tmp+3]
    s_addc_u32 s[s_p_out+1], s[s_p_out+1], 0

    s_lshl_b32 s[s_out_stride_wo], s[s_out_stride_wo], 0
    v_add_u32 v[v_out_inb], s[s_block_gtc_inb], v[v_co_sub_m_index]   ; total n*ho*wo
    v_mul_lo_u32 v[v_out_os], s[s_out_stride_wo], v[v_out_inb]
    v_lshlrev_b32 v[v_tmp], 0, v[v_co_sub_n_index]
    v_add_u32 v[v_out_os], v[v_out_os], v[v_tmp]
    ; move slice stride
    s_lshl_b32 s[s_gemm_k_num_c], s[s_c], 0
    v_bfe_u32 v[v_wei_flag], v[v_wei_tmp_pack], 0, 1
    s_mov_b32 s[s_move_slice_k_stride_c], 64
    v_bfe_u32 v[v_wei_flag+1], v[v_wei_tmp_pack], 1, 1

    s_mov_b32 s[s_p_out+2], 0xffffffff
    s_mov_b32 s[s_p_out+3], 0x27000
    ; start MFMA loop, 32x32 wave tile with 2x2 repeat, 2x1 step, k_pack:16
    s_waitcnt vmcnt(4)
    ds_write_b128 v[v_sst_b_os], v[v_gld_b+0:v_gld_b+0+3] 
    ds_write_b128 v[v_sst_b_os], v[v_gld_b+4:v_gld_b+4+3] offset:1024

    s_waitcnt vmcnt(0)
    ds_write_b128 v[v_sst_a_os], v[v_gld_a+0:v_gld_a+0+3] 
    ds_write_b128 v[v_sst_a_os], v[v_gld_a+4:v_gld_a+4+3] offset:1024
    ds_write_b128 v[v_sst_a_os], v[v_gld_a+8:v_gld_a+8+3] offset:2048
    ds_write_b128 v[v_sst_a_os], v[v_gld_a+12:v_gld_a+12+3] offset:3072

    .v_clear_nc a_c, 128
    ; make sure acc WAR harzard, at least 1 nop for src_c
    s_sub_i32 s[s_kitr], s[s_knum], 64
    s_cmp_gt_i32 s[s_kitr], 0
    s_cbranch_scc0 L_igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64_mfma_end

    s_add_u32 s[s_in_offset],  s[s_move_slice_k_stride_c], s[s_in_offset]
    v_add_u32 v[v_wei_os], s[s_move_slice_k_stride_c], v[v_wei_os]

    
    s_waitcnt lgkmcnt(0)
    s_barrier
    ds_read2_b64 v[v_a+0:v_a+3], v[v_sld_a_os], offset0:0, offset1:64
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:0
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:1024
    ds_read2st64_b64 v[v_a+4+0:v_a+4+3], v[v_sld_a_os], offset0:4, offset1:5
L_igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64_mfma_body:
    ; do fma accumulate with unroll 64
    s_waitcnt lgkmcnt(2)
    v_mfma_i32_32x32x16i8 v[a_c+0:a_c+15], v[v_a+0:v_a+1], v[v_b+0:v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, num_a_c:16
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag]
    buffer_load_dwordx4 v[v_gld_b:v_gld_b+3], v[v_wei_os], s[s_p_wei:s_p_wei+3], 0 offen offset:0
    s_mov_b64 exec, -1
    v_mfma_i32_32x32x16i8 v[a_c+16:a_c+31], v[v_a+2:v_a+3], v[v_b+0:v_b+1], v[a_c+16:a_c+31]     ; repeat:0x0, step:1x0, num_a_c:16
    v_cmpx_le_u32 vcc, 1, v[v_wei_flag+1]
    buffer_load_dwordx4 v[v_gld_b+4:v_gld_b+4+3], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_wei_stride_k0] offen offset:0
    s_mov_b64 exec, -1
    ds_read2st64_b64 v[v_a+8+0:v_a+8+3], v[v_sld_a_os], offset0:8, offset1:9 ; load i_k:1 into local buffer 1, repeat 0
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:2048 ; load i_k:1 into local buffer 1, repeat 0
    s_waitcnt lgkmcnt(3)
    v_mfma_i32_32x32x16i8 v[a_c+32:a_c+47], v[v_a+0:v_a+1], v[v_b+2:v_b+3], v[a_c+32:a_c+47]     ; repeat:0x1, step:0x0, num_a_c:16
    .v_clear_nc v_gld_a, 16
    v_mfma_i32_32x32x16i8 v[a_c+48:a_c+63], v[v_a+2:v_a+3], v[v_b+2:v_b+3], v[a_c+48:a_c+63]     ; repeat:0x1, step:1x0, num_a_c:16
    v_cmpx_le_u32 vcc, 1, v[v_in_flag]
    buffer_load_dwordx4 v[v_gld_a:v_gld_a+3], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset] offen offset:0
    s_mov_b64 exec, -1
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:3072 ; load i_k:1 into local buffer 1, repeat 1
    ds_read2st64_b64 v[v_a+12+0:v_a+12+3], v[v_sld_a_os], offset0:12, offset1:13 ; load i_k:1 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(4)
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+4:v_a+5], v[v_b+0:v_b+1], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    v_cmpx_le_u32 vcc, 1, v[v_in_flag+1]
    buffer_load_dwordx4 v[v_gld_a+4:v_gld_a+4+3], v[v_in_os+1], s[s_p_in:s_p_in+3], s[s_in_offset] offen offset:0
    s_mov_b64 exec, -1
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+6:v_a+7], v[v_b+0:v_b+1], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16
    v_cmpx_le_u32 vcc, 1, v[v_in_flag+2]
    buffer_load_dwordx4 v[v_gld_a+8:v_gld_a+8+3], v[v_in_os+2], s[s_p_in:s_p_in+3], s[s_in_offset] offen offset:0
    s_mov_b64 exec, -1
    ds_read2st64_b64 v[v_a+0:v_a+3], v[v_sld_a_os], offset0:16, offset1:17 ; load i_k:2 into local buffer 0, repeat 0
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:4096 ; load i_k:2 into local buffer 0, repeat 0
    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+4:v_a+5], v[v_b+2:v_b+3], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    v_cmpx_le_u32 vcc, 1, v[v_in_flag+3]
    buffer_load_dwordx4 v[v_gld_a+12:v_gld_a+12+3], v[v_in_os+3], s[s_p_in:s_p_in+3], s[s_in_offset] offen offset:0
    s_mov_b64 exec, -1
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+6:v_a+7], v[v_b+2:v_b+3], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16
    s_add_u32 s[s_in_offset],  s[s_move_slice_k_stride_c], s[s_in_offset]
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:5120 ; load i_k:2 into local buffer 0, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_i32_32x32x16i8 v[a_c+0:a_c+15], v[v_a+8:v_a+9], v[v_b+4:v_b+5], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, num_a_c:16
    v_add_u32 v[v_wei_os], s[s_move_slice_k_stride_c], v[v_wei_os]
    v_mfma_i32_32x32x16i8 v[a_c+16:a_c+31], v[v_a+10:v_a+11], v[v_b+4:v_b+5], v[a_c+16:a_c+31]     ; repeat:0x0, step:1x0, num_a_c:16
    
    ds_read2st64_b64 v[v_a+4+0:v_a+4+3], v[v_sld_a_os], offset0:20, offset1:21 ; load i_k:2 into local buffer 0, repeat 1
    s_waitcnt lgkmcnt(5)
    v_mfma_i32_32x32x16i8 v[a_c+32:a_c+47], v[v_a+8:v_a+9], v[v_b+6:v_b+7], v[a_c+32:a_c+47]     ; repeat:0x1, step:0x0, num_a_c:16
    
    v_mfma_i32_32x32x16i8 v[a_c+48:a_c+63], v[v_a+10:v_a+11], v[v_b+6:v_b+7], v[a_c+48:a_c+63]     ; repeat:0x1, step:1x0, num_a_c:16
    
    ds_read2st64_b64 v[v_a+8+0:v_a+8+3], v[v_sld_a_os], offset0:24, offset1:25 ; load i_k:3 into local buffer 1, repeat 0
    s_waitcnt lgkmcnt(5)
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+12:v_a+13], v[v_b+4:v_b+5], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+14:v_a+15], v[v_b+4:v_b+5], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16
    
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:6144 ; load i_k:3 into local buffer 1, repeat 0
    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+12:v_a+13], v[v_b+6:v_b+7], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+14:v_a+15], v[v_b+6:v_b+7], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16
    
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:7168 ; load i_k:3 into local buffer 1, repeat 1
    ds_read2st64_b64 v[v_a+12+0:v_a+12+3], v[v_sld_a_os], offset0:28, offset1:29 ; load i_k:3 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(6)
    v_mfma_i32_32x32x16i8 v[a_c+0:a_c+15], v[v_a+0:v_a+1], v[v_b+0:v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, num_a_c:16
    
    v_mfma_i32_32x32x16i8 v[a_c+16:a_c+31], v[v_a+2:v_a+3], v[v_b+0:v_b+1], v[a_c+16:a_c+31]     ; repeat:0x0, step:1x0, num_a_c:16
    
    s_waitcnt lgkmcnt(5)
    v_mfma_i32_32x32x16i8 v[a_c+32:a_c+47], v[v_a+0:v_a+1], v[v_b+2:v_b+3], v[a_c+32:a_c+47]     ; repeat:0x1, step:0x0, num_a_c:16
    
    v_mfma_i32_32x32x16i8 v[a_c+48:a_c+63], v[v_a+2:v_a+3], v[v_b+2:v_b+3], v[a_c+48:a_c+63]     ; repeat:0x1, step:1x0, num_a_c:16
    
    s_waitcnt lgkmcnt(4)
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+4:v_a+5], v[v_b+0:v_b+1], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+6:v_a+7], v[v_b+0:v_b+1], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16
    
    s_waitcnt lgkmcnt(0)
    s_barrier
    s_waitcnt vmcnt(4)
    ds_write_b128 v[v_sst_b_os], v[v_gld_b+0:v_gld_b+0+3]
    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+4:v_a+5], v[v_b+2:v_b+3], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    ds_write_b128 v[v_sst_b_os], v[v_gld_b+4:v_gld_b+4+3] offset:1024
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+6:v_a+7], v[v_b+2:v_b+3], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16
    s_waitcnt vmcnt(0)
    ds_write_b128 v[v_sst_a_os], v[v_gld_a+0:v_gld_a+0+3]
    v_mfma_i32_32x32x16i8 v[a_c+0:a_c+15], v[v_a+8:v_a+9], v[v_b+4:v_b+5], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, num_a_c:16
    ds_write_b128 v[v_sst_a_os], v[v_gld_a+4:v_gld_a+4+3] offset:1024
    v_mfma_i32_32x32x16i8 v[a_c+16:a_c+31], v[v_a+10:v_a+11], v[v_b+4:v_b+5], v[a_c+16:a_c+31]     ; repeat:0x0, step:1x0, num_a_c:16
    ds_write_b128 v[v_sst_a_os], v[v_gld_a+8:v_gld_a+8+3] offset:2048
    v_mfma_i32_32x32x16i8 v[a_c+32:a_c+47], v[v_a+8:v_a+9], v[v_b+6:v_b+7], v[a_c+32:a_c+47]     ; repeat:0x1, step:0x0, num_a_c:16
    ds_write_b128 v[v_sst_a_os], v[v_gld_a+12:v_gld_a+12+3] offset:3072
    v_mfma_i32_32x32x16i8 v[a_c+48:a_c+63], v[v_a+10:v_a+11], v[v_b+6:v_b+7], v[a_c+48:a_c+63]     ; repeat:0x1, step:1x0, num_a_c:16
    s_sub_i32 s[s_kitr], s[s_kitr], 64
    s_cmp_gt_i32 s[s_kitr], 0
    s_cbranch_scc0 L_igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64_mfma_finishing
    s_waitcnt lgkmcnt(0)
    s_barrier
    ds_read2_b64 v[v_a+0:v_a+3], v[v_sld_a_os], offset0:0, offset1:64
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:0
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+12:v_a+13], v[v_b+4:v_b+5], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+14:v_a+15], v[v_b+4:v_b+5], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:1024
    ds_read2st64_b64 v[v_a+4+0:v_a+4+3], v[v_sld_a_os], offset0:4, offset1:5
    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+12:v_a+13], v[v_b+6:v_b+7], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+14:v_a+15], v[v_b+6:v_b+7], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16
    s_branch L_igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64_mfma_body
L_igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64_mfma_finishing:
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+12:v_a+13], v[v_b+4:v_b+5], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+14:v_a+15], v[v_b+4:v_b+5], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16

    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+12:v_a+13], v[v_b+6:v_b+7], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+14:v_a+15], v[v_b+6:v_b+7], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16

L_igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64_mfma_end:
    s_waitcnt lgkmcnt(0)
    s_barrier
    ds_read2_b64 v[v_a+0:v_a+3], v[v_sld_a_os], offset0:0, offset1:64
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:0
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:1024
    ds_read2st64_b64 v[v_a+4+0:v_a+4+3], v[v_sld_a_os], offset0:4, offset1:5
    ; k iteration : 0
    s_waitcnt lgkmcnt(2)
    v_mfma_i32_32x32x16i8 v[a_c+0:a_c+15], v[v_a+0:v_a+1], v[v_b+0:v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+16:a_c+31], v[v_a+2:v_a+3], v[v_b+0:v_b+1], v[a_c+16:a_c+31]     ; repeat:0x0, step:1x0, num_a_c:16
    ds_read2st64_b64 v[v_a+8+0:v_a+8+3], v[v_sld_a_os], offset0:8, offset1:9 ; load i_k:1 into local buffer 1, repeat 0
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:2048 ; load i_k:1 into local buffer 1, repeat 0

    s_waitcnt lgkmcnt(3)
    v_mfma_i32_32x32x16i8 v[a_c+32:a_c+47], v[v_a+0:v_a+1], v[v_b+2:v_b+3], v[a_c+32:a_c+47]     ; repeat:0x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+48:a_c+63], v[v_a+2:v_a+3], v[v_b+2:v_b+3], v[a_c+48:a_c+63]     ; repeat:0x1, step:1x0, num_a_c:16
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:3072 ; load i_k:1 into local buffer 1, repeat 1
    ds_read2st64_b64 v[v_a+12+0:v_a+12+3], v[v_sld_a_os], offset0:12, offset1:13 ; load i_k:1 into local buffer 1, repeat 1

    s_waitcnt lgkmcnt(4)
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+4:v_a+5], v[v_b+0:v_b+1], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+6:v_a+7], v[v_b+0:v_b+1], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16
    ds_read2st64_b64 v[v_a+0:v_a+3], v[v_sld_a_os], offset0:16, offset1:17 ; load i_k:2 into local buffer 0, repeat 0
    ds_read_b64 v[v_b:v_b+1], v[v_sld_b_os] offset:4096 ; load i_k:2 into local buffer 0, repeat 0

    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+4:v_a+5], v[v_b+2:v_b+3], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+6:v_a+7], v[v_b+2:v_b+3], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16
    ds_read_b64 v[v_b+2:v_b+2+1], v[v_sld_b_os] offset:5120 ; load i_k:2 into local buffer 0, repeat 1

    ; k iteration : 1
    s_waitcnt lgkmcnt(5)
    v_mfma_i32_32x32x16i8 v[a_c+0:a_c+15], v[v_a+8:v_a+9], v[v_b+4:v_b+5], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+16:a_c+31], v[v_a+10:v_a+11], v[v_b+4:v_b+5], v[a_c+16:a_c+31]     ; repeat:0x0, step:1x0, num_a_c:16
    ds_read2st64_b64 v[v_a+4+0:v_a+4+3], v[v_sld_a_os], offset0:20, offset1:21 ; load i_k:2 into local buffer 0, repeat 1

    s_waitcnt lgkmcnt(5)
    v_mfma_i32_32x32x16i8 v[a_c+32:a_c+47], v[v_a+8:v_a+9], v[v_b+6:v_b+7], v[a_c+32:a_c+47]     ; repeat:0x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+48:a_c+63], v[v_a+10:v_a+11], v[v_b+6:v_b+7], v[a_c+48:a_c+63]     ; repeat:0x1, step:1x0, num_a_c:16
    ds_read2st64_b64 v[v_a+8+0:v_a+8+3], v[v_sld_a_os], offset0:24, offset1:25 ; load i_k:3 into local buffer 1, repeat 0

    s_waitcnt lgkmcnt(5)
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+12:v_a+13], v[v_b+4:v_b+5], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+14:v_a+15], v[v_b+4:v_b+5], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16
    ds_read_b64 v[v_b+4:v_b+4+1], v[v_sld_b_os] offset:6144 ; load i_k:3 into local buffer 1, repeat 0

    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+12:v_a+13], v[v_b+6:v_b+7], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+14:v_a+15], v[v_b+6:v_b+7], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16
    ds_read_b64 v[v_b+6:v_b+6+1], v[v_sld_b_os] offset:7168 ; load i_k:3 into local buffer 1, repeat 1
    ds_read2st64_b64 v[v_a+12+0:v_a+12+3], v[v_sld_a_os], offset0:28, offset1:29 ; load i_k:3 into local buffer 1, repeat 1
    s_waitcnt lgkmcnt(6)
    v_mfma_i32_32x32x16i8 v[a_c+0:a_c+15], v[v_a+0:v_a+1], v[v_b+0:v_b+1], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+16:a_c+31], v[v_a+2:v_a+3], v[v_b+0:v_b+1], v[a_c+16:a_c+31]     ; repeat:0x0, step:1x0, num_a_c:16

    s_waitcnt lgkmcnt(5)
    v_mfma_i32_32x32x16i8 v[a_c+32:a_c+47], v[v_a+0:v_a+1], v[v_b+2:v_b+3], v[a_c+32:a_c+47]     ; repeat:0x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+48:a_c+63], v[v_a+2:v_a+3], v[v_b+2:v_b+3], v[a_c+48:a_c+63]     ; repeat:0x1, step:1x0, num_a_c:16

    s_waitcnt lgkmcnt(4)
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+4:v_a+5], v[v_b+0:v_b+1], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+6:v_a+7], v[v_b+0:v_b+1], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16

    ; k iteration : 62
    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+4:v_a+5], v[v_b+2:v_b+3], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+6:v_a+7], v[v_b+2:v_b+3], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16
    ; k iteration : 63
    s_waitcnt lgkmcnt(2)
    v_mfma_i32_32x32x16i8 v[a_c+0:a_c+15], v[v_a+8:v_a+9], v[v_b+4:v_b+5], v[a_c+0:a_c+15]     ; repeat:0x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+16:a_c+31], v[v_a+10:v_a+11], v[v_b+4:v_b+5], v[a_c+16:a_c+31]     ; repeat:0x0, step:1x0, num_a_c:16

    s_waitcnt lgkmcnt(1)
    v_mfma_i32_32x32x16i8 v[a_c+32:a_c+47], v[v_a+8:v_a+9], v[v_b+6:v_b+7], v[a_c+32:a_c+47]     ; repeat:0x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+48:a_c+63], v[v_a+10:v_a+11], v[v_b+6:v_b+7], v[a_c+48:a_c+63]     ; repeat:0x1, step:1x0, num_a_c:16

    s_waitcnt lgkmcnt(0)
    v_mfma_i32_32x32x16i8 v[a_c+64:a_c+79], v[v_a+12:v_a+13], v[v_b+4:v_b+5], v[a_c+64:a_c+79]     ; repeat:1x0, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+80:a_c+95], v[v_a+14:v_a+15], v[v_b+4:v_b+5], v[a_c+80:a_c+95]     ; repeat:1x0, step:1x0, num_a_c:16

    v_mfma_i32_32x32x16i8 v[a_c+96:a_c+111], v[v_a+12:v_a+13], v[v_b+6:v_b+7], v[a_c+96:a_c+111]     ; repeat:1x1, step:0x0, num_a_c:16
    v_mfma_i32_32x32x16i8 v[a_c+112:a_c+127], v[v_a+14:v_a+15], v[v_b+6:v_b+7], v[a_c+112:a_c+127]     ; repeat:1x1, step:1x0, num_a_c:16

    s_nop 9
    ; coalescing store, mapping:mt_m:256, mt_n:128, wt_m:32, wt_n:32, ws:4, r_m:2, r_n:2, s_m:2, s_n:1 | 32x32x16, lanegroup_m_tcbw:4x2x4x1, lanegroup_n_tcbw:1x32x1x1
    ; coalescing_groups:1, num_dword_per_group:128
    ; init_co_sub_m_index xdlops, block_size:256, macro-tile:256x128 sub_m_index:[0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31]
    ; g_mr:1, g_ms:1, g_mw:1, g_mb:1, g_mt:1 | l_mr:2, l_ms:2, l_mw:1, l_mb:4, l_mt:4 | n_mc:2, n_ml:1, n_mv:2
    ; nd_stride:[2, 1, 4, 1, 2, 2, 1]
    ; start group 0, i_g_mr:0, i_g_ms:0, i_g_mw:0, i_g_mb:0, i_g_mt:0, m index start from 0
    s_barrier
    ds_write_b8 v[v_co_sst], v[a_c]  ; idword:0(0,0), 0x0, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+1] offset:128 ; idword:0(0,0), 0x0, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+2] offset:256 ; idword:0(0,0), 0x0, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+3] offset:384 ; idword:0(0,0), 0x0, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+32] offset:64 ; idword:64(0,64), 0x64, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+33] offset:192 ; idword:64(0,64), 0x64, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+34] offset:320 ; idword:64(0,64), 0x64, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+35] offset:448 ; idword:64(0,64), 0x64, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+4] offset:1024 ; idword:1024(8,0), 8x0, i_mr:0, i_ms:0, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+5] offset:1152 ; idword:1024(8,0), 8x0, i_mr:0, i_ms:0, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+6] offset:1280 ; idword:1024(8,0), 8x0, i_mr:0, i_ms:0, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+7] offset:1408 ; idword:1024(8,0), 8x0, i_mr:0, i_ms:0, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+36] offset:1088 ; idword:1088(8,64), 8x64, i_mr:0, i_ms:0, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+37] offset:1216 ; idword:1088(8,64), 8x64, i_mr:0, i_ms:0, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+38] offset:1344 ; idword:1088(8,64), 8x64, i_mr:0, i_ms:0, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+39] offset:1472 ; idword:1088(8,64), 8x64, i_mr:0, i_ms:0, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+8] offset:2048 ; idword:2048(16,0), 16x0, i_mr:0, i_ms:0, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+9] offset:2176 ; idword:2048(16,0), 16x0, i_mr:0, i_ms:0, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+10] offset:2304 ; idword:2048(16,0), 16x0, i_mr:0, i_ms:0, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+11] offset:2432 ; idword:2048(16,0), 16x0, i_mr:0, i_ms:0, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+40] offset:2112 ; idword:2112(16,64), 16x64, i_mr:0, i_ms:0, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+41] offset:2240 ; idword:2112(16,64), 16x64, i_mr:0, i_ms:0, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+42] offset:2368 ; idword:2112(16,64), 16x64, i_mr:0, i_ms:0, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+43] offset:2496 ; idword:2112(16,64), 16x64, i_mr:0, i_ms:0, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+12] offset:3072 ; idword:3072(24,0), 24x0, i_mr:0, i_ms:0, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+13] offset:3200 ; idword:3072(24,0), 24x0, i_mr:0, i_ms:0, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+14] offset:3328 ; idword:3072(24,0), 24x0, i_mr:0, i_ms:0, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+15] offset:3456 ; idword:3072(24,0), 24x0, i_mr:0, i_ms:0, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+44] offset:3136 ; idword:3136(24,64), 24x64, i_mr:0, i_ms:0, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+45] offset:3264 ; idword:3136(24,64), 24x64, i_mr:0, i_ms:0, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+46] offset:3392 ; idword:3136(24,64), 24x64, i_mr:0, i_ms:0, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+47] offset:3520 ; idword:3136(24,64), 24x64, i_mr:0, i_ms:0, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+16] offset:4096 ; idword:4096(32,0), 32x0, i_mr:0, i_ms:1, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+17] offset:4224 ; idword:4096(32,0), 32x0, i_mr:0, i_ms:1, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+18] offset:4352 ; idword:4096(32,0), 32x0, i_mr:0, i_ms:1, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+19] offset:4480 ; idword:4096(32,0), 32x0, i_mr:0, i_ms:1, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+48] offset:4160 ; idword:4160(32,64), 32x64, i_mr:0, i_ms:1, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+49] offset:4288 ; idword:4160(32,64), 32x64, i_mr:0, i_ms:1, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+50] offset:4416 ; idword:4160(32,64), 32x64, i_mr:0, i_ms:1, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+51] offset:4544 ; idword:4160(32,64), 32x64, i_mr:0, i_ms:1, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+20] offset:5120 ; idword:5120(40,0), 40x0, i_mr:0, i_ms:1, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+21] offset:5248 ; idword:5120(40,0), 40x0, i_mr:0, i_ms:1, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+22] offset:5376 ; idword:5120(40,0), 40x0, i_mr:0, i_ms:1, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+23] offset:5504 ; idword:5120(40,0), 40x0, i_mr:0, i_ms:1, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+52] offset:5184 ; idword:5184(40,64), 40x64, i_mr:0, i_ms:1, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+53] offset:5312 ; idword:5184(40,64), 40x64, i_mr:0, i_ms:1, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+54] offset:5440 ; idword:5184(40,64), 40x64, i_mr:0, i_ms:1, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+55] offset:5568 ; idword:5184(40,64), 40x64, i_mr:0, i_ms:1, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+24] offset:6144 ; idword:6144(48,0), 48x0, i_mr:0, i_ms:1, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+25] offset:6272 ; idword:6144(48,0), 48x0, i_mr:0, i_ms:1, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+26] offset:6400 ; idword:6144(48,0), 48x0, i_mr:0, i_ms:1, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+27] offset:6528 ; idword:6144(48,0), 48x0, i_mr:0, i_ms:1, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+56] offset:6208 ; idword:6208(48,64), 48x64, i_mr:0, i_ms:1, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+57] offset:6336 ; idword:6208(48,64), 48x64, i_mr:0, i_ms:1, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+58] offset:6464 ; idword:6208(48,64), 48x64, i_mr:0, i_ms:1, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+59] offset:6592 ; idword:6208(48,64), 48x64, i_mr:0, i_ms:1, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+28] offset:7168 ; idword:7168(56,0), 56x0, i_mr:0, i_ms:1, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+29] offset:7296 ; idword:7168(56,0), 56x0, i_mr:0, i_ms:1, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+30] offset:7424 ; idword:7168(56,0), 56x0, i_mr:0, i_ms:1, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+31] offset:7552 ; idword:7168(56,0), 56x0, i_mr:0, i_ms:1, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+60] offset:7232 ; idword:7232(56,64), 56x64, i_mr:0, i_ms:1, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+61] offset:7360 ; idword:7232(56,64), 56x64, i_mr:0, i_ms:1, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+62] offset:7488 ; idword:7232(56,64), 56x64, i_mr:0, i_ms:1, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+63] offset:7616 ; idword:7232(56,64), 56x64, i_mr:0, i_ms:1, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+64] offset:16384 ; idword:16384(128,0), 128x0, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+65] offset:16512 ; idword:16384(128,0), 128x0, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+66] offset:16640 ; idword:16384(128,0), 128x0, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+67] offset:16768 ; idword:16384(128,0), 128x0, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+96] offset:16448 ; idword:16448(128,64), 128x64, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+97] offset:16576 ; idword:16448(128,64), 128x64, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+98] offset:16704 ; idword:16448(128,64), 128x64, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+99] offset:16832 ; idword:16448(128,64), 128x64, i_mr:1, i_ms:0, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+68] offset:17408 ; idword:17408(136,0), 136x0, i_mr:1, i_ms:0, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+69] offset:17536 ; idword:17408(136,0), 136x0, i_mr:1, i_ms:0, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+70] offset:17664 ; idword:17408(136,0), 136x0, i_mr:1, i_ms:0, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+71] offset:17792 ; idword:17408(136,0), 136x0, i_mr:1, i_ms:0, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+100] offset:17472 ; idword:17472(136,64), 136x64, i_mr:1, i_ms:0, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+101] offset:17600 ; idword:17472(136,64), 136x64, i_mr:1, i_ms:0, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+102] offset:17728 ; idword:17472(136,64), 136x64, i_mr:1, i_ms:0, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+103] offset:17856 ; idword:17472(136,64), 136x64, i_mr:1, i_ms:0, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+72] offset:18432 ; idword:18432(144,0), 144x0, i_mr:1, i_ms:0, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+73] offset:18560 ; idword:18432(144,0), 144x0, i_mr:1, i_ms:0, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+74] offset:18688 ; idword:18432(144,0), 144x0, i_mr:1, i_ms:0, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+75] offset:18816 ; idword:18432(144,0), 144x0, i_mr:1, i_ms:0, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+104] offset:18496 ; idword:18496(144,64), 144x64, i_mr:1, i_ms:0, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+105] offset:18624 ; idword:18496(144,64), 144x64, i_mr:1, i_ms:0, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+106] offset:18752 ; idword:18496(144,64), 144x64, i_mr:1, i_ms:0, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+107] offset:18880 ; idword:18496(144,64), 144x64, i_mr:1, i_ms:0, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+76] offset:19456 ; idword:19456(152,0), 152x0, i_mr:1, i_ms:0, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+77] offset:19584 ; idword:19456(152,0), 152x0, i_mr:1, i_ms:0, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+78] offset:19712 ; idword:19456(152,0), 152x0, i_mr:1, i_ms:0, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+79] offset:19840 ; idword:19456(152,0), 152x0, i_mr:1, i_ms:0, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+108] offset:19520 ; idword:19520(152,64), 152x64, i_mr:1, i_ms:0, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+109] offset:19648 ; idword:19520(152,64), 152x64, i_mr:1, i_ms:0, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+110] offset:19776 ; idword:19520(152,64), 152x64, i_mr:1, i_ms:0, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+111] offset:19904 ; idword:19520(152,64), 152x64, i_mr:1, i_ms:0, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+80] offset:20480 ; idword:20480(160,0), 160x0, i_mr:1, i_ms:1, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+81] offset:20608 ; idword:20480(160,0), 160x0, i_mr:1, i_ms:1, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+82] offset:20736 ; idword:20480(160,0), 160x0, i_mr:1, i_ms:1, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+83] offset:20864 ; idword:20480(160,0), 160x0, i_mr:1, i_ms:1, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+112] offset:20544 ; idword:20544(160,64), 160x64, i_mr:1, i_ms:1, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+113] offset:20672 ; idword:20544(160,64), 160x64, i_mr:1, i_ms:1, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+114] offset:20800 ; idword:20544(160,64), 160x64, i_mr:1, i_ms:1, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+115] offset:20928 ; idword:20544(160,64), 160x64, i_mr:1, i_ms:1, i_mw:0, i_mb:0  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+84] offset:21504 ; idword:21504(168,0), 168x0, i_mr:1, i_ms:1, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+85] offset:21632 ; idword:21504(168,0), 168x0, i_mr:1, i_ms:1, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+86] offset:21760 ; idword:21504(168,0), 168x0, i_mr:1, i_ms:1, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+87] offset:21888 ; idword:21504(168,0), 168x0, i_mr:1, i_ms:1, i_mw:0, i_mb:1  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+116] offset:21568 ; idword:21568(168,64), 168x64, i_mr:1, i_ms:1, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+117] offset:21696 ; idword:21568(168,64), 168x64, i_mr:1, i_ms:1, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+118] offset:21824 ; idword:21568(168,64), 168x64, i_mr:1, i_ms:1, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+119] offset:21952 ; idword:21568(168,64), 168x64, i_mr:1, i_ms:1, i_mw:0, i_mb:1  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+88] offset:22528 ; idword:22528(176,0), 176x0, i_mr:1, i_ms:1, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+89] offset:22656 ; idword:22528(176,0), 176x0, i_mr:1, i_ms:1, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+90] offset:22784 ; idword:22528(176,0), 176x0, i_mr:1, i_ms:1, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+91] offset:22912 ; idword:22528(176,0), 176x0, i_mr:1, i_ms:1, i_mw:0, i_mb:2  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+120] offset:22592 ; idword:22592(176,64), 176x64, i_mr:1, i_ms:1, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+121] offset:22720 ; idword:22592(176,64), 176x64, i_mr:1, i_ms:1, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+122] offset:22848 ; idword:22592(176,64), 176x64, i_mr:1, i_ms:1, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+123] offset:22976 ; idword:22592(176,64), 176x64, i_mr:1, i_ms:1, i_mw:0, i_mb:2  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+92] offset:23552 ; idword:23552(184,0), 184x0, i_mr:1, i_ms:1, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+93] offset:23680 ; idword:23552(184,0), 184x0, i_mr:1, i_ms:1, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+94] offset:23808 ; idword:23552(184,0), 184x0, i_mr:1, i_ms:1, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+95] offset:23936 ; idword:23552(184,0), 184x0, i_mr:1, i_ms:1, i_mw:0, i_mb:3  x  i_nr:0, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+124] offset:23616 ; idword:23616(184,64), 184x64, i_mr:1, i_ms:1, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+125] offset:23744 ; idword:23616(184,64), 184x64, i_mr:1, i_ms:1, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+126] offset:23872 ; idword:23616(184,64), 184x64, i_mr:1, i_ms:1, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    ds_write_b8 v[v_co_sst], v[a_c+127] offset:24000 ; idword:23616(184,64), 184x64, i_mr:1, i_ms:1, i_mw:0, i_mb:3  x  i_nr:1, i_ns:0, i_nw:0
    s_mov_b32 s[s_tmp], 0   ; i_m:0(i_m0:0,i_m1:0)
    v_add_u32 v[v_out_inb], s[s_block_gtc_inb], v[v_co_sub_m_index]
    v_mov_b32 v[v_tmp], v[v_out_inb]
    s_waitcnt lgkmcnt(0)
    s_barrier
    ;   load from lds, i_ssgroup:0, num_sld_per_ssgroup:4
    ds_read_b128 v[v_c:v_c+3], v[v_co_sld] offset:0
    ds_read_b128 v[v_c+4:v_c+4+3], v[v_co_sld] offset:4096
    ds_read_b128 v[v_c+8:v_c+8+3], v[v_co_sld] offset:8192
    ds_read_b128 v[v_c+12:v_c+12+3], v[v_co_sld] offset:12288
    v_cmpx_eq_u32 vcc, 1, v[v_out_flag]
    ;   store to global, m index start from 0, m0:0, m1:0
    s_waitcnt lgkmcnt(3)
    v_cmp_gt_u32 vcc, s[s_dim_mr], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_store_dwordx4_m v[v_c:v_c+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 32, s[s_out_stride_wo]   ; i_m:32(i_m0:0,i_m1:32)
    v_add_u32 v[v_tmp], 32, v[v_out_inb]
    s_waitcnt lgkmcnt(2)
    v_cmp_gt_u32 vcc, s[s_dim_mr], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_store_dwordx4_m v[v_c+4:v_c+4+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 64, s[s_out_stride_wo]   ; i_m:64(i_m0:1,i_m1:0)
    v_add_u32 v[v_tmp], 64, v[v_out_inb]
    s_waitcnt lgkmcnt(1)
    v_cmp_gt_u32 vcc, s[s_dim_mr], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_store_dwordx4_m v[v_c+8:v_c+8+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 96, s[s_out_stride_wo]   ; i_m:96(i_m0:1,i_m1:32)
    v_add_u32 v[v_tmp], 96, v[v_out_inb]
    s_waitcnt lgkmcnt(0)
    v_cmp_gt_u32 vcc, s[s_dim_mr], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_store_dwordx4_m v[v_c+12:v_c+12+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 128, s[s_out_stride_wo]   ; i_m:128(i_m0:2,i_m1:0)
    v_add_u32 v[v_tmp], 128, v[v_out_inb]
    s_mov_b64 exec, -1
    ;   load from lds, i_ssgroup:1, num_sld_per_ssgroup:4
    ds_read_b128 v[v_c:v_c+3], v[v_co_sld] offset:16384
    ds_read_b128 v[v_c+4:v_c+4+3], v[v_co_sld] offset:20480
    ds_read_b128 v[v_c+8:v_c+8+3], v[v_co_sld] offset:24576
    ds_read_b128 v[v_c+12:v_c+12+3], v[v_co_sld] offset:28672
    v_cmpx_eq_u32 vcc, 1, v[v_out_flag]
    ;   store to global, m index start from 0, m0:0, m1:0
    s_waitcnt lgkmcnt(3)
    v_cmp_gt_u32 vcc, s[s_dim_mr], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_store_dwordx4_m v[v_c:v_c+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 160, s[s_out_stride_wo]   ; i_m:160(i_m0:2,i_m1:32)
    v_add_u32 v[v_tmp], 160, v[v_out_inb]
    s_waitcnt lgkmcnt(2)
    v_cmp_gt_u32 vcc, s[s_dim_mr], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_store_dwordx4_m v[v_c+4:v_c+4+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 192, s[s_out_stride_wo]   ; i_m:192(i_m0:3,i_m1:0)
    v_add_u32 v[v_tmp], 192, v[v_out_inb]
    s_waitcnt lgkmcnt(1)
    v_cmp_gt_u32 vcc, s[s_dim_mr], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_store_dwordx4_m v[v_c+8:v_c+8+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mul_i32 s[s_tmp], 224, s[s_out_stride_wo]   ; i_m:224(i_m0:3,i_m1:32)
    v_add_u32 v[v_tmp], 224, v[v_out_inb]
    s_waitcnt lgkmcnt(0)
    v_cmp_gt_u32 vcc, s[s_dim_mr], v[v_tmp]
    s_and_saveexec_b64 s[s_tmp+4:s_tmp+5], vcc
    buffer_store_dwordx4_m v[v_c+12:v_c+12+3], v[v_out_os], s[s_p_out:s_p_out+3], s[s_tmp] offen offset:0
    s_or_b64 exec, exec, s[s_tmp+4:s_tmp+5]
    s_mov_b64 exec, -1
L_igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64_out:
    s_endpgm
.rodata
.p2align 6
.amdhsa_kernel igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64
    .amdhsa_group_segment_fixed_size 32768
    .amdhsa_user_sgpr_kernarg_segment_ptr 1
    .amdhsa_system_sgpr_workgroup_id_x 1
    .amdhsa_system_sgpr_workgroup_id_y 1
    .amdhsa_system_vgpr_workitem_id 0
    .amdhsa_next_free_vgpr 212
    .amdhsa_next_free_sgpr 46
    .amdhsa_ieee_mode 1
    .amdhsa_dx10_clamp 1
    .amdhsa_float_round_mode_32 3
    .amdhsa_float_round_mode_16_64 3
    .amdhsa_tg_split 0
    .amdhsa_accum_offset 84
.end_amdhsa_kernel

.amdgpu_metadata
---
amdhsa.version: [ 1, 0 ]
amdhsa.kernels:
  - .name: igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64
    .symbol: igemm_fwd_gtcx35_nhwc_int8_bx0_ex0_bt256x128x64_wt32x32x16_ws2x1_wr2x2_ta1x16x4x1_1x4x1x64_tb1x16x2x1_1x4x1x64.kd
    .sgpr_count: 52
    .vgpr_count: 212
    .kernarg_segment_align: 8
    .kernarg_segment_size: 128
    .group_segment_fixed_size: 32768
    .private_segment_fixed_size: 0
    .wavefront_size: 64
    .reqd_workgroup_size : [256, 1, 1]
    .max_flat_workgroup_size: 256
    .args:
    - { .name: p_in_     , .size: 8, .offset:   0, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: true}
    - { .name: p_wei_    , .size: 8, .offset:   8, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: true}
    - { .name: p_out_    , .size: 8, .offset:  16, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: false}
    - { .name: hi_       , .size: 4, .offset:  24, .value_kind: by_value, .value_type: i32}
    - { .name: wi_       , .size: 4, .offset:  28, .value_kind: by_value, .value_type: i32}
    - { .name: n_        , .size: 4, .offset:  32, .value_kind: by_value, .value_type: i32}
    - { .name: k_        , .size: 4, .offset:  36, .value_kind: by_value, .value_type: i32}
    - { .name: c_        , .size: 4, .offset:  40, .value_kind: by_value, .value_type: i32}
    - { .name: ho_       , .size: 4, .offset:  44, .value_kind: by_value, .value_type: i32}
    - { .name: wo_       , .size: 4, .offset:  48, .value_kind: by_value, .value_type: i32}
    - { .name: stride_h_ , .size: 4, .offset:  52, .value_kind: by_value, .value_type: i32}
    - { .name: stride_w_ , .size: 4, .offset:  56, .value_kind: by_value, .value_type: i32}
    - { .name: dilation_h_, .size: 4, .offset:  60, .value_kind: by_value, .value_type: i32}
    - { .name: dilation_w_, .size: 4, .offset:  64, .value_kind: by_value, .value_type: i32}
    - { .name: pad_h_    , .size: 4, .offset:  68, .value_kind: by_value, .value_type: i32}
    - { .name: pad_w_    , .size: 4, .offset:  72, .value_kind: by_value, .value_type: i32}
    - { .name: y_        , .size: 4, .offset:  76, .value_kind: by_value, .value_type: i32}
    - { .name: x_        , .size: 4, .offset:  80, .value_kind: by_value, .value_type: i32}
    - { .name: group_    , .size: 4, .offset:  84, .value_kind: by_value, .value_type: i32}
    - { .name: magic_0_  , .size: 4, .offset:  88, .value_kind: by_value, .value_type: i32}
    - { .name: magic_1_  , .size: 4, .offset:  92, .value_kind: by_value, .value_type: i32}
    - { .name: magic_2_  , .size: 4, .offset:  96, .value_kind: by_value, .value_type: i32}
    - { .name: magic_3_  , .size: 4, .offset: 100, .value_kind: by_value, .value_type: i32}
    - { .name: magic_4_  , .size: 4, .offset: 104, .value_kind: by_value, .value_type: i32}
    - { .name: magic_5_  , .size: 4, .offset: 108, .value_kind: by_value, .value_type: i32}
    - { .name: shift_pack_0_, .size: 4, .offset: 112, .value_kind: by_value, .value_type: i32}
    - { .name: shift_pack_1_, .size: 4, .offset: 116, .value_kind: by_value, .value_type: i32}
    - { .name: gemm_k_split_, .size: 4, .offset: 120, .value_kind: by_value, .value_type: i32}
    - { .name: __pack_0_ , .size: 4, .offset: 124, .value_kind: by_value, .value_type: i32}
...
.end_amdgpu_metadata
