/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.core.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuthResources {
    public static final Set<String> projectTypes = new HashSet<String>(Arrays.asList("adhoc", "job", "node", "storage"));
    public static final Set<String> projectKinds = new HashSet<String>(Arrays.asList("job", "node", "event", "webhook"));
    public static final Set<String> appTypes = new HashSet<String>(Arrays.asList("project", "project_acl", "storage", "apitoken"));
    public static final Set<String> appKinds = new HashSet<String>(Arrays.asList("project", "system", "system_acl", "user", "job", "apitoken", "plugin", "webhook"));
    public static final List<String> appProjectActions = Arrays.asList("admin", "app_admin", "read", "configure", "delete", "import", "export", "delete_execution", "scm_import", "scm_export");
    public static final List<String> appProjectAclActions = Arrays.asList("read", "create", "update", "delete", "admin", "app_admin");
    public static final List<String> storageActions = Arrays.asList("create", "read", "update", "delete");
    public static final List<String> appApitokenActions = Collections.singletonList("create");
    public static final List<String> appProjectKindActions = Collections.singletonList("create");
    public static final List<String> appSystemKindActions = Arrays.asList("read", "enable_executions", "disable_executions", "admin", "app_admin", "ops_admin");
    public static final List<String> appSystemAclKindActions = Arrays.asList("read", "create", "update", "delete", "admin", "app_admin", "ops_admin");
    public static final List<String> appUserKindActions = Arrays.asList("admin", "app_admin");
    public static final List<String> appJobKindActions = Arrays.asList("admin", "app_admin", "ops_admin");
    public static final List<String> appApitokenKindActions = Arrays.asList("admin", "app_admin", "generate_user_token", "generate_service_token");
    public static final Map<String, List<String>> appResActionsByType;
    public static final Map<String, List<String>> appResAttrsByType;
    public static final List<String> appPluginActions;
    public static final List<String> appRunnerActions;
    public static final List<String> appRunnerKindActions;
    public static final List<String> appWebhookKindActions;
    public static final Map<String, List<String>> appKindActionsByType;
    public static final List<String> projectJobActions;
    public static final List<String> projectJobKindActions;
    public static final List<String> projectAdhocActions;
    public static final List<String> projectNodeActions;
    public static final Map<String, List<String>> projResActionsByType;
    public static final Map<String, List<String>> projResAttrsByType;
    public static final List<String> projectNodeKindActions;
    public static final List<String> projectEventKindActions;
    public static final Map<String, List<String>> projKindActionsByType;
    static final List<String> projectWebhookKindActions;

    static {
        appPluginActions = Arrays.asList("read", "install", "uninstall", "admin", "app_admin", "ops_admin");
        appRunnerActions = Arrays.asList("read", "create", "update", "delete", "ping", "regenerate_credentials");
        appRunnerKindActions = Arrays.asList("read", "admin");
        appWebhookKindActions = Arrays.asList("read", "create", "update", "delete", "post", "admin", "app_admin");
        appResActionsByType = new HashMap<String, List<String>>();
        appResActionsByType.put("project", appProjectActions);
        appResActionsByType.put("project_acl", appProjectAclActions);
        appResActionsByType.put("storage", storageActions);
        appResActionsByType.put("apitoken", appApitokenActions);
        appResActionsByType.put("runner", appRunnerActions);
        appResAttrsByType = new HashMap<String, List<String>>();
        appResAttrsByType.put("project", Collections.singletonList("name"));
        appResAttrsByType.put("project_acl", Collections.singletonList("name"));
        appResAttrsByType.put("storage", Arrays.asList("path", "name"));
        appResAttrsByType.put("apitoken", Arrays.asList("username", "roles"));
        appResAttrsByType.put("runner", Arrays.asList("username", "roles"));
        appKindActionsByType = new HashMap<String, List<String>>();
        appKindActionsByType.put("project", appProjectKindActions);
        appKindActionsByType.put("system", appSystemKindActions);
        appKindActionsByType.put("system_acl", appSystemAclKindActions);
        appKindActionsByType.put("user", appUserKindActions);
        appKindActionsByType.put("job", appJobKindActions);
        appKindActionsByType.put("apitoken", appApitokenKindActions);
        appKindActionsByType.put("plugin", appPluginActions);
        appKindActionsByType.put("runner", appRunnerKindActions);
        appKindActionsByType.put("webhook", appWebhookKindActions);
        projectJobActions = Arrays.asList("read", "view", "update", "delete", "run", "runAs", "kill", "killAs", "create", "toggle_execution", "toggle_schedule", "scm_update", "scm_create", "scm_delete", "view_history");
        projectJobKindActions = Arrays.asList("create", "delete");
        projectAdhocActions = Arrays.asList("read", "view", "run", "runAs", "kill", "killAs");
        projectNodeActions = Arrays.asList("read", "run");
        projResActionsByType = new HashMap<String, List<String>>();
        projResActionsByType.put("job", projectJobActions);
        projResActionsByType.put("adhoc", projectAdhocActions);
        projResActionsByType.put("node", projectNodeActions);
        projResActionsByType.put("storage", storageActions);
        projResAttrsByType = new HashMap<String, List<String>>();
        projResAttrsByType.put("job", Arrays.asList("group", "name", "uuid"));
        projResAttrsByType.put("adhoc", new ArrayList());
        List<String> nodeAttributeNames = Arrays.asList("nodename", "rundeck_server", "username", "hostname", "osFamily", "osVersion", "(etc. any node attribute)");
        projResAttrsByType.put("node", nodeAttributeNames);
        projResAttrsByType.put("storage", Arrays.asList("path", "name"));
        projectNodeKindActions = Arrays.asList("read", "create", "update", "refresh");
        projectEventKindActions = Arrays.asList("read", "create");
        projectWebhookKindActions = Arrays.asList("read", "create", "update", "delete", "admin", "app_admin", "post");
        projKindActionsByType = new HashMap<String, List<String>>();
        projKindActionsByType.put("job", projectJobKindActions);
        projKindActionsByType.put("node", projectNodeKindActions);
        projKindActionsByType.put("event", projectEventKindActions);
        projKindActionsByType.put("webhook", projectWebhookKindActions);
        projKindActionsByType.put("storage", storageActions);
    }
}

