/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.eyde.personalblog.service.CachedObject;
import net.eyde.personalblog.service.CostComparator;

public class CacheManager {
    public static final int LRU = 0;
    public static final int LFU = 1;
    public static final int MIX = 2;
    private HashMap<String, CachedObject> cacheHashMap = new HashMap();
    private int CACHE_CAPACITY = 100;
    private int TRESHOLD = 90;
    private int purgeAlgorithm;
    private long hitCount = 0L;
    private long missCount = 0L;

    public CacheManager(int purgeAlgorithm, int cacheCapacity, int treshold) {
        this.purgeAlgorithm = purgeAlgorithm;
        this.CACHE_CAPACITY = cacheCapacity;
        this.TRESHOLD = treshold;
    }

    public CacheManager(int purgeAlgorithm) {
        this.purgeAlgorithm = purgeAlgorithm;
    }

    public synchronized Object getCache(String identifier) {
        CachedObject cachedObject = this.cacheHashMap.get(identifier);
        Object obj = null;
        if (cachedObject == null) {
            ++this.missCount;
        } else if (cachedObject.isExpired()) {
            this.cacheHashMap.remove(identifier);
            ++this.missCount;
        } else {
            cachedObject.incNumAccess();
            cachedObject.setLastAccessTime(new Date());
            ++this.hitCount;
            obj = cachedObject.getObject();
        }
        return obj;
    }

    public synchronized void invalidate(String identifier) {
        this.cacheHashMap.remove(identifier);
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getCurrentCacheSize() {
        return this.cacheHashMap.size();
    }

    public synchronized void putCache(Object object, String id, int minutesToLive) {
        CachedObject cachedObject = new CachedObject(object, id, minutesToLive);
        if (this.cacheHashMap.size() == this.CACHE_CAPACITY) {
            this.sweep();
        }
        this.cacheHashMap.put(id, cachedObject);
    }

    public synchronized void sweep() {
        TreeMap<Double, String> costTreeMap = new TreeMap<Double, String>(new CostComparator());
        for (Map.Entry<String, CachedObject> entry : this.cacheHashMap.entrySet()) {
            CachedObject cachedObject = entry.getValue();
            if (cachedObject.isExpired()) {
                this.cacheHashMap.remove(entry.getKey());
                continue;
            }
            double cost = 0.0;
            switch (this.purgeAlgorithm) {
                case 1: {
                    cost = cachedObject.getLFUCost();
                    break;
                }
                case 0: {
                    cost = cachedObject.getLRUCost();
                    break;
                }
                default: {
                    cost = cachedObject.getMixCost();
                }
            }
            costTreeMap.put(new Double(cost), entry.getKey());
        }
        int i = this.cacheHashMap.size();
        while (i > this.TRESHOLD) {
            Double kk = costTreeMap.firstKey();
            Object k = costTreeMap.get(kk);
            this.cacheHashMap.remove(k);
            costTreeMap.remove(kk);
            --i;
        }
    }

    public void clearCache() {
        this.hitCount = 0L;
        this.missCount = 0L;
        this.cacheHashMap.clear();
    }

    public static String createKey(String[] keys) {
        StringBuffer newKey = new StringBuffer("");
        int i = 0;
        while (i < keys.length) {
            newKey.append(keys[i]).append("/");
            ++i;
        }
        return newKey.toString();
    }
}

