/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.util;

import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public interface Elements {
    public PackageElement getPackageElement(CharSequence var1);

    default public PackageElement getPackageElement(ModuleElement moduleElement, CharSequence charSequence) {
        return null;
    }

    default public Set<? extends PackageElement> getAllPackageElements(CharSequence charSequence) {
        Set<? extends ModuleElement> set = this.getAllModuleElements();
        if (set.isEmpty()) {
            PackageElement packageElement = this.getPackageElement(charSequence);
            return packageElement != null ? Collections.singleton(packageElement) : Collections.emptySet();
        }
        LinkedHashSet<PackageElement> linkedHashSet = new LinkedHashSet<PackageElement>(1);
        for (ModuleElement moduleElement : set) {
            PackageElement packageElement = this.getPackageElement(moduleElement, charSequence);
            if (packageElement == null) continue;
            linkedHashSet.add(packageElement);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public TypeElement getTypeElement(CharSequence var1);

    default public TypeElement getTypeElement(ModuleElement moduleElement, CharSequence charSequence) {
        return null;
    }

    default public Set<? extends TypeElement> getAllTypeElements(CharSequence charSequence) {
        Set<? extends ModuleElement> set = this.getAllModuleElements();
        if (set.isEmpty()) {
            TypeElement typeElement = this.getTypeElement(charSequence);
            return typeElement != null ? Collections.singleton(typeElement) : Collections.emptySet();
        }
        LinkedHashSet<TypeElement> linkedHashSet = new LinkedHashSet<TypeElement>(1);
        for (ModuleElement moduleElement : set) {
            TypeElement typeElement = this.getTypeElement(moduleElement, charSequence);
            if (typeElement == null) continue;
            linkedHashSet.add(typeElement);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    default public ModuleElement getModuleElement(CharSequence charSequence) {
        return null;
    }

    default public Set<? extends ModuleElement> getAllModuleElements() {
        return Collections.emptySet();
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror var1);

    public String getDocComment(Element var1);

    public boolean isDeprecated(Element var1);

    default public Origin getOrigin(Element element) {
        return Origin.EXPLICIT;
    }

    default public Origin getOrigin(AnnotatedConstruct annotatedConstruct, AnnotationMirror annotationMirror) {
        return Origin.EXPLICIT;
    }

    default public Origin getOrigin(ModuleElement moduleElement, ModuleElement.Directive directive) {
        return Origin.EXPLICIT;
    }

    default public boolean isBridge(ExecutableElement executableElement) {
        return false;
    }

    public Name getBinaryName(TypeElement var1);

    public PackageElement getPackageOf(Element var1);

    default public ModuleElement getModuleOf(Element element) {
        return null;
    }

    public List<? extends Element> getAllMembers(TypeElement var1);

    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element var1);

    public boolean hides(Element var1, Element var2);

    public boolean overrides(ExecutableElement var1, ExecutableElement var2, TypeElement var3);

    public String getConstantExpression(Object var1);

    public void printElements(Writer var1, Element ... var2);

    public Name getName(CharSequence var1);

    public boolean isFunctionalInterface(TypeElement var1);

    public static enum Origin {
        EXPLICIT,
        MANDATED,
        SYNTHETIC;


        public boolean isDeclared() {
            return this != SYNTHETIC;
        }
    }
}

