// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"
)

// ReplaceTCPCheckBackendHandlerFunc turns a function with the right signature into a replace TCP check backend handler
type ReplaceTCPCheckBackendHandlerFunc func(ReplaceTCPCheckBackendParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn ReplaceTCPCheckBackendHandlerFunc) Handle(params ReplaceTCPCheckBackendParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// ReplaceTCPCheckBackendHandler interface for that can handle valid replace TCP check backend params
type ReplaceTCPCheckBackendHandler interface {
	Handle(ReplaceTCPCheckBackendParams, interface{}) middleware.Responder
}

// NewReplaceTCPCheckBackend creates a new http.Handler for the replace TCP check backend operation
func NewReplaceTCPCheckBackend(ctx *middleware.Context, handler ReplaceTCPCheckBackendHandler) *ReplaceTCPCheckBackend {
	return &ReplaceTCPCheckBackend{Context: ctx, Handler: handler}
}

/*
	ReplaceTCPCheckBackend swagger:route PUT /services/haproxy/configuration/backends/{parent_name}/tcp_checks/{index} TCPCheck replaceTcpCheckBackend

# Replace a TCP check

Replaces a TCP Check configuration by it's index in the specified parent.
*/
type ReplaceTCPCheckBackend struct {
	Context *middleware.Context
	Handler ReplaceTCPCheckBackendHandler
}

func (o *ReplaceTCPCheckBackend) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewReplaceTCPCheckBackendParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc.(interface{}) // this is really a interface{}, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
