// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPRequestRuleFrontendOKCode is the HTTP code returned for type ReplaceHTTPRequestRuleFrontendOK
const ReplaceHTTPRequestRuleFrontendOKCode int = 200

/*
ReplaceHTTPRequestRuleFrontendOK HTTP Request Rule replaced

swagger:response replaceHttpRequestRuleFrontendOK
*/
type ReplaceHTTPRequestRuleFrontendOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleFrontendOK creates ReplaceHTTPRequestRuleFrontendOK with default headers values
func NewReplaceHTTPRequestRuleFrontendOK() *ReplaceHTTPRequestRuleFrontendOK {

	return &ReplaceHTTPRequestRuleFrontendOK{}
}

// WithPayload adds the payload to the replace Http request rule frontend o k response
func (o *ReplaceHTTPRequestRuleFrontendOK) WithPayload(payload *models.HTTPRequestRule) *ReplaceHTTPRequestRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http request rule frontend o k response
func (o *ReplaceHTTPRequestRuleFrontendOK) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPRequestRuleFrontendAcceptedCode is the HTTP code returned for type ReplaceHTTPRequestRuleFrontendAccepted
const ReplaceHTTPRequestRuleFrontendAcceptedCode int = 202

/*
ReplaceHTTPRequestRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceHttpRequestRuleFrontendAccepted
*/
type ReplaceHTTPRequestRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleFrontendAccepted creates ReplaceHTTPRequestRuleFrontendAccepted with default headers values
func NewReplaceHTTPRequestRuleFrontendAccepted() *ReplaceHTTPRequestRuleFrontendAccepted {

	return &ReplaceHTTPRequestRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace Http request rule frontend accepted response
func (o *ReplaceHTTPRequestRuleFrontendAccepted) WithReloadID(reloadID string) *ReplaceHTTPRequestRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http request rule frontend accepted response
func (o *ReplaceHTTPRequestRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http request rule frontend accepted response
func (o *ReplaceHTTPRequestRuleFrontendAccepted) WithPayload(payload *models.HTTPRequestRule) *ReplaceHTTPRequestRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http request rule frontend accepted response
func (o *ReplaceHTTPRequestRuleFrontendAccepted) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPRequestRuleFrontendBadRequestCode is the HTTP code returned for type ReplaceHTTPRequestRuleFrontendBadRequest
const ReplaceHTTPRequestRuleFrontendBadRequestCode int = 400

/*
ReplaceHTTPRequestRuleFrontendBadRequest Bad request

swagger:response replaceHttpRequestRuleFrontendBadRequest
*/
type ReplaceHTTPRequestRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleFrontendBadRequest creates ReplaceHTTPRequestRuleFrontendBadRequest with default headers values
func NewReplaceHTTPRequestRuleFrontendBadRequest() *ReplaceHTTPRequestRuleFrontendBadRequest {

	return &ReplaceHTTPRequestRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http request rule frontend bad request response
func (o *ReplaceHTTPRequestRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPRequestRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http request rule frontend bad request response
func (o *ReplaceHTTPRequestRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http request rule frontend bad request response
func (o *ReplaceHTTPRequestRuleFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPRequestRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http request rule frontend bad request response
func (o *ReplaceHTTPRequestRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPRequestRuleFrontendNotFoundCode is the HTTP code returned for type ReplaceHTTPRequestRuleFrontendNotFound
const ReplaceHTTPRequestRuleFrontendNotFoundCode int = 404

/*
ReplaceHTTPRequestRuleFrontendNotFound The specified resource was not found

swagger:response replaceHttpRequestRuleFrontendNotFound
*/
type ReplaceHTTPRequestRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleFrontendNotFound creates ReplaceHTTPRequestRuleFrontendNotFound with default headers values
func NewReplaceHTTPRequestRuleFrontendNotFound() *ReplaceHTTPRequestRuleFrontendNotFound {

	return &ReplaceHTTPRequestRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http request rule frontend not found response
func (o *ReplaceHTTPRequestRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPRequestRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http request rule frontend not found response
func (o *ReplaceHTTPRequestRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http request rule frontend not found response
func (o *ReplaceHTTPRequestRuleFrontendNotFound) WithPayload(payload *models.Error) *ReplaceHTTPRequestRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http request rule frontend not found response
func (o *ReplaceHTTPRequestRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPRequestRuleFrontendDefault General Error

swagger:response replaceHttpRequestRuleFrontendDefault
*/
type ReplaceHTTPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPRequestRuleFrontendDefault creates ReplaceHTTPRequestRuleFrontendDefault with default headers values
func NewReplaceHTTPRequestRuleFrontendDefault(code int) *ReplaceHTTPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP request rule frontend default response
func (o *ReplaceHTTPRequestRuleFrontendDefault) WithStatusCode(code int) *ReplaceHTTPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP request rule frontend default response
func (o *ReplaceHTTPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP request rule frontend default response
func (o *ReplaceHTTPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP request rule frontend default response
func (o *ReplaceHTTPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP request rule frontend default response
func (o *ReplaceHTTPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *ReplaceHTTPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP request rule frontend default response
func (o *ReplaceHTTPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
