%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
      "XMM1": ["0xEEEEEEEEEEEEEEEE", "0xDDDDDDDDDDDDDDDD", "0x0000000000000000", "0x0000000000000000"],
      "XMM2": ["0xCCCCCCCCCCCCCCCC", "0xDDDDDDDDDDDDDDDD", "0xEEEEEEEEEEEEEEEE", "0xFFFFFFFFFFFFFFFF"],
      "XMM3": ["0xFFFFFFFFFFFFFFFF", "0xDDDDDDDDDDDDDDDD", "0x0000000000000000", "0x0000000000000000"],
      "XMM4": ["0xCCCCCCCCCCCCCCCC", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF", "0xFFFFFFFFFFFFFFFF"]
  }
}
%endif

lea rdx, [rel .data]

;; Register as DST tests
; Load inputs
vmovapd ymm1, [rdx]
vmovapd ymm2, [rdx + 32]

vmovlpd xmm1, xmm2, [rdx + 48]
vmovlpd xmm3, xmm1, [rdx + 56]

;; Store to memory test
; Overwrite beginning of data, then yank it back into a vector
; Nothing in memory should be modified except the first 64 bits.
vmovlpd [rdx], xmm2
vmovapd ymm4, [rdx]

hlt

align 4096
.data:
db 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
db 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
db 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD
db 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
