// Copyright 2025 The Sigstore Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v5.29.3
// source: rekor/v2/verifier.proto

package protobuf

import (
	v1 "github.com/sigstore/protobuf-specs/gen/pb-go/common/v1"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PublicKey contains an encoded public key
type PublicKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// DER-encoded public key
	RawBytes      []byte `protobuf:"bytes,1,opt,name=raw_bytes,json=rawBytes,proto3" json:"raw_bytes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PublicKey) Reset() {
	*x = PublicKey{}
	mi := &file_rekor_v2_verifier_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicKey) ProtoMessage() {}

func (x *PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_rekor_v2_verifier_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicKey.ProtoReflect.Descriptor instead.
func (*PublicKey) Descriptor() ([]byte, []int) {
	return file_rekor_v2_verifier_proto_rawDescGZIP(), []int{0}
}

func (x *PublicKey) GetRawBytes() []byte {
	if x != nil {
		return x.RawBytes
	}
	return nil
}

// Either a public key or a X.509 cerificiate with an embedded public key
type Verifier struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Verifier:
	//
	//	*Verifier_PublicKey
	//	*Verifier_X509Certificate
	Verifier isVerifier_Verifier `protobuf_oneof:"verifier"`
	// Key encoding and signature algorithm to use for this key
	KeyDetails    v1.PublicKeyDetails `protobuf:"varint,3,opt,name=key_details,json=keyDetails,proto3,enum=dev.sigstore.common.v1.PublicKeyDetails" json:"key_details,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Verifier) Reset() {
	*x = Verifier{}
	mi := &file_rekor_v2_verifier_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Verifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Verifier) ProtoMessage() {}

func (x *Verifier) ProtoReflect() protoreflect.Message {
	mi := &file_rekor_v2_verifier_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Verifier.ProtoReflect.Descriptor instead.
func (*Verifier) Descriptor() ([]byte, []int) {
	return file_rekor_v2_verifier_proto_rawDescGZIP(), []int{1}
}

func (x *Verifier) GetVerifier() isVerifier_Verifier {
	if x != nil {
		return x.Verifier
	}
	return nil
}

func (x *Verifier) GetPublicKey() *PublicKey {
	if x != nil {
		if x, ok := x.Verifier.(*Verifier_PublicKey); ok {
			return x.PublicKey
		}
	}
	return nil
}

func (x *Verifier) GetX509Certificate() *v1.X509Certificate {
	if x != nil {
		if x, ok := x.Verifier.(*Verifier_X509Certificate); ok {
			return x.X509Certificate
		}
	}
	return nil
}

func (x *Verifier) GetKeyDetails() v1.PublicKeyDetails {
	if x != nil {
		return x.KeyDetails
	}
	return v1.PublicKeyDetails(0)
}

type isVerifier_Verifier interface {
	isVerifier_Verifier()
}

type Verifier_PublicKey struct {
	// DER-encoded public key. Encoding method is specified by the key_details attribute
	PublicKey *PublicKey `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3,oneof"`
}

type Verifier_X509Certificate struct {
	// DER-encoded certificate
	X509Certificate *v1.X509Certificate `protobuf:"bytes,2,opt,name=x509_certificate,json=x509Certificate,proto3,oneof"`
}

func (*Verifier_PublicKey) isVerifier_Verifier() {}

func (*Verifier_X509Certificate) isVerifier_Verifier() {}

// A signature and an associated verifier
type Signature struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Content       []byte                 `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	Verifier      *Verifier              `protobuf:"bytes,2,opt,name=verifier,proto3" json:"verifier,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Signature) Reset() {
	*x = Signature{}
	mi := &file_rekor_v2_verifier_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Signature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signature) ProtoMessage() {}

func (x *Signature) ProtoReflect() protoreflect.Message {
	mi := &file_rekor_v2_verifier_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signature.ProtoReflect.Descriptor instead.
func (*Signature) Descriptor() ([]byte, []int) {
	return file_rekor_v2_verifier_proto_rawDescGZIP(), []int{2}
}

func (x *Signature) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Signature) GetVerifier() *Verifier {
	if x != nil {
		return x.Verifier
	}
	return nil
}

var File_rekor_v2_verifier_proto protoreflect.FileDescriptor

const file_rekor_v2_verifier_proto_rawDesc = "" +
	"\n" +
	"\x17rekor/v2/verifier.proto\x12\x15dev.sigstore.rekor.v2\x1a\x15sigstore_common.proto\x1a\x1fgoogle/api/field_behavior.proto\"-\n" +
	"\tPublicKey\x12 \n" +
	"\traw_bytes\x18\x01 \x01(\fB\x03\xe0A\x02R\brawBytes\"\x89\x02\n" +
	"\bVerifier\x12F\n" +
	"\n" +
	"public_key\x18\x01 \x01(\v2 .dev.sigstore.rekor.v2.PublicKeyB\x03\xe0A\x02H\x00R\tpublicKey\x12Y\n" +
	"\x10x509_certificate\x18\x02 \x01(\v2'.dev.sigstore.common.v1.X509CertificateB\x03\xe0A\x02H\x00R\x0fx509Certificate\x12N\n" +
	"\vkey_details\x18\x03 \x01(\x0e2(.dev.sigstore.common.v1.PublicKeyDetailsB\x03\xe0A\x02R\n" +
	"keyDetailsB\n" +
	"\n" +
	"\bverifier\"l\n" +
	"\tSignature\x12\x1d\n" +
	"\acontent\x18\x01 \x01(\fB\x03\xe0A\x02R\acontent\x12@\n" +
	"\bverifier\x18\x02 \x01(\v2\x1f.dev.sigstore.rekor.v2.VerifierB\x03\xe0A\x02R\bverifierB~\n" +
	"\x1bdev.sigstore.proto.rekor.v2B\x0fRekorV2VerifierP\x01Z6github.com/sigstore/rekor-tiles/pkg/generated/protobuf\xea\x02\x13Sigstore::Rekor::V2b\x06proto3"

var (
	file_rekor_v2_verifier_proto_rawDescOnce sync.Once
	file_rekor_v2_verifier_proto_rawDescData []byte
)

func file_rekor_v2_verifier_proto_rawDescGZIP() []byte {
	file_rekor_v2_verifier_proto_rawDescOnce.Do(func() {
		file_rekor_v2_verifier_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_rekor_v2_verifier_proto_rawDesc), len(file_rekor_v2_verifier_proto_rawDesc)))
	})
	return file_rekor_v2_verifier_proto_rawDescData
}

var file_rekor_v2_verifier_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_rekor_v2_verifier_proto_goTypes = []any{
	(*PublicKey)(nil),          // 0: dev.sigstore.rekor.v2.PublicKey
	(*Verifier)(nil),           // 1: dev.sigstore.rekor.v2.Verifier
	(*Signature)(nil),          // 2: dev.sigstore.rekor.v2.Signature
	(*v1.X509Certificate)(nil), // 3: dev.sigstore.common.v1.X509Certificate
	(v1.PublicKeyDetails)(0),   // 4: dev.sigstore.common.v1.PublicKeyDetails
}
var file_rekor_v2_verifier_proto_depIdxs = []int32{
	0, // 0: dev.sigstore.rekor.v2.Verifier.public_key:type_name -> dev.sigstore.rekor.v2.PublicKey
	3, // 1: dev.sigstore.rekor.v2.Verifier.x509_certificate:type_name -> dev.sigstore.common.v1.X509Certificate
	4, // 2: dev.sigstore.rekor.v2.Verifier.key_details:type_name -> dev.sigstore.common.v1.PublicKeyDetails
	1, // 3: dev.sigstore.rekor.v2.Signature.verifier:type_name -> dev.sigstore.rekor.v2.Verifier
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_rekor_v2_verifier_proto_init() }
func file_rekor_v2_verifier_proto_init() {
	if File_rekor_v2_verifier_proto != nil {
		return
	}
	file_rekor_v2_verifier_proto_msgTypes[1].OneofWrappers = []any{
		(*Verifier_PublicKey)(nil),
		(*Verifier_X509Certificate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_rekor_v2_verifier_proto_rawDesc), len(file_rekor_v2_verifier_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_rekor_v2_verifier_proto_goTypes,
		DependencyIndexes: file_rekor_v2_verifier_proto_depIdxs,
		MessageInfos:      file_rekor_v2_verifier_proto_msgTypes,
	}.Build()
	File_rekor_v2_verifier_proto = out.File
	file_rekor_v2_verifier_proto_goTypes = nil
	file_rekor_v2_verifier_proto_depIdxs = nil
}
