/* SPDX-License-Identifier: GPL-2.0-or-later */
/* This file was generated by: ./scripts/crypto/gen-hash-testvecs.py blake2s */

static const struct {
	size_t data_len;
	u8 digest[BLAKE2S_HASH_SIZE];
} hash_testvecs[] = {
	{
		.data_len = 0,
		.digest = {
			0x69, 0x21, 0x7a, 0x30, 0x79, 0x90, 0x80, 0x94,
			0xe1, 0x11, 0x21, 0xd0, 0x42, 0x35, 0x4a, 0x7c,
			0x1f, 0x55, 0xb6, 0x48, 0x2c, 0xa1, 0xa5, 0x1e,
			0x1b, 0x25, 0x0d, 0xfd, 0x1e, 0xd0, 0xee, 0xf9,
		},
	},
	{
		.data_len = 1,
		.digest = {
			0x7c, 0xab, 0x53, 0xe2, 0x48, 0x87, 0xdf, 0x64,
			0x98, 0x6a, 0xc1, 0x7e, 0xf0, 0x01, 0x4d, 0xc9,
			0x07, 0x4f, 0xb8, 0x2f, 0x46, 0xd7, 0xee, 0xa9,
			0xad, 0xe5, 0xf8, 0x21, 0xac, 0xfe, 0x17, 0x58,
		},
	},
	{
		.data_len = 2,
		.digest = {
			0x5e, 0x63, 0x2c, 0xd0, 0xf8, 0x7b, 0xf5, 0xae,
			0x61, 0x97, 0x94, 0x57, 0xc8, 0x76, 0x22, 0xd9,
			0x8b, 0x04, 0x5e, 0xf1, 0x5d, 0xd0, 0xfc, 0xd9,
			0x0c, 0x19, 0x2e, 0xe2, 0xc5, 0xd9, 0x73, 0x51,
		},
	},
	{
		.data_len = 3,
		.digest = {
			0x33, 0x65, 0xa6, 0x37, 0xbf, 0xf8, 0x4f, 0x15,
			0x4c, 0xac, 0x9e, 0xa4, 0x3b, 0x02, 0x07, 0x0c,
			0x80, 0x86, 0x0d, 0x6c, 0xe4, 0xaf, 0x1c, 0xbc,
			0x0b, 0x9c, 0x0a, 0x98, 0xc2, 0x99, 0x71, 0xcd,
		},
	},
	{
		.data_len = 16,
		.digest = {
			0x59, 0xd2, 0x10, 0xd3, 0x75, 0xac, 0x48, 0x32,
			0xb1, 0xea, 0xee, 0xcf, 0x0a, 0xd2, 0x8b, 0x15,
			0x5d, 0x72, 0x71, 0x4c, 0xa7, 0x29, 0xb0, 0x7a,
			0x44, 0x48, 0x8a, 0x54, 0x54, 0x54, 0x41, 0xf5,
		},
	},
	{
		.data_len = 32,
		.digest = {
			0xdc, 0xfc, 0x46, 0x81, 0xc6, 0x1b, 0x2b, 0x47,
			0x8b, 0xed, 0xe0, 0x73, 0x34, 0x38, 0x53, 0x92,
			0x97, 0x2f, 0xfb, 0x51, 0xab, 0x4f, 0x2d, 0x9d,
			0x69, 0x04, 0xa9, 0x5d, 0x33, 0xef, 0xcb, 0x1c,
		},
	},
	{
		.data_len = 48,
		.digest = {
			0xd6, 0x2a, 0x7f, 0x96, 0x04, 0x4d, 0x16, 0xc8,
			0x49, 0xe0, 0x37, 0x33, 0xe3, 0x7b, 0x34, 0x56,
			0x99, 0xc5, 0x78, 0x57, 0x06, 0x02, 0xb4, 0xea,
			0x80, 0xc4, 0xf8, 0x8f, 0x8d, 0x2b, 0xe4, 0x05,
		},
	},
	{
		.data_len = 49,
		.digest = {
			0x8b, 0x58, 0x62, 0xb5, 0x85, 0xf6, 0x83, 0x36,
			0xf5, 0x34, 0xb8, 0xd4, 0xbc, 0x5c, 0x8b, 0x38,
			0xfd, 0x15, 0xcd, 0x44, 0x83, 0x25, 0x71, 0xe1,
			0xd5, 0xe8, 0xa1, 0xa4, 0x36, 0x98, 0x7e, 0x68,
		},
	},
	{
		.data_len = 63,
		.digest = {
			0x7e, 0xeb, 0x06, 0x87, 0xdf, 0x1a, 0xdc, 0xe5,
			0xfb, 0x64, 0xd4, 0xd1, 0x5d, 0x9e, 0x75, 0xc0,
			0xb9, 0xad, 0x55, 0x6c, 0xe6, 0xba, 0x4d, 0x98,
			0x2f, 0xbf, 0x72, 0xad, 0x61, 0x37, 0xf6, 0x11,
		},
	},
	{
		.data_len = 64,
		.digest = {
			0x72, 0xdb, 0x43, 0x16, 0x57, 0x8e, 0x3a, 0x96,
			0xf3, 0x98, 0x19, 0x24, 0x17, 0x3b, 0xe8, 0xad,
			0xa1, 0x9b, 0xa4, 0x1b, 0x74, 0x85, 0x2e, 0x24,
			0x70, 0xea, 0x31, 0x5a, 0x1c, 0xbe, 0x43, 0xb5,
		},
	},
	{
		.data_len = 65,
		.digest = {
			0x32, 0x48, 0xb0, 0xf0, 0x3f, 0xbb, 0xd2, 0xa3,
			0xfd, 0xf6, 0x28, 0x4a, 0x2a, 0xc5, 0xbe, 0x4b,
			0x73, 0x50, 0x63, 0xd6, 0x16, 0x00, 0xef, 0xed,
			0xfe, 0x97, 0x41, 0x29, 0xb2, 0x84, 0xc4, 0xa3,
		},
	},
	{
		.data_len = 127,
		.digest = {
			0x17, 0xda, 0x6b, 0x96, 0x6a, 0xa6, 0xa4, 0xa6,
			0xa6, 0xf3, 0x9d, 0x18, 0x19, 0x8d, 0x98, 0x7c,
			0x66, 0x38, 0xe8, 0x99, 0xe7, 0x0a, 0x50, 0x92,
			0xaf, 0x11, 0x80, 0x05, 0x66, 0xed, 0xab, 0x74,
		},
	},
	{
		.data_len = 128,
		.digest = {
			0x13, 0xd5, 0x8b, 0x22, 0xae, 0x90, 0x7b, 0x67,
			0x87, 0x4e, 0x3c, 0x35, 0x4e, 0x01, 0xf0, 0xb1,
			0xd3, 0xd1, 0x67, 0xbb, 0x43, 0xdb, 0x7c, 0x75,
			0xa4, 0xc7, 0x64, 0x83, 0x1e, 0x9b, 0x98, 0xad,
		},
	},
	{
		.data_len = 129,
		.digest = {
			0x6f, 0xe0, 0x5d, 0x9d, 0xd5, 0x78, 0x29, 0xfb,
			0xd0, 0x77, 0xd1, 0x8a, 0xf0, 0x80, 0xcb, 0x81,
			0x71, 0x9e, 0x4d, 0x49, 0xde, 0x74, 0x2a, 0x37,
			0xc0, 0xd5, 0xf0, 0xfa, 0x50, 0xe6, 0x23, 0xfe,
		},
	},
	{
		.data_len = 256,
		.digest = {
			0x89, 0xac, 0xf6, 0xe7, 0x5e, 0xba, 0x53, 0xf4,
			0x92, 0x32, 0xd5, 0x64, 0xfb, 0xc4, 0x08, 0xac,
			0x2c, 0x19, 0x6e, 0x63, 0x13, 0x75, 0xd0, 0x60,
			0x54, 0x35, 0x82, 0xc4, 0x6d, 0x03, 0x1a, 0x05,
		},
	},
	{
		.data_len = 511,
		.digest = {
			0x1c, 0xaf, 0x94, 0x7d, 0x9c, 0xce, 0x57, 0x64,
			0xf8, 0xa8, 0x25, 0x45, 0x32, 0x86, 0x2b, 0x04,
			0xb3, 0x2e, 0x67, 0xca, 0x73, 0x04, 0x2f, 0xab,
			0xcc, 0xda, 0x9e, 0x42, 0xa1, 0xaf, 0x83, 0x5a,
		},
	},
	{
		.data_len = 513,
		.digest = {
			0x21, 0xdf, 0xdc, 0x29, 0xd9, 0xfc, 0x7b, 0xe7,
			0x3a, 0xc4, 0xe1, 0x61, 0xc5, 0xb5, 0xe1, 0xee,
			0x7a, 0x9d, 0x0c, 0x66, 0x36, 0x63, 0xe4, 0x12,
			0x62, 0xe2, 0xf5, 0x68, 0x72, 0xfc, 0x1e, 0x18,
		},
	},
	{
		.data_len = 1000,
		.digest = {
			0x6e, 0xc7, 0x2e, 0xac, 0xd0, 0xbb, 0x22, 0xe0,
			0xc2, 0x40, 0xb2, 0xfe, 0x8c, 0xaf, 0x9e, 0xcf,
			0x32, 0x06, 0xc6, 0x45, 0x29, 0xbd, 0xe0, 0x7f,
			0x53, 0x32, 0xc3, 0x2b, 0x2f, 0x68, 0x12, 0xcd,
		},
	},
	{
		.data_len = 3333,
		.digest = {
			0x76, 0xba, 0x52, 0xb5, 0x09, 0xf5, 0x19, 0x09,
			0x70, 0x1c, 0x09, 0x28, 0xb4, 0xaa, 0x98, 0x6a,
			0x79, 0xe7, 0x5e, 0xcd, 0xe8, 0xa4, 0x73, 0x69,
			0x1f, 0xf8, 0x05, 0x0a, 0xb4, 0xfe, 0xf9, 0x63,
		},
	},
	{
		.data_len = 4096,
		.digest = {
			0xf7, 0xad, 0xf9, 0xc8, 0x0e, 0x04, 0x2f, 0xdf,
			0xbe, 0x39, 0x79, 0x07, 0x0d, 0xd8, 0x1b, 0x06,
			0x42, 0x3a, 0x43, 0x93, 0xf6, 0x7c, 0xc4, 0xe5,
			0xc2, 0xd5, 0xd0, 0xa6, 0x35, 0x6c, 0xbd, 0x17,
		},
	},
	{
		.data_len = 4128,
		.digest = {
			0x38, 0xd7, 0xab, 0x7e, 0x08, 0xdc, 0x1e, 0xab,
			0x55, 0xbb, 0x3b, 0x7b, 0x6a, 0x17, 0xcc, 0x79,
			0xa7, 0x02, 0x62, 0x66, 0x9b, 0xca, 0xee, 0xc0,
			0x3d, 0x75, 0x34, 0x2e, 0x55, 0x82, 0x26, 0x3c,
		},
	},
	{
		.data_len = 4160,
		.digest = {
			0xf7, 0xeb, 0x2f, 0x24, 0x98, 0x54, 0x04, 0x5a,
			0x19, 0xe4, 0x12, 0x9d, 0x97, 0xbc, 0x87, 0xa5,
			0x0b, 0x85, 0x29, 0xa1, 0x36, 0x89, 0xc9, 0xba,
			0xa0, 0xe0, 0xac, 0x99, 0x7d, 0xa4, 0x51, 0x9f,
		},
	},
	{
		.data_len = 4224,
		.digest = {
			0x8f, 0xe8, 0xa7, 0x79, 0x02, 0xbb, 0x4a, 0x56,
			0x66, 0x91, 0xef, 0x22, 0xd1, 0x09, 0x26, 0x6c,
			0xa9, 0x13, 0xd7, 0x44, 0xc7, 0x19, 0x9c, 0x0b,
			0xfb, 0x4f, 0xca, 0x72, 0x8f, 0x34, 0xf7, 0x82,
		},
	},
	{
		.data_len = 16384,
		.digest = {
			0xaa, 0x21, 0xbb, 0x25, 0x4b, 0x66, 0x6e, 0x29,
			0x71, 0xc1, 0x44, 0x67, 0x19, 0xed, 0xe6, 0xe6,
			0x61, 0x13, 0xf4, 0xb7, 0x02, 0x94, 0x81, 0x0f,
			0xa7, 0x4d, 0xbb, 0x2c, 0xb8, 0xeb, 0x41, 0x0e,
		},
	},
};

static const u8 hash_testvec_consolidated[BLAKE2S_HASH_SIZE] = {
	0x84, 0x21, 0xbb, 0x73, 0x64, 0x47, 0x45, 0xe0,
	0xc1, 0x83, 0x78, 0xf1, 0xea, 0xe5, 0xfd, 0xdb,
	0x01, 0xda, 0xb7, 0x86, 0x70, 0x3b, 0x83, 0xb3,
	0xbc, 0xd9, 0xfd, 0x96, 0xbd, 0x50, 0x06, 0x67,
};

static const u8 blake2s_keyed_testvec_consolidated[BLAKE2S_HASH_SIZE] = {
	0xa6, 0xad, 0xcd, 0xb8, 0xd9, 0xdd, 0xc7, 0x70,
	0x07, 0x09, 0x7f, 0x9f, 0x41, 0xa9, 0x70, 0xa4,
	0x1c, 0xca, 0x61, 0xbb, 0x58, 0xb5, 0xb2, 0x1d,
	0xd1, 0x71, 0x16, 0xb0, 0x49, 0x4f, 0x9e, 0x1b,
};
