# Parse version information from version.h:
include("${CMAKE_CURRENT_LIST_DIR}/thrust-header-search.cmake")

set(THRUST_VERSION_MAJOR 2)
set(THRUST_VERSION_MINOR 7)
set(THRUST_VERSION_PATCH 0) # Thrust: "subminor" CMake: "patch"
set(THRUST_VERSION_TWEAK 0)
set(THRUST_VERSION "${THRUST_VERSION_MAJOR}.${THRUST_VERSION_MINOR}.${THRUST_VERSION_PATCH}.${THRUST_VERSION_TWEAK}")

set(PACKAGE_VERSION ${THRUST_VERSION})
set(PACKAGE_VERSION_COMPATIBLE FALSE)
set(PACKAGE_VERSION_EXACT FALSE)
set(PACKAGE_VERSION_UNSUITABLE FALSE)

if(PACKAGE_VERSION VERSION_GREATER_EQUAL PACKAGE_FIND_VERSION)
  if(THRUST_VERSION_MAJOR VERSION_EQUAL PACKAGE_FIND_VERSION_MAJOR AND
     THRUST_VERSION_MINOR VERSION_GREATER_EQUAL PACKAGE_FIND_VERSION_MINOR)
    set(PACKAGE_VERSION_COMPATIBLE TRUE)
  endif()

  if(PACKAGE_FIND_VERSION VERSION_EQUAL PACKAGE_VERSION)
    set(PACKAGE_VERSION_EXACT TRUE)
  endif()
endif()
