<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/macos.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/macos.plugin/metadata.yaml"
sidebar_label: "macOS"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/macOS Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# macOS


<img src="https://netdata.cloud/img/macos.svg" width="150"/>


Plugin: macos.plugin
Module: mach_smi

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor macOS metrics for efficient operating system performance.

The plugin uses three different methods to collect data:
  - The function `sysctlbyname` is called to collect network, swap, loadavg, and boot time.
  - The functtion `host_statistic` is called to collect CPU and Virtual memory data;
  - The function `IOServiceGetMatchingServices` to collect storage information.


This collector is only supported on the following platforms:

- macOS

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per macOS instance

These metrics refer to hardware and network monitoring.


This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.cpu | user, nice, system, idle | percentage |
| system.ram | active, wired, throttled, compressor, inactive, purgeable, speculative, free | MiB |
| mem.swapio | io, out | KiB/s |
| mem.pgfaults | memory, cow, pagein, pageout, compress, decompress, zero_fill, reactivate, purge | faults/s |
| system.load | load1, load5, load15 | load |
| mem.swap | free, used | MiB |
| system.ipv4 | received, sent | kilobits/s |
| ipv4.tcppackets | received, sent | packets/s |
| ipv4.tcperrors | InErrs, InCsumErrors, RetransSegs | packets/s |
| ipv4.tcphandshake | EstabResets, ActiveOpens, PassiveOpens, AttemptFails | events/s |
| ipv4.tcpconnaborts | baddata, userclosed, nomemory, timeout | connections/s |
| ipv4.tcpofo | inqueue | packets/s |
| ipv4.tcpsyncookies | received, sent, failed | packets/s |
| ipv4.ecnpkts | CEP, NoECTP | packets/s |
| ipv4.udppackets | received, sent | packets/s |
| ipv4.udperrors | RcvbufErrors, InErrors, NoPorts, InCsumErrors, IgnoredMulti | events/s |
| ipv4.icmp | received, sent | packets/s |
| ipv4.icmp_errors | InErrors, OutErrors, InCsumErrors | packets/s |
| ipv4.icmpmsg | InEchoReps, OutEchoReps, InEchos, OutEchos | packets/s |
| ipv4.packets | received, sent, forwarded, delivered | packets/s |
| ipv4.fragsout | ok, failed, created | packets/s |
| ipv4.fragsin | ok, failed, all | packets/s |
| ipv4.errors | InDiscards, OutDiscards, InHdrErrors, OutNoRoutes, InAddrErrors, InUnknownProtos | packets/s |
| ipv6.packets | received, sent, forwarded, delivers | packets/s |
| ipv6.fragsout | ok, failed, all | packets/s |
| ipv6.fragsin | ok, failed, timeout, all | packets/s |
| ipv6.errors | InDiscards, OutDiscards, InHdrErrors, InAddrErrors, InTruncatedPkts, InNoRoutes, OutNoRoutes | packets/s |
| ipv6.icmp | received, sent | messages/s |
| ipv6.icmpredir | received, sent | redirects/s |
| ipv6.icmperrors | InErrors, OutErrors, InCsumErrors, InDestUnreachs, InPktTooBigs, InTimeExcds, InParmProblems, OutDestUnreachs, OutTimeExcds, OutParmProblems | errors/s |
| ipv6.icmpechos | InEchos, OutEchos, InEchoReplies, OutEchoReplies | messages/s |
| ipv6.icmprouter | InSolicits, OutSolicits, InAdvertisements, OutAdvertisements | messages/s |
| ipv6.icmpneighbor | InSolicits, OutSolicits, InAdvertisements, OutAdvertisements | messages/s |
| ipv6.icmptypes | InType1, InType128, InType129, InType136, OutType1, OutType128, OutType129, OutType133, OutType135, OutType143 | messages/s |
| system.uptime | uptime | seconds |
| system.io | in, out | KiB/s |

### Per disk



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| disk.io | read, writes | KiB/s |
| disk.ops | read, writes | operations/s |
| disk.util | utilization | % of time working |
| disk.iotime | reads, writes | milliseconds/s |
| disk.await | reads, writes | milliseconds/operation |
| disk.avgsz | reads, writes | KiB/operation |
| disk.svctm | svctm | milliseconds/operation |

### Per mount point



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| disk.space | avail, used, reserved_for_root | GiB |
| disk.inodes | avail, used, reserved_for_root | inodes |

### Per network device



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| net.net | received, sent | kilobits/s |
| net.packets | received, sent, multicast_received, multicast_sent | packets/s |
| net.errors | inbound, outbound | errors/s |
| net.drops | inbound | drops/s |
| net.events | frames, collisions, carrier | events/s |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ interface_speed ](https://github.com/netdata/netdata/blob/master/src/health/health.d/net.conf) | net.net | network interface ${label:device} current speed |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options

There are three sections in the file which you can configure:

- `[plugin:macos:sysctl]` - Enable or disable monitoring for network, swap, loadavg, and boot time.
- `[plugin:macos:mach_smi]` - Enable or disable monitoring for CPU and Virtual memory.
- `[plugin:macos:iokit]` - Enable or disable monitoring for storage device.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| enable load average | Enable or disable monitoring of load average metrics (load1, load5, load15). | yes | no |
| system swap | Enable or disable monitoring of system swap metrics (free, used). | yes | no |
| bandwidth | Enable or disable monitoring of network bandwidth metrics (received, sent). | yes | no |
| ipv4 TCP packets | Enable or disable monitoring of IPv4 TCP total packets metrics (received, sent). | yes | no |
| ipv4 TCP errors | Enable or disable monitoring of IPv4 TCP packets metrics (Input Errors, Checksum, Retransmission segments). | yes | no |
| ipv4 TCP handshake issues | Enable or disable monitoring of IPv4 TCP handshake metrics (Established Resets, Active Opens, Passive Opens, Attempt Fails). | yes | no |
| ECN packets | Enable or disable monitoring of ECN statistics metrics (InCEPkts, InNoECTPkts). | auto | no |
| TCP SYN cookies | Enable or disable monitoring of TCP SYN cookies metrics (received, sent, failed). | auto | no |
| TCP out-of-order queue | Enable or disable monitoring of TCP out-of-order queue metrics (inqueue). | auto | no |
| TCP connection aborts | Enable or disable monitoring of TCP connection aborts metrics (Bad Data, User closed, No memory, Timeout). | auto | no |
| ipv4 UDP packets | Enable or disable monitoring of ipv4 UDP packets metrics (sent, received.). | yes | no |
| ipv4 UDP errors | Enable or disable monitoring of ipv4 UDP errors metrics (Recieved Buffer error, Input Errors, No Ports, IN Checksum Errors, Ignore Multi). | yes | no |
| ipv4 icmp packets | Enable or disable monitoring of IPv4 ICMP packets metrics (sent, received, in error, OUT error, IN Checksum error). | yes | no |
| ipv4 icmp messages | Enable or disable monitoring of ipv4 ICMP messages metrics (I/O messages, I/O Errors, In Checksum). | yes | no |
| ipv4 packets | Enable or disable monitoring of ipv4 packets metrics (received, sent, forwarded, delivered). | yes | no |
| ipv4 fragments sent | Enable or disable monitoring of IPv4 fragments sent metrics (ok, fails, creates). | yes | no |
| ipv4 fragments assembly | Enable or disable monitoring of IPv4 fragments assembly metrics (ok, failed, all). | yes | no |
| ipv4 errors | Enable or disable monitoring of IPv4 errors metrics (I/O discard, I/O HDR errors, In Addr errors, In Unknown protos, OUT No Routes). | yes | no |
| ipv6 packets | Enable or disable monitoring of IPv6 packets metrics (received, sent, forwarded, delivered). | auto | no |
| ipv6 fragments sent | Enable or disable monitoring of IPv6 fragments sent metrics (ok, failed, all). | auto | no |
| ipv6 fragments assembly | Enable or disable monitoring of IPv6 fragments assembly metrics (ok, failed, timeout, all). | auto | no |
| ipv6 errors | Enable or disable monitoring of IPv6 errors metrics (I/O Discards, In Hdr Errors, In Addr Errors, In Truncaedd Packets, I/O No Routes). | auto | no |
| icmp | Enable or disable monitoring of ICMP metrics (sent, received). | auto | no |
| icmp redirects | Enable or disable monitoring of ICMP redirects metrics (received, sent). | auto | no |
| icmp errors | Enable or disable monitoring of ICMP metrics (I/O Errors, In Checksums, In Destination Unreachable, In Packet too big, In Time Exceeds, In Parm Problem, Out Dest Unreachable, Out Timee Exceeds, Out Parm Problems.). | auto | no |
| icmp echos | Enable or disable monitoring of ICMP echos metrics (I/O Echos, I/O Echo Reply). | auto | no |
| icmp router | Enable or disable monitoring of ICMP router metrics (I/O Solicits, I/O Advertisements). | auto | no |
| icmp neighbor | Enable or disable monitoring of ICMP neighbor metrics (I/O Solicits, I/O Advertisements). | auto | no |
| icmp types | Enable or disable monitoring of ICMP types metrics (I/O Type1, I/O Type128, I/O Type129, Out Type133, Out Type135, In Type136, Out Type145). | auto | no |
| space usage for all disks | Enable or disable monitoring of space usage for all disks metrics (available, used, reserved for root). | yes | no |
| inodes usage for all disks | Enable or disable monitoring of inodes usage for all disks metrics (available, used, reserved for root). | yes | no |
| bandwidth | Enable or disable monitoring of bandwidth metrics (received, sent). | yes | no |
| system uptime | Enable or disable monitoring of system uptime metrics (uptime). | yes | no |
| cpu utilization | Enable or disable monitoring of CPU utilization metrics (user, nice, system, idel). | yes | no |
| system ram | Enable or disable monitoring of system RAM metrics (Active, Wired, throttled, compressor, inactive, purgeable, speculative, free). | yes | no |
| swap i/o | Enable or disable monitoring of SWAP I/O metrics (I/O Swap). | yes | no |
| memory page faults | Enable or disable monitoring of memory page faults metrics (memory, cow, I/O page, compress, decompress, zero fill, reactivate, purge). | yes | no |
| disk i/o | Enable or disable monitoring of disk I/O metrics (In, Out). | yes | no |

</details>

#### Examples

##### Disable swap monitoring.

A basic example that discards swap monitoring

<details open><summary>Config</summary>

```yaml
[plugin:macos:sysctl]
  system swap = no
[plugin:macos:mach_smi]
  swap i/o = no

```
</details>

##### Disable complete Machine SMI section.

A basic example that discards swap monitoring

<details open><summary>Config</summary>

```yaml
[plugin:macos:mach_smi]
  cpu utilization = no
  system ram = no
  swap i/o = no
  memory page faults = no
  disk i/o = no

```
</details>


