package Net::Async::Spotify::API::Generated::Tracks;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::API::Base);

use Future::AsyncAwait;

=encoding utf8

=head1 NAME

Net::Async::Spotify::API::Generated::Tracks - Package representing Spotify Tracks API

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#reference-index
Check C<crawl-api-doc.pl> for more information.

=head1 METHODS

=cut

sub mapping { shift->{mapping} }

=head2 get_audio_analysis

get_audio_analysis - Get Audio Analysis for a Track

Get a detailed audio analysis for a single track identified by its unique
Spotify ID.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.

=back

=head3 path_parameter

=over 4

=item id

Type: string | Required: required
The Spotify ID
for the track.

=back

and Response Objects being:

- analysis object


On success, the HTTP status code in the response header is 200 OK and the response body contains an audio analysis object in JSON format. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_audio_analysis {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_audio_analysis}{method} // 'GET';
    $request->{uri}    = $mapping->{get_audio_analysis}{uri} // 'https://api.spotify.com/v1/audio-analysis/{id}';
    $request->{param}  = $mapping->{get_audio_analysis}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'id' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{get_audio_analysis}{response} // [
        'analysis object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_audio_features

get_audio_features - Get Audio Features for a Track

Get audio feature information for a single track identified by its unique
Spotify ID.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.

=back

=head3 path_parameter

=over 4

=item id

Type: string | Required: required
The Spotify ID for the track.

=back

and Response Objects being:

- features object


On success, the HTTP status code in the response header is 200 OK and the response body contains an audio features object in JSON format. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_audio_features {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_audio_features}{method} // 'GET';
    $request->{uri}    = $mapping->{get_audio_features}{uri} // 'https://api.spotify.com/v1/audio-features/{id}';
    $request->{param}  = $mapping->{get_audio_features}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'id' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{get_audio_features}{response} // [
        'features object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_several_audio_features

get_several_audio_features - Get Audio Features for Several Tracks

Get audio features for multiple tracks based on their Spotify IDs.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs
for the tracks. Maximum: 100 IDs.

=back

and Response Objects being:

- an object
- an object


On success, the HTTP status code in the response header is 200 OK
and the response body contains an object whose key is "audio_features" and
whose value is an array of audio features objects in JSON format.Objects are returned in the order requested. If an object is not found, a null value is returned in the appropriate position. Duplicate ids in the query will result in duplicate objects in the response. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_several_audio_features {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_several_audio_features}{method} // 'GET';
    $request->{uri}    = $mapping->{get_several_audio_features}{uri} // 'https://api.spotify.com/v1/audio-features';
    $request->{param}  = $mapping->{get_several_audio_features}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{get_several_audio_features}{response} // [
        'an object',
        'an object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_several_tracks

get_several_tracks - Get Several Tracks

Get Spotify catalog information for multiple tracks based on their Spotify IDs.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service:
see the Web API Authorization Guide
for details.

=back

=head3 query_parameter

=over 4

=item ids

Type: string | Required: required
A comma-separated list of the Spotify IDs for the tracks. Maximum: 50 IDs.

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code or the string from_token. Provide this parameter if you want to apply Track Relinking.

=back

and Response Objects being:

- an object
- an object


On success, the HTTP status code in the response header is 200
OK and the response body contains an object whose key is tracks and whose
value is an array of track objects
in JSON format.Objects are returned in the order requested. If an object is not found, a null value is returned in the appropriate position. Duplicate ids in the query will result in duplicate objects in the response. On error, the header status code is an error code and the response body contains an error object.Try in our Web Console

=cut

async sub get_several_tracks {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_several_tracks}{method} // 'GET';
    $request->{uri}    = $mapping->{get_several_tracks}{uri} // 'https://api.spotify.com/v1/tracks';
    $request->{param}  = $mapping->{get_several_tracks}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'ids' => {
                type     => 'string',
                required => 'required',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_several_tracks}{response} // [
        'an object',
        'an object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_track

get_track - Get a Track

Get Spotify catalog information for a single track identified by its
unique Spotify ID.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service:
see the Web API Authorization Guide
for details.

=back

=head3 path_parameter

=over 4

=item id

Type: string | Required: required
The Spotify ID
for the track.

=back

=head3 query_parameter

=over 4

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code
or the string from_token. Provide this parameter if you want to apply Track
Relinking.

=back

and Response Objects being:

- track object


On success, the HTTP status code in the response header is 200
OK and the response body contains a track object
in JSON format. On error, the header status code is an error code
and the response body contains an error object.Try in our Web Console

=cut

async sub get_track {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_track}{method} // 'GET';
    $request->{uri}    = $mapping->{get_track}{uri} // 'https://api.spotify.com/v1/tracks/{id}';
    $request->{param}  = $mapping->{get_track}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'id' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'market' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_track}{response} // [
        'track object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

1;
