# raku-protobuf

Parse and manage Protobufs with Raku

## Description

This package contains utilities for managing protobufs with Raku.

Current contents:

* Protobuf::Grammar -- parse a protobuf file
* Protobuf::Actions -- generate a representation from a grammar
* Protobuf -- provides `parse-proto` for combining the above
* protoc.raku -- cli to parse a proto from the command line

There are a few other little classes like Protobuf::Definition,
Protobuf::Service, etc which comprise the structure that is
built by Protobuf::Actions.

## SYNOPSIS

    use Protobuf;

    my $p = parse-proto("my.proto".IO.slurp);
    # returns a Protobuf::Definition

    for $p.services -> $svc {

      # each one is a Protobuf::Service
      say "service name: " ~ $svc.name;

      for $svc.endpoints -> $e {
        # each one is a Protobuf::Endpoint
        say " endpoint:  " ~ $e.name;

        say '  request params: ' ~ $e.request.name;
        # Requests and responses are Protobuf::Message's

        for $e.request.fields -> $f {
          # These are Protobuf::Field's
          say '   name : ' ~ $f.name;
          say '   type : ' ~ $f.type;
        }
        say '  response params: ' ~ $e.response.name;
        for $e.response.fields -> $f {
          say '   name : ' ~ $f.name;
          say '   type : ' ~ $f.type;
        }
      }
    }

## AUTHOR

Brian Duggan

## TODO

* Generate code from a proto
* A bunch of details in the grammar

## SEE ALSO

https://developers.google.com/protocol-buffers/docs/reference/proto3-spec
