/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersionFinder;

public class GraphvizVersions {
    private static final GraphvizVersions singleton = new GraphvizVersions();
    private final Map<File, GraphvizVersion> map = new ConcurrentHashMap<File, GraphvizVersion>();

    private GraphvizVersions() {
    }

    public static GraphvizVersions getInstance() {
        return singleton;
    }

    public GraphvizVersion getVersion(File file) {
        if (file == null) {
            return null;
        }
        GraphvizVersion graphvizVersion = this.map.get(file);
        if (graphvizVersion != null) {
            return graphvizVersion;
        }
        graphvizVersion = GraphvizVersions.checkVersionSlow(file.getAbsolutePath());
        this.map.put(file, graphvizVersion);
        return graphvizVersion;
    }

    static GraphvizVersion checkVersionSlow(String string) {
        GraphvizVersionFinder graphvizVersionFinder = new GraphvizVersionFinder(new File(string));
        return graphvizVersionFinder.getVersion();
    }
}

