
BEGIN {
  unless ($ENV{RELEASE_TESTING}) {
    print qq{1..0 # SKIP these tests are for release candidate testing\n};
    exit
  }
}

# HARNESS-DURATION-LONG
use Test2::V0;

use Bitcoin::Crypto qw(btc_transaction btc_utxo);
use Bitcoin::Crypto::Transaction::Output;
use Bitcoin::Crypto::Script::Runner;

use lib 't/lib';
use BitcoinCoreTest;

my $case_name = 'taproot';

my $data = get_file_data($case_name);

my $script_runner = Bitcoin::Crypto::Script::Runner->new;
foreach my $case_ind (0 .. $#$data)
{
	my $case = $data->[$case_ind];

	subtest "should pass $case_name index $case_ind ($case->{comment})" => sub {
		my $tx = btc_transaction->from_serialized([hex => $case->{tx}]);

		my @last_outputs =
			map { Bitcoin::Crypto::Transaction::Output->from_serialized([hex => $_]) } @{$case->{prevouts}};
		foreach my $input (@{$tx->inputs}) {
			btc_utxo->new(
				txid => $input->utxo_location->[0],
				output_index => $input->utxo_location->[1],
				output => shift @last_outputs,
			)->register;
		}

		$script_runner->set_transaction($tx);
		$script_runner->set_flags(get_flags $case->{flags});
		my $index = $case->{index};
		my $input = $tx->inputs->[$index];

		foreach my $sub_case ([!!1, $case->{success}], [!!0, $case->{failure}]) {
			my ($success, $sub_case_data) = @$sub_case;
			next unless $sub_case_data;

			$input->set_signature_script([hex => $sub_case_data->{scriptSig}]);
			$input->set_witness([map { [hex => $_] } @{$sub_case_data->{witness}}]);

			if ($success) {
				ok lives { $tx->verify_script($index, $script_runner) }, 'success case ok';
			}
			else {
				my $ex = dies { $tx->verify_script($index, $script_runner) };
				isa_ok $ex, 'Bitcoin::Crypto::Exception::Transaction';
			}
		}
	};
}

done_testing;
