/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config;

import org.apache.shiro.config.Ini;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.util.AbstractFactory;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IniFactorySupport<T>
extends AbstractFactory<T> {
    public static final String DEFAULT_INI_RESOURCE_PATH = "classpath:shiro.ini";
    private static final transient Logger log = LoggerFactory.getLogger(IniFactorySupport.class);
    private Ini ini;

    protected IniFactorySupport() {
    }

    protected IniFactorySupport(Ini ini) {
        this.ini = ini;
    }

    public Ini getIni() {
        return this.ini;
    }

    public void setIni(Ini ini) {
        this.ini = ini;
    }

    public static Ini loadDefaultClassPathIni() {
        Ini ini = null;
        if (ResourceUtils.resourceExists(DEFAULT_INI_RESOURCE_PATH)) {
            log.debug("Found shiro.ini at the root of the classpath.");
            ini = new Ini();
            ini.loadFromPath(DEFAULT_INI_RESOURCE_PATH);
            if (CollectionUtils.isEmpty(ini)) {
                log.warn("shiro.ini found at the root of the classpath, but it did not contain any data.");
            }
        }
        return ini;
    }

    protected Ini resolveIni() {
        Ini ini = this.getIni();
        if (CollectionUtils.isEmpty(ini)) {
            log.debug("Null or empty Ini instance.  Falling back to the default {} file.", (Object)DEFAULT_INI_RESOURCE_PATH);
            ini = IniFactorySupport.loadDefaultClassPathIni();
        }
        return ini;
    }

    @Override
    public T createInstance() {
        T instance;
        Ini ini = this.resolveIni();
        if (CollectionUtils.isEmpty(ini)) {
            log.debug("No populated Ini available.  Creating a default instance.");
            instance = this.createDefaultInstance();
            if (instance == null) {
                String msg = this.getClass().getName() + " implementation did not return a default instance in " + "the event of a null/empty Ini configuration.  This is required to support the " + "Factory interface.  Please check your implementation.";
                throw new IllegalStateException(msg);
            }
        } else {
            log.debug("Creating instance from Ini [" + ini + "]");
            instance = this.createInstance(ini);
            if (instance == null) {
                String msg = this.getClass().getName() + " implementation did not return a constructed instance from " + "the createInstance(Ini) method implementation.";
                throw new IllegalStateException(msg);
            }
        }
        return instance;
    }

    protected abstract T createInstance(Ini var1);

    protected abstract T createDefaultInstance();
}

