/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.remoting3.MessageInputStream;

class ModuleAvailabilityMessageHandler
extends ProtocolMessageHandler {
    private final RemotingConnectionEJBReceiver ejbReceiver;
    private final ModuleReportType type;
    private final EJBReceiverContext receiverContext;

    ModuleAvailabilityMessageHandler(RemotingConnectionEJBReceiver ejbReceiver, EJBReceiverContext receiverContext, ModuleReportType type) {
        this.ejbReceiver = ejbReceiver;
        this.type = type;
        this.receiverContext = receiverContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from null stream");
        }
        EJBModuleIdentifier[] ejbModules = null;
        try {
            DataInputStream input = new DataInputStream((InputStream)messageInputStream);
            int count = PackedInteger.readPackedInteger(input);
            ejbModules = new EJBModuleIdentifier[count];
            for (int i = 0; i < ejbModules.length; ++i) {
                String appName = input.readUTF();
                if (appName == null) {
                    appName = "";
                }
                String moduleName = input.readUTF();
                String distinctName = input.readUTF();
                if (distinctName == null) {
                    distinctName = "";
                }
                ejbModules[i] = new EJBModuleIdentifier(appName, moduleName, distinctName);
            }
        }
        finally {
            messageInputStream.close();
        }
        switch (this.type) {
            case MODULE_AVAILABLE: {
                for (EJBModuleIdentifier ejbModule : ejbModules) {
                    this.ejbReceiver.moduleAvailable(this.receiverContext, ejbModule.appName, ejbModule.moduleName, ejbModule.distinctName);
                }
                break;
            }
            case MODULE_UNAVAILABLE: {
                for (EJBModuleIdentifier ejbModule : ejbModules) {
                    this.ejbReceiver.moduleUnavailable(this.receiverContext, ejbModule.appName, ejbModule.moduleName, ejbModule.distinctName);
                }
                break;
            }
        }
    }

    private class EJBModuleIdentifier {
        private final String appName;
        private final String moduleName;
        private final String distinctName;

        EJBModuleIdentifier(String appname, String moduleName, String distinctName) {
            this.appName = appname;
            this.moduleName = moduleName;
            this.distinctName = distinctName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EJBModuleIdentifier that = (EJBModuleIdentifier)o;
            if (this.appName != null ? !this.appName.equals(that.appName) : that.appName != null) {
                return false;
            }
            if (this.distinctName != null ? !this.distinctName.equals(that.distinctName) : that.distinctName != null) {
                return false;
            }
            return this.moduleName.equals(that.moduleName);
        }

        public int hashCode() {
            int result = this.appName != null ? this.appName.hashCode() : 0;
            result = 31 * result + this.moduleName.hashCode();
            result = 31 * result + (this.distinctName != null ? this.distinctName.hashCode() : 0);
            return result;
        }
    }

    static enum ModuleReportType {
        MODULE_AVAILABLE,
        MODULE_UNAVAILABLE;

    }
}

