%global   realname puppetdb

%global ruby_sitelib     %(PATH=/opt/puppet/bin:$PATH ruby -rrbconfig -e "puts Config::CONFIG['sitelibdir']")

# These macros are not always defined on much older rpm-based systems
%global  _sharedstatedir /var/lib
%global  _realsysconfdir /etc
%global  _initddir   %{_realsysconfdir}/rc.d/init.d
%global _rundir /var/run


Name:           puppetdb
Version:        0.9.2
Release:        1%{?dist}
BuildRoot:      %{_tmppath}/%{realname}-%{version}-%{release}-root-%(%{__id_u} -n)

Summary:        Puppet Centralized Storage Daemon
License:       ASL 2.0
URL:           http://github.com/puppetlabs/puppetdb
Source0:       http://downloads.puppetlabs.com/puppetdb/%{realname}-%{version}.tar.gz
Group:         System Environment/Daemons

BuildRequires: facter, puppet
BuildRequires: rubygem-rake
BuildRequires: ruby
Requires:      puppet >= 2.7.12
BuildArch:     noarch

BuildRequires: /usr/sbin/useradd
Requires:      java-1.6.0-openjdk

Requires:      chkconfig

%description
Puppet Centralized Storage.

%package terminus
Summary: Puppet terminus files to connect to PuppetDB
Group: Development/Libraries
Requires: puppet >= 2.7.12

%description terminus
Connect Puppet to PuppetDB by setting up a terminus for PuppetDB.

%prep
%setup -q -n %{realname}-%{version}

%build

%install


rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_initddir}

rake install DESTDIR=$RPM_BUILD_ROOT
rake terminus DESTDIR=$RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT/%{_localstatedir}/log/%{name}
mkdir -p $RPM_BUILD_ROOT/%{_rundir}/%{name}
touch  $RPM_BUILD_ROOT/%{_localstatedir}/log/%{name}/%{name}.log


%clean
rm -rf $RPM_BUILD_ROOT

%pre
# Here we'll do a little bit of cleanup just in case something went horribly
# awry during a previous install/uninstall:
if [ -f "/usr/share/puppetdb/start_service_after_upgrade" ] ; then
   rm /usr/share/puppetdb/start_service_after_upgrade
fi
# If this is an upgrade (as opposed to an install) then we need to check
#  and see if the service is running.  If it is, we need to stop it.
#  we want to shut down and disable the service.
if [ "$1" = "2" ] ; then
    if /sbin/service %{name} status > /dev/null ; then
        # If we need to restart the service after the upgrade
        #  is finished, we will touch a temp file so that
        #  we can detect that state
        touch /usr/share/puppetdb/start_service_after_upgrade
        /sbin/service %{name} stop >/dev/null 2>&1
    fi
fi
# Add PuppetDB user
getent group %{name} > /dev/null || groupadd -r %{name}
getent passwd %{name} > /dev/null || \
useradd -r -g %{name} -d /usr/share/puppetdb -s /sbin/nologin \
     -c "PuppetDB daemon"  %{name}

%post
# If this is an install (as opposed to an upgrade)...
if [ "$1" = "1" ]; then
  # Register the puppetDB service
  /sbin/chkconfig --add %{name}

  /usr/sbin/puppetdb-ssl-setup

  pw=`cat /etc/puppetdb/conf.d/../ssl/puppetdb_keystore_pw.txt`

  find  /etc/puppetdb/conf.d -type f | xargs chmod 640
  chown -R puppetdb:puppetdb /etc/puppetdb/conf.d/..
  chown -R puppetdb:puppetdb /usr/share/puppetdb
    chown -R puppetdb:puppetdb /var/lib/puppetdb
    chown -R puppetdb:puppetdb /var/log/puppetdb

  cat > /etc/puppetdb/conf.d/jetty.ini << EOF
[jetty]
# Hostname to list for clear-text HTTP.  Default is localhost
#host = localhost
# Port to listen on for clear-text HTTP.
port = 8080
ssl-host = `facter fqdn`
ssl-port = 8081
keystore = /etc/puppetdb/ssl/keystore.jks
truststore = /etc/puppetdb/ssl/truststore.jks
key-password = $pw
trust-password = $pw
EOF
fi

%preun
# If this is an uninstall (as opposed to an upgrade) then
#  we want to shut down and disable the service.
if [ "$1" = "0" ] ; then
    /sbin/service %{name} stop >/dev/null 2>&1
    /sbin/chkconfig --del %{name}
fi

%postun
# Remove PuppetDB user if this is an uninstall (as opposed to
#  an upgrade)...
if [ "$1" = "0" ]; then
    getent passwd %{name} > /dev/null && userdel %{name}
    getent group %{name} > /dev/null && groupdel %{name}
    rm -rf %{_rundir}/%{name} || :
fi

# If this is an upgrade (as opposed to an install) then we need to check
#  and see if we stopped the service during the install (we indicate
#  this via the existence of a temp file that was created during that
#  phase).  If we did, then we need to restart it.
if [ "$1" = "1" ] ; then
    if [ -f "/usr/share/puppetdb/start_service_after_upgrade" ] ; then
        rm /usr/share/puppetdb/start_service_after_upgrade
        /sbin/service %{name} start >/dev/null 2>&1
    fi
fi


%files
%defattr(-, %{name}, %{name})
%doc *.md
%doc spec
%config(noreplace)%{_sysconfdir}/%{realname}/conf.d/config.ini
%config(noreplace)%{_sysconfdir}/%{realname}/log4j.properties
%config(noreplace)%{_sysconfdir}/%{realname}/conf.d/database.ini
%config(noreplace)%{_sysconfdir}/%{realname}/conf.d/jetty.ini
%config(noreplace)%{_sysconfdir}/%{realname}/conf.d/repl.ini
%config(noreplace)%{_realsysconfdir}/sysconfig/%{name}
%config(noreplace)%{_realsysconfdir}/logrotate.d/%{name}
%{_sbindir}/puppetdb-ssl-setup
%{_datadir}/%{realname}
%{_initddir}/%{name}
%{_sharedstatedir}/%{realname}
%{_datadir}/%{realname}/state
%dir %{_localstatedir}/log/%{name}
%ghost %{_localstatedir}/log/%{name}/%{name}.log
%ghost %{_rundir}/%{name}


%files terminus
%defattr(-, puppet, puppet)
# There are not specs yet in our rpms
%{ruby_sitelib}/puppet


%changelog
* Fri Jul 13 2012 moses <moses@deb-builder.puppetlabs.lan> - 0.9.2
- Autobuild from Rake task

* Mon Apr 02 2012 Michael Stahnke <stahnma@puppetlabs.com> - 0.1.0-1
- Initial Packaging
