%global   realname puppetdb

%global ruby_sitelib     %(PATH=/opt/puppet/bin:$PATH ruby -rrbconfig -e "puts Config::CONFIG['sitelibdir']")

# These macros are not always defined on much older rpm-based systems
%global  _sharedstatedir /var/lib
%global  _realsysconfdir /etc
%global  _initddir   %{_realsysconfdir}/rc.d/init.d
%global _rundir /var/run


Name:           puppetdb
Version:        0.9.1
Release:        1%{?dist}
BuildRoot:      %{_tmppath}/%{realname}-%{version}-%{release}-root-%(%{__id_u} -n)

Summary:        Puppet Centralized Storage Daemon
License:       ASL 2.0
URL:           http://github.com/puppetlabs/puppetdb
Source0:       http://downloads.puppetlabs.com/puppetdb/%{realname}-%{version}.tar.gz
Group:         System Environment/Daemons

BuildRequires: facter, puppet
BuildRequires: rubygem-rake
BuildRequires: ruby
Requires:      puppet >= 2.7.12
BuildArch:     noarch

BuildRequires: /usr/sbin/useradd
Requires:      java-1.6.0-openjdk

Requires:      chkconfig

%description
Puppet Centralized Storage.

%package terminus
Summary: Puppet terminus files to connect to PuppetDB
Group: Development/Libraries
Requires: puppet >= 2.7.12

%description terminus
Connect Puppet to PuppetDB by setting up a terminus for PuppetDB.

%prep
%setup -q -n %{realname}-%{version}

%build

%install


rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_initddir}

rake install DESTDIR=$RPM_BUILD_ROOT
rake terminus DESTDIR=$RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT/%{_localstatedir}/log/%{name}
mkdir -p $RPM_BUILD_ROOT/%{_rundir}/%{name}
touch  $RPM_BUILD_ROOT/%{_localstatedir}/log/%{name}/%{name}.log


%clean
rm -rf $RPM_BUILD_ROOT

%pre
# Add PuppetDB user
getent group %{name} > /dev/null || groupadd -r %{name}
getent passwd %{name} > /dev/null || \
useradd -r -g %{name} -d /opt/puppet/share/%{realname} -s /sbin/nologin \
     -c "PuppetDB daemon"  %{name}

%post
# If this is an install (as opposed to an upgrade)...
if [ "$1" = "1" ]; then
  # Register the puppetDB service
  /sbin/chkconfig --add %{name}

  /usr/sbin/puppetdb-ssl-setup

  pw=`cat /etc/puppetdb/conf.d/../ssl/puppetdb_keystore_pw.txt`

  find  /etc/puppetdb/conf.d -type f | xargs chmod 640
  chown -R puppetdb:puppetdb /etc/puppetdb/conf.d/..
  chown -R puppetdb:puppetdb /usr/share/puppetdb
    chown -R puppetdb:puppetdb /var/lib/puppetdb
    chown -R puppetdb:puppetdb /var/log/puppetdb

  cat > /etc/puppetdb/conf.d/jetty.ini << EOF
[jetty]
# Hostname to list for clear-text HTTP.  Default is localhost
#host = localhost
# Port to listen on for clear-text HTTP.
port = 8080
ssl-host = `facter fqdn`
ssl-port = 8081
keystore = /etc/puppetdb/ssl/keystore.jks
truststore = /etc/puppetdb/ssl/truststore.jks
key-password = $pw
trust-password = $pw
EOF
fi

%preun
/sbin/service %{name} stop >/dev/null 2>&1
/sbin/chkconfig --del %{name}

%postun
# Remove PuppetDB user
getent group %{name} > /dev/null || groupdel -r %{name}
getent passwd %{name} > /dev/null || userdel -r %{name}
rm -rf %{_rundir}/%{name} || :


%files
%defattr(-, %{name}, %{name})
%doc *.md
%doc spec
%config(noreplace)%{_sysconfdir}/%{realname}/conf.d/config.ini
%config(noreplace)%{_sysconfdir}/%{realname}/log4j.properties
%config(noreplace)%{_sysconfdir}/%{realname}/conf.d/database.ini
%config(noreplace)%{_sysconfdir}/%{realname}/conf.d/jetty.ini
%config(noreplace)%{_sysconfdir}/%{realname}/conf.d/repl.ini
%config(noreplace)%{_realsysconfdir}/sysconfig/%{name}
%config(noreplace)%{_realsysconfdir}/logrotate.d/%{name}
%{_sbindir}/puppetdb-ssl-setup
%{_datadir}/%{realname}
%{_initddir}/%{name}
%{_sharedstatedir}/%{realname}
%{_datadir}/%{realname}/state
%dir %{_localstatedir}/log/%{name}
%ghost %{_localstatedir}/log/%{name}/%{name}.log
%ghost %{_rundir}/%{name}


%files terminus
%defattr(-, puppet, puppet)
# There are not specs yet in our rpms
%{ruby_sitelib}/puppet


%changelog
* Thu Jun 14 2012 matthaus <matthaus@deb-builder.puppetlabs.lan> - 0.9.1
- Autobuild from Rake task

* Mon Apr 02 2012 Michael Stahnke <stahnma@puppetlabs.com> - 0.1.0-1
- Initial Packaging
