%global realversion    0.16.1
%global rpmversion     0.16.1

# For better or worse, there are a bunch of different arch binaries in this.
# They are not actually a problem, though, since we handle them carefully.
%define _binaries_in_noarch_packages_terminate_build   0

# Recent Fedora, EL >= 7 use systemd
%if 0%{?fedora} >= 18 || 0%{?rhel} >= 7
%global _with_systemd  1
%endif


Summary:        Razor is an advanced provisioning application
Name:           razor-server
Version:        %{rpmversion}
Release:        1%{?dist}
Vendor:         Puppet Labs
License:        Apache 2.0
Group:          System Environment/Base
URL:            http://www.puppetlabs.com/puppet/related-projects/%{name}
# Note this URL will only be valid at official tags from Puppet Labs
Source0:        http://puppetlabs.com/downloads/%{name}/%{name}-%{realversion}.tar.gz
BuildArch:      noarch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
AutoProv:       0

# We dynamically create our service account
Requires(pre): shadow-utils

# Depend on our basic toolchain
Requires(pre): razor-torquebox

Requires:       libarchive-devel

%if 0%{?_with_systemd}
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd
BuildRequires: systemd
%endif

%description
Razor is an advanced provisioning application which can deploy both bare-metal
and virtual systems. It's aimed at solving the problem of how to bring new
metal into a state where your existing DevOps/configuration management
workflows can take it over.

Newly added machines in a Razor deployment will PXE-boot from a special Razor
Microkernel image, then check in, provide Razor with inventory information, and
wait for further instructions. Razor will consult user-created policy rules to
choose which preconfigured model to apply to a new node, which will begin to
follow the model's directions, giving feedback to Razor as it completes various
steps. Models can include steps for handoff to a DevOps system such as Puppet
or to any other system capable of controlling the node (such as a vCenter
server taking possession of ESX systems).


%prep
%setup -q  -n %{name}-%{realversion}

%build

%install
rm -rf %{buildroot}

# These are used at runtime.
mkdir -p %{buildroot}/var/log/razor-server
mkdir -p %{buildroot}/var/lib/razor/repo-store

# Install the init script
%if 0%{?_with_systemd}
install -d -m0755  %{buildroot}%{_unitdir}
install -m0644 ext/redhat/%{name}.service %{buildroot}%{_unitdir}/
install -d -m0755 %{buildroot}%{_datadir}/%{name}
install -m0644 ext/redhat/%{name}.env %{buildroot}%{_datadir}/%{name}/
install -d -m0755 %{buildroot}/run/%{name}
install -d %{buildroot}%{_tmpfilesdir}
install -m0644 ext/redhat/%{name}-tmpfiles.conf %{buildroot}%{_tmpfilesdir}/%{name}.conf
%else
# Install the init script
mkdir -p %{buildroot}/var/run/razor-server
mkdir -p %{buildroot}%{_initrddir}
cp -p ext/razor-server.init %{buildroot}%{_initrddir}/razor-server
%endif
# OK, all the ext stuff is done...
rm -rf ext

# Unpack the Razor server sources
mkdir -p %{buildroot}/opt/razor
cp -pr .bundle * %{buildroot}/opt/razor

# Put the configuration in the global location
mkdir -p %{buildroot}/etc/razor
mv %{buildroot}/opt/razor/config.yaml.sample %{buildroot}/etc/razor/config.yaml
mv %{buildroot}/opt/razor/shiro.ini %{buildroot}/etc/razor/shiro.ini

# Create the links to wrap our commands.
mkdir -p %{buildroot}/usr/sbin
for cmd in bin/*; do
    cmd=$(basename ${cmd})
    if test x"${cmd}" != x"razor-binary-wrapper"; then
        ln -s /opt/razor/bin/razor-binary-wrapper %{buildroot}/usr/sbin/${cmd}
    fi
done


%post -p /bin/bash
# Register the service
%if 0%{?_with_systemd}
%systemd_post %{name}.service
%else
/sbin/chkconfig --add %{name} || :
%endif

# Cause our application to be deployed to TorqueBox, but only the first time
# we are installed.  Upgrades do not automatically trigger this, because a
# database migration may be required, and we want to avoid reloading code in a
# way that will break compared to that "admin intervention required"
# planned downtime.
if [ x"$1" = x"1" ]; then
    source /etc/razor/razor-torquebox.sh
    torquebox deploy /opt/razor --env=production
fi

exit 0

%preun -p /bin/bash
# Undeploy our application from TorqueBox.
source /etc/razor/razor-torquebox.sh
torquebox undeploy /opt/razor || :
%if 0%{?_with_systemd}
%systemd_preun %{name}.service
%else
/sbin/service razor-server stop >&/dev/null || :
/sbin/chkconfig --del razor-server || :
%endif

%postun
%if 0%{?_with_systemd}
%systemd_postun_with_restart %{name}.service
%else
if [ "${1}" -ge 1 ]; then
  /sbin/service %{name} reload >/dev/null 2>&1 || :
fi
%endif

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%attr(-,razor,razor) %dir /var/log/razor-server
%attr(-,razor,razor) %dir /var/lib/razor
%attr(-,razor,razor) %dir /var/lib/razor/repo-store
%if 0%{?_with_systemd}
%{_unitdir}/%{name}.service
%{_datadir}/%{name}/%{name}.env
%attr(-,razor,razor) %dir /run/%{name}/
%{_tmpfilesdir}/%{name}.conf
%else
%attr(-,razor,razor) %dir /var/run/razor-server
%attr(755,root,root) %{_initrddir}/%{name}
%endif

/opt/razor

# When flagged as configuration files, I see this:
# --> Processing Dependency: config(razor-server) = release.0.12.0.gc3c7b74-1.fc19 for package: razor-server-release.0.12.0.gc3c7b74-1.fc19.noarch
# --> Finished Dependency Resolution
# Error: Package: razor-server-release.0.12.0.gc3c7b74-1.fc19.noarch (/razor-server-release.0.12.0.gc3c7b74-1.fc19.noarch)
#            Requires: config(razor-server) = release.0.12.0.gc3c7b74-1.fc19
#  You could try using --skip-broken to work around the problem
# %config(noreplace) /etc/razor/config.yaml
# %config(noreplace) /etc/razor/shiro.ini

/etc/razor/config.yaml
/etc/razor/shiro.ini

# Our user focused symbolic links.
/usr/sbin/razor-admin

%changelog
* Tue Jan 13 2015 Puppet Labs Release <info@puppetlabs.com> -  0.16.1-1.pe
- Build for 0.16.1
