/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.util.ArrayList;
import java.util.Collection;
import org.xnio.Option;
import org.xnio.Sequence;

final class TypeSequenceOption<T>
extends Option<Sequence<Class<? extends T>>> {
    private static final long serialVersionUID = -4328676629293125136L;
    private final transient Class<T> elementDeclType;
    private final transient Option.ValueParser<Class<? extends T>> parser;

    TypeSequenceOption(Class<?> declClass, String name, Class<T> elementDeclType) {
        super(declClass, name);
        this.elementDeclType = elementDeclType;
        this.parser = Option.getClassParser(elementDeclType);
    }

    @Override
    public Sequence<Class<? extends T>> cast(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Sequence) {
            return TypeSequenceOption.castSeq((Sequence)o, this.elementDeclType);
        }
        if (o instanceof Object[]) {
            return TypeSequenceOption.castSeq(Sequence.of((Object[])o), this.elementDeclType);
        }
        if (o instanceof Collection) {
            return TypeSequenceOption.castSeq(Sequence.of((Collection)o), this.elementDeclType);
        }
        throw new ClassCastException("Not a sequence");
    }

    static <T> Sequence<Class<? extends T>> castSeq(Sequence<?> seq, Class<T> type) {
        for (Class<T> clazz : seq) {
            clazz.asSubclass(type);
        }
        return seq;
    }

    @Override
    public Sequence<Class<? extends T>> parseValue(String string, ClassLoader classLoader) throws IllegalArgumentException {
        ArrayList<Class<? extends T>> list = new ArrayList<Class<? extends T>>();
        for (String value : string.split(",")) {
            list.add(this.parser.parseValue(value, classLoader));
        }
        return Sequence.of(list);
    }
}

