/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.naming.ejb;

import java.util.HashMap;
import org.jboss.ejb.client.naming.ejb.EjbJndiIdentifier;

class EjbJndiNameParser {
    EjbJndiNameParser() {
    }

    public static EjbJndiIdentifier parse(String name) {
        int pos;
        if (!name.startsWith("ejb:")) {
            throw new IllegalArgumentException("Name must start with :ejb");
        }
        for (pos = 3; pos < name.length() && name.charAt(pos) != '/'; ++pos) {
        }
        String application = name.substring(4, pos);
        if (pos >= name.length() - 1) {
            return new EjbJndiIdentifier(application, null, null, null, null, null);
        }
        return EjbJndiNameParser.parse(application, name.substring(pos + 1));
    }

    public static final EjbJndiIdentifier parse(String applicationName, String remaining) {
        int pos;
        for (pos = 0; pos < remaining.length() && remaining.charAt(pos) != '/'; ++pos) {
        }
        String moduleName = remaining.substring(0, pos);
        if (pos >= remaining.length() - 1) {
            return new EjbJndiIdentifier(applicationName, moduleName, null, null, null, null);
        }
        return EjbJndiNameParser.parse(applicationName, moduleName, remaining.substring(pos + 1));
    }

    public static final EjbJndiIdentifier parse(String applicationName, String moduleName, String remaining) {
        int pos;
        for (pos = 0; pos < remaining.length() && remaining.charAt(pos) != '/' && remaining.charAt(pos) != '!'; ++pos) {
        }
        String part = remaining.substring(0, pos);
        if (pos >= remaining.length() - 1) {
            return new EjbJndiIdentifier(applicationName, moduleName, part, null, null, null);
        }
        if (remaining.charAt(pos) == '/') {
            return EjbJndiNameParser.parse(applicationName, moduleName, part, remaining.substring(pos + 1));
        }
        return EjbJndiNameParser.parse(applicationName, moduleName, "", part, remaining.substring(pos + 1));
    }

    public static final EjbJndiIdentifier parse(String applicationName, String moduleName, String distinctName, String remaining) {
        int pos;
        for (pos = 0; pos < remaining.length() && remaining.charAt(pos) != '!'; ++pos) {
        }
        if (pos >= remaining.length() - 1) {
            throw new IllegalArgumentException("EjbName did not specify a view using ejbName!com.my.ViewClass syntax");
        }
        String ejbName = remaining.substring(0, pos);
        return EjbJndiNameParser.parse(applicationName, moduleName, distinctName, ejbName, remaining.substring(pos + 1));
    }

    public static final EjbJndiIdentifier parse(String applicationName, String moduleName, String distinctName, String ejbName, String remaining) {
        String viewName;
        int pos;
        for (pos = 0; pos < remaining.length() && remaining.charAt(pos) != '?'; ++pos) {
        }
        HashMap<String, String> viewOptions = new HashMap<String, String>();
        if (pos >= remaining.length() - 1) {
            viewName = remaining;
        } else {
            String[] options;
            viewName = remaining.substring(0, pos);
            for (String option : options = remaining.substring(pos + 1).split("&")) {
                String[] parts = option.split("=");
                if (parts.length == 1) {
                    viewOptions.put(parts[0], null);
                    continue;
                }
                if (parts.length == 2) {
                    viewOptions.put(parts[0], parts[1]);
                    continue;
                }
                throw new IllegalArgumentException("Invalid option " + option);
            }
        }
        return new EjbJndiIdentifier(applicationName, moduleName, distinctName, ejbName, viewName, viewOptions);
    }
}

