(ns cheshire.jsonp
  (:require [clojure.java.io :refer :all])
  (:import (java.io StringWriter)
           (javax.json Json)))

(def w (StringWriter.))

(def g (Json/createGenerator w))

(.writeStartObject g)
(.writeEnd g)
(.close g)

(println (.toString w))

;; JSON arrays can be created using JsonGenerator by calling the writeStartArray () method and then adding values with the write method.
;; The following example shows how to generate an empty JSON array:
;; JsonGenerator generator = ...;
;; generator.writeStartArray ().writeEnd ().close ();

;; JsonGenerator methods can be chained as in the following example:
;; generator
;; .writeStartObject ()
;; .write ("firstName", "John")
;; .write ("lastName", "Smith")
;; .write ("age", 25)
;; .writeStartObject ("address")
;; .write ("streetAddress", "21 2nd Street")
;; .write ("city", "New York")
;; .write ("state", "NY")
;; .write ("postalCode", "10021")
;; .writeEnd ()
;; .writeStartArray ("phoneNumber")
;; .writeStartObject ()
;; .write ("type", "home")
;; .write ("number", "212 555-1234")
;; .writeEnd ()
;; .writeStartObject ()
;; .write ("type", "fax")
;; .write ("number", "646 555-4567")
;; .writeEnd ()
;; .writeEnd ()
;; .writeEnd ();
;; generator.close ();
;; The example code above generates the following JSON (or equivalent):
;; {
;;  "firstName": "John", "lastName": "Smith", "age": 25,
;;  "address" : {
;;               "streetAddress": "21 2nd Street",
;;               "city": "New York",
;;               "state": "NY",
;;               "postalCode": "10021"},
;;  "phoneNumber": [
;;                  {"type": "home", "number": "212 555-1234"},
;;                  {"type": "fax", "number": "646 555-4567"}]}
