## Report interchange format

A report is represented as JSON (this implies UTF-8 encoding). Unless
otherwise noted, `null` is not allowed anywhere in the catalog.

    {
        "certname": <string>,
        "puppet-version": <string>,
        "report-format": <int>,
        "configuration-version": <string>,
        "start-time": <datetime>,
        "end-time": <datetime>,
        "resource-events": [<resource-event>, <resource-event>, ...]
    }

All keys are mandatory, though values that are lists may be empty
lists.

`"certname"` is the certname the report is associated with.

`"puppet-version"` is the version of puppet that was run to generate this report.

`"report-format"` is the version number of the report format that puppet used
to generate the original report data.  This is a constant defined by puppet.

`"configuration-version"` is an identifier string that puppet uses to match a
specific catalog for a node to a specific puppet run.  This value is
generated by puppet.

`"start-time"` is the time at which the puppet run began; see more details about
the `datetime` format below.

`"end-time"` is the time at which the puppet run completed; see more details about
the `datetime` format below.

### Encoding

The entire report is expected to be valid JSON, which implies UTF-8
encoding.

### Data type: `<string>`

A JSON string. By virtue of the report being UTF-8, these must also
be UTF-8.

### Data type: `<integer>`

A JSON int.

### Data type: `<datetime>`

A JSON string representing a date and time (with time zone), formatted based on
the recommendations in ISO8601; so, e.g., for a UTC time, the String would be
formatted as `YYYY-MM-DDThh:mm:ss.sssZ`.  For non-UTC, the `Z` may be replaced
with `±hh:mm` to represent the specific timezone.

### Data type: `<resource-event>`

A JSON Object of the following form:

    {
     "resource-type": <string>,
     "resource-title": <string>,
     "property": <string>,
     "timestamp": <datetime>,
     "status": <string>,
     "old-value": <string>,
     "new-value": <string>,
     "message": <string>
    }

All keys are required.

`"resource-type"` is the name of the puppet resource type that the event occurred on.

`"resource-title"` is the title of the puppet resource that the event occurred on.

`"property"` is the name of the property of the resource for which the event occurred.
This may be `null` only if the `status` is `skipped`.

`"timestamp"` is the date/time at which the event occurred.

`"status"` is a string representing the outcome of the event; this should be one
of `success`, `failure`, or `skipped`.

`"old-value"` is the value that puppet determined the property to have held prior
to the event.

`"new-value"` is the value that puppet was instructed to set the property to.

`"message"` is a descriptive message providing extra information about the event.
This should be `null` if `status` is `success`.

## Gaps with this wire format

1. Binary data needs to be dealt with (hopefully only for the `old-value` and
`new-value` fields.
