; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=inline %s -S -pass-remarks-missed=inline 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-INLINE
; RUN: opt -passes=always-inline %s -S | FileCheck %s

; Test that we don't inline when caller and callee don't have matching
; noprofile fn attrs.

; CHECK-INLINE: profile not inlined into profile_caller because it should never be inlined (cost=never): conflicting attributes
; CHECK-INLINE: noprofile not inlined into noprofile_caller because it should never be inlined (cost=never): conflicting attributes

define i32 @profile() { ret i32 42 }
define i32 @noprofile() noprofile { ret i32 43 }
define i32 @profile_aa() alwaysinline { ret i32 44 }
define i32 @noprofile_aa() noprofile alwaysinline { ret i32 45 }

define i32 @profile_caller() noprofile {
; CHECK-LABEL: @profile_caller(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @profile()
; CHECK-NEXT:    ret i32 44
;
  call i32 @profile()
  %2 = call i32 @profile_aa()
  ret i32 %2
}

define i32 @noprofile_caller() {
; CHECK-LABEL: @noprofile_caller(
; CHECK-NEXT:    [[TMP1:%.*]] = call i32 @noprofile()
; CHECK-NEXT:    ret i32 45
;
  call i32 @noprofile()
  %2 = call i32 @noprofile_aa()
  ret i32 %2
}

; Test that we do inline when caller and callee don't have matching
; noprofile fn attrs, when CallInst is alwaysinline.
define i32 @aa_callsite() {
; CHECK-INLINE-LABEL: @aa_callsite(
; CHECK-INLINE-NEXT:    ret i32 43
;
  %1 = call i32 @noprofile() alwaysinline
  ret i32 %1
}
