; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx700 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx803 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx906 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1011 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1012 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DL %s

define amdgpu_kernel void @udot8_acc32(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_acc32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v9, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_acc32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    flat_load_dword v1, v[2:3]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 28, v0
; GFX8-NEXT:    v_bfe_u32 v3, v0, 24, 4
; GFX8-NEXT:    v_bfe_u32 v4, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v5, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v6, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v7, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v8, v0, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 28, v1
; GFX8-NEXT:    v_bfe_u32 v10, v1, 24, 4
; GFX8-NEXT:    v_bfe_u32 v11, v1, 20, 4
; GFX8-NEXT:    v_bfe_u32 v12, v1, 16, 4
; GFX8-NEXT:    v_bfe_u32 v13, v1, 12, 4
; GFX8-NEXT:    v_bfe_u32 v14, v1, 8, 4
; GFX8-NEXT:    v_bfe_u32 v15, v1, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v1, s2
; GFX8-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v9, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_acc32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 28, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 28, v2
; GFX9-NEXT:    v_bfe_u32 v4, v1, 24, 4
; GFX9-NEXT:    v_bfe_u32 v11, v2, 24, 4
; GFX9-NEXT:    v_bfe_u32 v5, v1, 20, 4
; GFX9-NEXT:    v_bfe_u32 v12, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v6, v1, 16, 4
; GFX9-NEXT:    v_bfe_u32 v13, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v7, v1, 12, 4
; GFX9-NEXT:    v_bfe_u32 v14, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v8, v1, 8, 4
; GFX9-NEXT:    v_bfe_u32 v9, v1, 4, 4
; GFX9-NEXT:    v_bfe_u32 v15, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v16, v2, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX9-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v2, v9, v16
; GFX9-NEXT:    v_mul_u32_u24_e32 v8, v8, v15
; GFX9-NEXT:    v_mul_u32_u24_e32 v7, v7, v14
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add3_u32 v1, v1, s0, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v6, v6, v13
; GFX9-NEXT:    v_mul_u32_u24_e32 v5, v5, v12
; GFX9-NEXT:    v_add3_u32 v1, v1, v8, v7
; GFX9-NEXT:    v_mul_u32_u24_e32 v4, v4, v11
; GFX9-NEXT:    v_mul_u32_u24_e32 v3, v3, v10
; GFX9-NEXT:    v_add3_u32 v1, v1, v6, v5
; GFX9-NEXT:    v_add3_u32 v1, v1, v4, v3
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_acc32:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot8_u32_u4 v0, v2, v3, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_acc32:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot8_u32_u4 v1, v1, v2, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                       <8 x i4> addrspace(1)* %src2,
                                       i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %cv1e0 = zext i4 %v1e0 to i32
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %cv2e0 = zext i4 %v2e0 to i32
  %mul0 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %cv1e1 = zext i4 %v1e1 to i32
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %cv2e1 = zext i4 %v2e1 to i32
  %mul1 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %cv1e2 = zext i4 %v1e2 to i32
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %cv2e2 = zext i4 %v2e2 to i32
  %mul2 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %cv1e3 = zext i4 %v1e3 to i32
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %cv2e3 = zext i4 %v2e3 to i32
  %mul3 = mul nuw nsw i32 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %cv1e4 = zext i4 %v1e4 to i32
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %cv2e4 = zext i4 %v2e4 to i32
  %mul4 = mul nuw nsw i32 %cv1e4, %cv2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %cv1e5 = zext i4 %v1e5 to i32
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %cv2e5 = zext i4 %v2e5 to i32
  %mul5 = mul nuw nsw i32 %cv1e5, %cv2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %cv1e6 = zext i4 %v1e6 to i32
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %cv2e6 = zext i4 %v2e6 to i32
  %mul6 = mul nuw nsw i32 %cv1e6, %cv2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %cv1e7 = zext i4 %v1e7 to i32
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %cv2e7 = zext i4 %v2e7 to i32
  %mul7 = mul nuw nsw i32 %cv1e7, %cv2e7

  %acc = load i32, i32 addrspace(1)* %dst, align 4
  %add1 = add i32 %mul0, %acc
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3
  %add5 = add i32 %add4, %mul4
  %add6 = add i32 %add5, %mul5
  %add7 = add i32 %add6, %mul6
  %add8 = add i32 %add7, %mul7

  store i32 %add8, i32 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Remove the unnecessary instruction(that is zero-extending the
; 2nd MAD) to have the pattern-recognizer to kick in.
define amdgpu_kernel void @udot8_acc16(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_acc16:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v16, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v16
; GFX7-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v9, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_acc16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_load_ushort v18, v[2:3]
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 28, v4
; GFX8-NEXT:    v_bfe_u32 v5, v4, 24, 4
; GFX8-NEXT:    v_bfe_u32 v6, v4, 20, 4
; GFX8-NEXT:    v_bfe_u32 v7, v4, 16, 4
; GFX8-NEXT:    v_bfe_u32 v8, v4, 12, 4
; GFX8-NEXT:    v_bfe_u32 v9, v4, 8, 4
; GFX8-NEXT:    v_bfe_u32 v10, v4, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v4, 15, v4
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 28, v0
; GFX8-NEXT:    v_bfe_u32 v12, v0, 24, 4
; GFX8-NEXT:    v_bfe_u32 v13, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v14, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v15, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v16, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v17, v0, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v18
; GFX8-NEXT:    v_mad_u16 v0, v10, v17, v0
; GFX8-NEXT:    v_mad_u16 v0, v9, v16, v0
; GFX8-NEXT:    v_mad_u16 v0, v8, v15, v0
; GFX8-NEXT:    v_mad_u16 v0, v7, v14, v0
; GFX8-NEXT:    v_mad_u16 v0, v6, v13, v0
; GFX8-NEXT:    v_mad_u16 v0, v5, v12, v0
; GFX8-NEXT:    v_mad_u16 v0, v1, v11, v0
; GFX8-NEXT:    flat_store_short v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_acc16:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-NEXT:    global_load_ushort v17, v1, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 28, v2
; GFX9-NEXT:    v_bfe_u32 v4, v2, 24, 4
; GFX9-NEXT:    v_bfe_u32 v5, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v9, v2, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 28, v3
; GFX9-NEXT:    v_bfe_u32 v11, v3, 24, 4
; GFX9-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX9-NEXT:    v_bfe_u32 v13, v3, 16, 4
; GFX9-NEXT:    v_bfe_u32 v14, v3, 12, 4
; GFX9-NEXT:    v_bfe_u32 v15, v3, 8, 4
; GFX9-NEXT:    v_bfe_u32 v16, v3, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v3, 15, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_legacy_u16 v2, v2, v3, v17
; GFX9-NEXT:    v_mad_legacy_u16 v2, v9, v16, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v8, v15, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v7, v14, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v6, v13, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v5, v12, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v4, v11, v2
; GFX9-NEXT:    v_mad_legacy_u16 v0, v0, v10, v2
; GFX9-NEXT:    global_store_short v1, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_acc16:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ushort v17, v1, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v0, 28, v2
; GFX9-DL-NEXT:    v_bfe_u32 v4, v2, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v5, v2, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v9, v2, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 28, v3
; GFX9-DL-NEXT:    v_bfe_u32 v11, v3, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v13, v3, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v14, v3, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v15, v3, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v16, v3, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v3, 15, v3
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v2, v3, v17
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v9, v16, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v8, v15, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v7, v14, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v6, v13, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v5, v12, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v4, v11, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v0, v10, v2
; GFX9-DL-NEXT:    global_store_short v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_acc16:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX10-DL-NEXT:    global_load_ushort v4, v1, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_and_b32_e32 v0, 15, v2
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v5, 15, v3
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 4, 4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v0, v0, v5, v4
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 8, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 8, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 12, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 16, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 16, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 20, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 20, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 24, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 24, 4
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 28, v3
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v2, v3, v0
; GFX10-DL-NEXT:    global_store_short v1, v0, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
                                       <8 x i4> addrspace(1)* %src2,
                                       i16 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %cv1e0 = zext i4 %v1e0 to i16
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %cv2e0 = zext i4 %v2e0 to i16
  %mul0 = mul nuw nsw i16 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %cv1e1 = zext i4 %v1e1 to i16
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %cv2e1 = zext i4 %v2e1 to i16
  %mul1 = mul nuw nsw i16 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %cv1e2 = zext i4 %v1e2 to i16
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %cv2e2 = zext i4 %v2e2 to i16
  %mul2 = mul nuw nsw i16 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %cv1e3 = zext i4 %v1e3 to i16
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %cv2e3 = zext i4 %v2e3 to i16
  %mul3 = mul nuw nsw i16 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %cv1e4 = zext i4 %v1e4 to i16
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %cv2e4 = zext i4 %v2e4 to i16
  %mul4 = mul nuw nsw i16 %cv1e4, %cv2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %cv1e5 = zext i4 %v1e5 to i16
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %cv2e5 = zext i4 %v2e5 to i16
  %mul5 = mul nuw nsw i16 %cv1e5, %cv2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %cv1e6 = zext i4 %v1e6 to i16
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %cv2e6 = zext i4 %v2e6 to i16
  %mul6 = mul nuw nsw i16 %cv1e6, %cv2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %cv1e7 = zext i4 %v1e7 to i16
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %cv2e7 = zext i4 %v2e7 to i16
  %mul7 = mul nuw nsw i16 %cv1e7, %cv2e7

  %acc = load i16, i16 addrspace(1)* %dst, align 4
  %add1 = add i16 %mul0, %acc
  %add2 = add i16 %add1, %mul1
  %add3 = add i16 %add2, %mul2
  %add4 = add i16 %add3, %mul3
  %add5 = add i16 %add4, %mul4
  %add6 = add i16 %add5, %mul5
  %add7 = add i16 %add6, %mul6
  %add8 = add i16 %add7, %mul7

  store i16 %add8, i16 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Remove the unnecessary instruction(that is zero-extending the
; 2nd MAD) to have the pattern-recognizer to kick in.
define amdgpu_kernel void @udot8_acc8(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_acc8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ubyte v16, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v16
; GFX7-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v9, v0
; GFX7-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_acc8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_load_ubyte v18, v[2:3]
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 28, v4
; GFX8-NEXT:    v_bfe_u32 v5, v4, 24, 4
; GFX8-NEXT:    v_bfe_u32 v6, v4, 20, 4
; GFX8-NEXT:    v_bfe_u32 v7, v4, 16, 4
; GFX8-NEXT:    v_bfe_u32 v8, v4, 12, 4
; GFX8-NEXT:    v_bfe_u32 v9, v4, 8, 4
; GFX8-NEXT:    v_bfe_u32 v10, v4, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v4, 15, v4
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 28, v0
; GFX8-NEXT:    v_bfe_u32 v12, v0, 24, 4
; GFX8-NEXT:    v_bfe_u32 v13, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v14, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v15, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v16, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v17, v0, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v18
; GFX8-NEXT:    v_mad_u16 v0, v10, v17, v0
; GFX8-NEXT:    v_mad_u16 v0, v9, v16, v0
; GFX8-NEXT:    v_mad_u16 v0, v8, v15, v0
; GFX8-NEXT:    v_mad_u16 v0, v7, v14, v0
; GFX8-NEXT:    v_mad_u16 v0, v6, v13, v0
; GFX8-NEXT:    v_mad_u16 v0, v5, v12, v0
; GFX8-NEXT:    v_mad_u16 v0, v1, v11, v0
; GFX8-NEXT:    flat_store_byte v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_acc8:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-NEXT:    global_load_ubyte v17, v1, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 28, v2
; GFX9-NEXT:    v_bfe_u32 v4, v2, 24, 4
; GFX9-NEXT:    v_bfe_u32 v5, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v9, v2, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 28, v3
; GFX9-NEXT:    v_bfe_u32 v11, v3, 24, 4
; GFX9-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX9-NEXT:    v_bfe_u32 v13, v3, 16, 4
; GFX9-NEXT:    v_bfe_u32 v14, v3, 12, 4
; GFX9-NEXT:    v_bfe_u32 v15, v3, 8, 4
; GFX9-NEXT:    v_bfe_u32 v16, v3, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v3, 15, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_legacy_u16 v2, v2, v3, v17
; GFX9-NEXT:    v_mad_legacy_u16 v2, v9, v16, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v8, v15, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v7, v14, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v6, v13, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v5, v12, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v4, v11, v2
; GFX9-NEXT:    v_mad_legacy_u16 v0, v0, v10, v2
; GFX9-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_acc8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ubyte v17, v1, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v0, 28, v2
; GFX9-DL-NEXT:    v_bfe_u32 v4, v2, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v5, v2, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v9, v2, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 28, v3
; GFX9-DL-NEXT:    v_bfe_u32 v11, v3, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v13, v3, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v14, v3, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v15, v3, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v16, v3, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v3, 15, v3
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v2, v3, v17
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v9, v16, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v8, v15, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v7, v14, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v6, v13, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v5, v12, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v4, v11, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v0, v10, v2
; GFX9-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_acc8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX10-DL-NEXT:    global_load_ubyte v4, v1, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_and_b32_e32 v0, 15, v2
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v5, 15, v3
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 4, 4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v0, v0, v5, v4
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 8, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 8, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 12, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 16, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 16, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 20, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 20, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 24, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 24, 4
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 28, v3
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v2, v3, v0
; GFX10-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
                                      <8 x i4> addrspace(1)* %src2,
                                      i8 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %cv1e0 = zext i4 %v1e0 to i8
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %cv2e0 = zext i4 %v2e0 to i8
  %mul0 = mul nuw nsw i8 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %cv1e1 = zext i4 %v1e1 to i8
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %cv2e1 = zext i4 %v2e1 to i8
  %mul1 = mul nuw nsw i8 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %cv1e2 = zext i4 %v1e2 to i8
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %cv2e2 = zext i4 %v2e2 to i8
  %mul2 = mul nuw nsw i8 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %cv1e3 = zext i4 %v1e3 to i8
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %cv2e3 = zext i4 %v2e3 to i8
  %mul3 = mul nuw nsw i8 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %cv1e4 = zext i4 %v1e4 to i8
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %cv2e4 = zext i4 %v2e4 to i8
  %mul4 = mul nuw nsw i8 %cv1e4, %cv2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %cv1e5 = zext i4 %v1e5 to i8
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %cv2e5 = zext i4 %v2e5 to i8
  %mul5 = mul nuw nsw i8 %cv1e5, %cv2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %cv1e6 = zext i4 %v1e6 to i8
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %cv2e6 = zext i4 %v2e6 to i8
  %mul6 = mul nuw nsw i8 %cv1e6, %cv2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %cv1e7 = zext i4 %v1e7 to i8
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %cv2e7 = zext i4 %v2e7 to i8
  %mul7 = mul nuw nsw i8 %cv1e7, %cv2e7

  %acc = load i8, i8 addrspace(1)* %dst, align 4
  %add1 = add i8 %mul0, %acc
  %add2 = add i8 %add1, %mul1
  %add3 = add i8 %add2, %mul2
  %add4 = add i8 %add3, %mul3
  %add5 = add i8 %add4, %mul4
  %add6 = add i8 %add5, %mul5
  %add7 = add i8 %add6, %mul6
  %add8 = add i8 %add7, %mul7

  store i8 %add8, i8 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Remove the two unnecessary instructions(and+add after 2nd MAD)
; to have the pattern-recognizer to kick in.
define amdgpu_kernel void @udot8_acc4(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_acc4:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ubyte v16, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v16
; GFX7-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v9, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_acc4:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_load_ubyte v18, v[2:3]
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 28, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v4
; GFX8-NEXT:    v_bfe_u32 v6, v4, 20, 4
; GFX8-NEXT:    v_bfe_u32 v7, v4, 16, 4
; GFX8-NEXT:    v_bfe_u32 v8, v4, 12, 4
; GFX8-NEXT:    v_bfe_u32 v9, v4, 8, 4
; GFX8-NEXT:    v_bfe_u32 v10, v4, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v4, 15, v4
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 28, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v0
; GFX8-NEXT:    v_bfe_u32 v13, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v14, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v15, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v16, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v17, v0, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v18
; GFX8-NEXT:    v_mad_u16 v0, v10, v17, v0
; GFX8-NEXT:    v_mad_u16 v0, v9, v16, v0
; GFX8-NEXT:    v_mad_u16 v0, v8, v15, v0
; GFX8-NEXT:    v_mad_u16 v0, v7, v14, v0
; GFX8-NEXT:    v_mad_u16 v0, v6, v13, v0
; GFX8-NEXT:    v_mad_u16 v0, v5, v12, v0
; GFX8-NEXT:    v_mad_u16 v0, v1, v11, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    flat_store_byte v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_acc4:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-NEXT:    global_load_ubyte v17, v1, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 28, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX9-NEXT:    v_bfe_u32 v5, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v9, v2, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 28, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX9-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX9-NEXT:    v_bfe_u32 v13, v3, 16, 4
; GFX9-NEXT:    v_bfe_u32 v14, v3, 12, 4
; GFX9-NEXT:    v_bfe_u32 v15, v3, 8, 4
; GFX9-NEXT:    v_bfe_u32 v16, v3, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v3, 15, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_legacy_u16 v2, v2, v3, v17
; GFX9-NEXT:    v_mad_legacy_u16 v2, v9, v16, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v8, v15, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v7, v14, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v6, v13, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v5, v12, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v4, v11, v2
; GFX9-NEXT:    v_mad_legacy_u16 v0, v0, v10, v2
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_acc4:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ubyte v17, v1, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v0, 28, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX9-DL-NEXT:    v_bfe_u32 v5, v2, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v9, v2, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 28, v3
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX9-DL-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v13, v3, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v14, v3, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v15, v3, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v16, v3, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v3, 15, v3
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v2, v3, v17
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v9, v16, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v8, v15, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v7, v14, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v6, v13, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v5, v12, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v4, v11, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v0, v10, v2
; GFX9-DL-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_acc4:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX10-DL-NEXT:    global_load_ubyte v4, v1, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_and_b32_e32 v0, 15, v2
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v5, 15, v3
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 4, 4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v0, v0, v5, v4
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 8, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 8, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 12, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 16, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 16, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 20, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 20, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 24, v3
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 28, v3
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v2, v3, v0
; GFX10-DL-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX10-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
                                      <8 x i4> addrspace(1)* %src2,
                                      i4 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %mul0 = mul nuw nsw i4 %v1e0, %v2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %mul1 = mul nuw nsw i4 %v1e1, %v2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %mul2 = mul nuw nsw i4 %v1e2, %v2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %mul3 = mul nuw nsw i4 %v1e3, %v2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %mul4 = mul nuw nsw i4 %v1e4, %v2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %mul5 = mul nuw nsw i4 %v1e5, %v2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %mul6 = mul nuw nsw i4 %v1e6, %v2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %mul7 = mul nuw nsw i4 %v1e7, %v2e7

  %acc = load i4, i4 addrspace(1)* %dst, align 4
  %add1 = add i4 %mul0, %acc
  %add2 = add i4 %add1, %mul1
  %add3 = add i4 %add2, %mul2
  %add4 = add i4 %add3, %mul3
  %add5 = add i4 %add4, %mul4
  %add6 = add i4 %add5, %mul5
  %add7 = add i4 %add6, %mul6
  %add8 = add i4 %add7, %mul7

  store i4 %add8, i4 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Currently, permutation of udot8 is turned off due to a huge increase
; in the compile time.
define amdgpu_kernel void @udot8_CommutationInsideMAD(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_CommutationInsideMAD:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ubyte v16, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v16
; GFX7-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v9, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_CommutationInsideMAD:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_load_ubyte v18, v[2:3]
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 28, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v4
; GFX8-NEXT:    v_bfe_u32 v6, v4, 20, 4
; GFX8-NEXT:    v_bfe_u32 v7, v4, 16, 4
; GFX8-NEXT:    v_bfe_u32 v8, v4, 12, 4
; GFX8-NEXT:    v_bfe_u32 v9, v4, 8, 4
; GFX8-NEXT:    v_bfe_u32 v10, v4, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v4, 15, v4
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 28, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v0
; GFX8-NEXT:    v_bfe_u32 v13, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v14, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v15, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v16, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v17, v0, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v18
; GFX8-NEXT:    v_mad_u16 v0, v10, v17, v0
; GFX8-NEXT:    v_mad_u16 v0, v9, v16, v0
; GFX8-NEXT:    v_mad_u16 v0, v8, v15, v0
; GFX8-NEXT:    v_mad_u16 v0, v7, v14, v0
; GFX8-NEXT:    v_mad_u16 v0, v6, v13, v0
; GFX8-NEXT:    v_mad_u16 v0, v5, v12, v0
; GFX8-NEXT:    v_mad_u16 v0, v1, v11, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    flat_store_byte v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_CommutationInsideMAD:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-NEXT:    global_load_ubyte v17, v1, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 28, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX9-NEXT:    v_bfe_u32 v5, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v9, v2, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 28, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX9-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX9-NEXT:    v_bfe_u32 v13, v3, 16, 4
; GFX9-NEXT:    v_bfe_u32 v14, v3, 12, 4
; GFX9-NEXT:    v_bfe_u32 v15, v3, 8, 4
; GFX9-NEXT:    v_bfe_u32 v16, v3, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v3, 15, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mad_legacy_u16 v2, v2, v3, v17
; GFX9-NEXT:    v_mad_legacy_u16 v2, v9, v16, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v8, v15, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v7, v14, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v6, v13, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v5, v12, v2
; GFX9-NEXT:    v_mad_legacy_u16 v2, v4, v11, v2
; GFX9-NEXT:    v_mad_legacy_u16 v0, v0, v10, v2
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_CommutationInsideMAD:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ubyte v17, v1, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v0, 28, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX9-DL-NEXT:    v_bfe_u32 v5, v2, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v9, v2, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 28, v3
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX9-DL-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v13, v3, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v14, v3, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v15, v3, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v16, v3, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v3, 15, v3
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v2, v3, v17
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v9, v16, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v8, v15, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v7, v14, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v6, v13, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v5, v12, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v4, v11, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v0, v10, v2
; GFX9-DL-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_CommutationInsideMAD:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX10-DL-NEXT:    global_load_ubyte v4, v1, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_and_b32_e32 v0, 15, v2
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v5, 15, v3
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 4, 4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v0, v0, v5, v4
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 8, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 8, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 12, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_bfe_u32 v4, v2, 16, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v3, 16, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 20, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v3, 20, 4
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 24, v3
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 28, v3
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v4, v5, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v2, v3, v0
; GFX10-DL-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX10-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
                                                      <8 x i4> addrspace(1)* %src2,
                                                      i4 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %mul0 = mul nuw nsw i4 %v1e0, %v2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %mul1 = mul nuw nsw i4 %v1e1, %v2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %mul2 = mul nuw nsw i4 %v1e2, %v2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %mul3 = mul nuw nsw i4 %v1e3, %v2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %mul4 = mul nuw nsw i4 %v1e4, %v2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %mul5 = mul nuw nsw i4 %v1e5, %v2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %mul6 = mul nuw nsw i4 %v1e6, %v2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %mul7 = mul nuw nsw i4 %v1e7, %v2e7

  %acc = load i4, i4 addrspace(1)* %dst, align 4
  %add1 = add i4 %mul0, %acc
  %add2 = add i4 %mul1, %add1
  %add3 = add i4 %mul2, %add2
  %add4 = add i4 %mul3, %add3
  %add5 = add i4 %mul4, %add4
  %add6 = add i4 %mul5, %add5
  %add7 = add i4 %mul6, %add6
  %add8 = add i4 %mul7, %add7

  store i4 %add8, i4 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot8_multiuses_mul1(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_multiuses_mul1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v16, v2, v0, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v16
; GFX7-NEXT:    v_mad_u32_u24 v2, v8, v15, v16
; GFX7-NEXT:    v_mad_u32_u24 v2, v7, v14, v2
; GFX7-NEXT:    v_mad_u32_u24 v2, v6, v13, v2
; GFX7-NEXT:    v_mad_u32_u24 v2, v5, v12, v2
; GFX7-NEXT:    v_mad_u32_u24 v2, v4, v11, v2
; GFX7-NEXT:    v_mad_u32_u24 v2, v3, v10, v2
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v9, v2
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_multiuses_mul1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    flat_load_dword v1, v[2:3]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 28, v0
; GFX8-NEXT:    v_bfe_u32 v3, v0, 24, 4
; GFX8-NEXT:    v_bfe_u32 v4, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v5, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v6, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v7, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v8, v0, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 28, v1
; GFX8-NEXT:    v_bfe_u32 v10, v1, 24, 4
; GFX8-NEXT:    v_bfe_u32 v11, v1, 20, 4
; GFX8-NEXT:    v_bfe_u32 v12, v1, 16, 4
; GFX8-NEXT:    v_bfe_u32 v13, v1, 12, 4
; GFX8-NEXT:    v_bfe_u32 v14, v1, 8, 4
; GFX8-NEXT:    v_bfe_u32 v15, v1, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v16, v0, v1, s2
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v1, v16
; GFX8-NEXT:    v_mad_u32_u24 v1, v8, v15, v16
; GFX8-NEXT:    v_mad_u32_u24 v1, v7, v14, v1
; GFX8-NEXT:    v_mad_u32_u24 v1, v6, v13, v1
; GFX8-NEXT:    v_mad_u32_u24 v1, v5, v12, v1
; GFX8-NEXT:    v_mad_u32_u24 v1, v4, v11, v1
; GFX8-NEXT:    v_mad_u32_u24 v1, v3, v10, v1
; GFX8-NEXT:    v_mad_u32_u24 v1, v2, v9, v1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_multiuses_mul1:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_bfe_u32 v3, v1, 4, 4
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 28, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 28, v2
; GFX9-NEXT:    v_bfe_u32 v5, v1, 24, 4
; GFX9-NEXT:    v_bfe_u32 v12, v2, 24, 4
; GFX9-NEXT:    v_bfe_u32 v6, v1, 20, 4
; GFX9-NEXT:    v_bfe_u32 v13, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v7, v1, 16, 4
; GFX9-NEXT:    v_bfe_u32 v14, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v8, v1, 12, 4
; GFX9-NEXT:    v_bfe_u32 v9, v1, 8, 4
; GFX9-NEXT:    v_bfe_u32 v15, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v16, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v10, v2, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX9-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v17, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mad_u32_u24 v1, v1, v2, s0
; GFX9-NEXT:    v_mul_u32_u24_e32 v9, v9, v16
; GFX9-NEXT:    v_mul_u32_u24_e32 v8, v8, v15
; GFX9-NEXT:    v_mad_u32_u24 v2, v3, v10, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v7, v7, v14
; GFX9-NEXT:    v_mul_u32_u24_e32 v6, v6, v13
; GFX9-NEXT:    v_add3_u32 v2, v2, v9, v8
; GFX9-NEXT:    v_mul_u32_u24_e32 v5, v5, v12
; GFX9-NEXT:    v_mul_u32_u24_e32 v4, v4, v11
; GFX9-NEXT:    v_add3_u32 v2, v2, v7, v6
; GFX9-NEXT:    v_add3_u32 v2, v2, v5, v4
; GFX9-NEXT:    v_add3_u32 v1, v17, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_multiuses_mul1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_bfe_u32 v3, v1, 4, 4
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v4, 28, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v11, 28, v2
; GFX9-DL-NEXT:    v_bfe_u32 v5, v1, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v12, v2, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v6, v1, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v13, v2, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v7, v1, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v14, v2, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v8, v1, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v9, v1, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v15, v2, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v16, v2, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v10, v2, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX9-DL-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v17, v1, v2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_u32_u24 v1, v1, v2, s0
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v9, v9, v16
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v8, v8, v15
; GFX9-DL-NEXT:    v_mad_u32_u24 v2, v3, v10, v1
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v7, v7, v14
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v6, v6, v13
; GFX9-DL-NEXT:    v_add3_u32 v2, v2, v9, v8
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v5, v5, v12
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v4, v4, v11
; GFX9-DL-NEXT:    v_add3_u32 v2, v2, v7, v6
; GFX9-DL-NEXT:    v_add3_u32 v2, v2, v5, v4
; GFX9-DL-NEXT:    v_add3_u32 v1, v17, v1, v2
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_multiuses_mul1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v8, 15, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_and_b32_e32 v9, 15, v2
; GFX10-DL-NEXT:    v_bfe_u32 v0, v1, 4, 4
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 28, v1
; GFX10-DL-NEXT:    v_bfe_u32 v4, v1, 24, 4
; GFX10-DL-NEXT:    v_bfe_u32 v5, v1, 20, 4
; GFX10-DL-NEXT:    v_bfe_u32 v6, v1, 16, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v1, 12, 4
; GFX10-DL-NEXT:    v_bfe_u32 v12, v2, 12, 4
; GFX10-DL-NEXT:    v_bfe_u32 v1, v1, 8, 4
; GFX10-DL-NEXT:    v_bfe_u32 v11, v2, 8, 4
; GFX10-DL-NEXT:    v_bfe_u32 v10, v2, 4, 4
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_u32_u24 v13, v8, v9, s2
; GFX10-DL-NEXT:    v_bfe_u32 v14, v2, 20, 4
; GFX10-DL-NEXT:    v_bfe_u32 v15, v2, 16, 4
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v1, v1, v11
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v7, v7, v12
; GFX10-DL-NEXT:    v_mad_u32_u24 v0, v0, v10, v13
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v10, 28, v2
; GFX10-DL-NEXT:    v_bfe_u32 v2, v2, 24, 4
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v6, v6, v15
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v5, v5, v14
; GFX10-DL-NEXT:    v_add3_u32 v0, v0, v1, v7
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v1, v4, v2
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v2, v3, v10
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v3, v8, v9
; GFX10-DL-NEXT:    v_add3_u32 v0, v0, v6, v5
; GFX10-DL-NEXT:    v_add3_u32 v0, v0, v1, v2
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    v_add3_u32 v0, v3, v13, v0
; GFX10-DL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                                <8 x i4> addrspace(1)* %src2,
                                                i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %v1e0 = extractelement <8 x i4> %vec1, i64 0
  %cv1e0 = zext i4 %v1e0 to i32
  %v2e0 = extractelement <8 x i4> %vec2, i64 0
  %cv2e0 = zext i4 %v2e0 to i32
  %mul0 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i4> %vec1, i64 1
  %cv1e1 = zext i4 %v1e1 to i32
  %v2e1 = extractelement <8 x i4> %vec2, i64 1
  %cv2e1 = zext i4 %v2e1 to i32
  %mul1 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i4> %vec1, i64 2
  %cv1e2 = zext i4 %v1e2 to i32
  %v2e2 = extractelement <8 x i4> %vec2, i64 2
  %cv2e2 = zext i4 %v2e2 to i32
  %mul2 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i4> %vec1, i64 3
  %cv1e3 = zext i4 %v1e3 to i32
  %v2e3 = extractelement <8 x i4> %vec2, i64 3
  %cv2e3 = zext i4 %v2e3 to i32
  %mul3 = mul nuw nsw i32 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i4> %vec1, i64 4
  %cv1e4 = zext i4 %v1e4 to i32
  %v2e4 = extractelement <8 x i4> %vec2, i64 4
  %cv2e4 = zext i4 %v2e4 to i32
  %mul4 = mul nuw nsw i32 %cv1e4, %cv2e4

  %v1e5 = extractelement <8 x i4> %vec1, i64 5
  %cv1e5 = zext i4 %v1e5 to i32
  %v2e5 = extractelement <8 x i4> %vec2, i64 5
  %cv2e5 = zext i4 %v2e5 to i32
  %mul5 = mul nuw nsw i32 %cv1e5, %cv2e5

  %v1e6 = extractelement <8 x i4> %vec1, i64 6
  %cv1e6 = zext i4 %v1e6 to i32
  %v2e6 = extractelement <8 x i4> %vec2, i64 6
  %cv2e6 = zext i4 %v2e6 to i32
  %mul6 = mul nuw nsw i32 %cv1e6, %cv2e6

  %v1e7 = extractelement <8 x i4> %vec1, i64 7
  %cv1e7 = zext i4 %v1e7 to i32
  %v2e7 = extractelement <8 x i4> %vec2, i64 7
  %cv2e7 = zext i4 %v2e7 to i32
  %mul7 = mul nuw nsw i32 %cv1e7, %cv2e7

  %acc = load i32, i32 addrspace(1)* %dst, align 4
  %add1 = add i32 %mul0, %acc
  %add = add i32  %mul0, %add1
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3
  %add5 = add i32 %add4, %mul4
  %add6 = add i32 %add5, %mul5
  %add7 = add i32 %add6, %mul6
  %add8 = add i32 %add7, %mul7

  %res = add i32 %add, %add8
  store i32 %res, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot8_acc32_vecMul(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_acc32_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v9, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_acc32_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    flat_load_dword v1, v[2:3]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 28, v0
; GFX8-NEXT:    v_bfe_u32 v3, v0, 24, 4
; GFX8-NEXT:    v_bfe_u32 v4, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v5, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v6, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v7, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v8, v0, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 28, v1
; GFX8-NEXT:    v_bfe_u32 v10, v1, 24, 4
; GFX8-NEXT:    v_bfe_u32 v11, v1, 20, 4
; GFX8-NEXT:    v_bfe_u32 v12, v1, 16, 4
; GFX8-NEXT:    v_bfe_u32 v13, v1, 12, 4
; GFX8-NEXT:    v_bfe_u32 v14, v1, 8, 4
; GFX8-NEXT:    v_bfe_u32 v15, v1, 4, 4
; GFX8-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v1, s2
; GFX8-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v9, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_acc32_vecMul:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 28, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 28, v2
; GFX9-NEXT:    v_bfe_u32 v4, v1, 24, 4
; GFX9-NEXT:    v_bfe_u32 v11, v2, 24, 4
; GFX9-NEXT:    v_bfe_u32 v5, v1, 20, 4
; GFX9-NEXT:    v_bfe_u32 v12, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v6, v1, 16, 4
; GFX9-NEXT:    v_bfe_u32 v13, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v7, v1, 12, 4
; GFX9-NEXT:    v_bfe_u32 v14, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v8, v1, 8, 4
; GFX9-NEXT:    v_bfe_u32 v9, v1, 4, 4
; GFX9-NEXT:    v_bfe_u32 v15, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v16, v2, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX9-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v2, v9, v16
; GFX9-NEXT:    v_mul_u32_u24_e32 v8, v8, v15
; GFX9-NEXT:    v_mul_u32_u24_e32 v7, v7, v14
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add3_u32 v1, v1, s0, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v6, v6, v13
; GFX9-NEXT:    v_mul_u32_u24_e32 v5, v5, v12
; GFX9-NEXT:    v_add3_u32 v1, v1, v8, v7
; GFX9-NEXT:    v_mul_u32_u24_e32 v4, v4, v11
; GFX9-NEXT:    v_mul_u32_u24_e32 v3, v3, v10
; GFX9-NEXT:    v_add3_u32 v1, v1, v6, v5
; GFX9-NEXT:    v_add3_u32 v1, v1, v4, v3
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_acc32_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot8_u32_u4 v0, v2, v3, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_acc32_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot8_u32_u4 v1, v1, v2, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                              <8 x i4> addrspace(1)* %src2,
                                              i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %cvec1 = zext <8 x i4> %vec1 to <8 x i32>
  %cvec2 = zext <8 x i4> %vec2 to <8 x i32>

  %mul = mul <8 x i32> %cvec1, %cvec2
  %mul0 = extractelement <8 x i32> %mul, i64 0
  %mul1 = extractelement <8 x i32> %mul, i64 1
  %mul2 = extractelement <8 x i32> %mul, i64 2
  %mul3 = extractelement <8 x i32> %mul, i64 3
  %mul4 = extractelement <8 x i32> %mul, i64 4
  %mul5 = extractelement <8 x i32> %mul, i64 5
  %mul6 = extractelement <8 x i32> %mul, i64 6
  %mul7 = extractelement <8 x i32> %mul, i64 7

  %acc = load i32, i32 addrspace(1)* %dst, align 4
  %add1 = add i32 %mul0, %acc
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3
  %add5 = add i32 %add4, %mul4
  %add6 = add i32 %add5, %mul5
  %add7 = add i32 %add6, %mul6
  %add8 = add i32 %add7, %mul7

  store i32 %add8, i32 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Clean up the code(by default pk_mad_I16 should be generated), then
; support the pattern.
define amdgpu_kernel void @udot8_acc16_vecMul(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_acc16_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v16, off, s[0:3], 0
; GFX7-NEXT:    s_mov_b32 s4, 0xf0000
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_u32 v7, v2, 20, 4
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 12, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v6, 15, v2
; GFX7-NEXT:    v_alignbit_b32 v2, v7, v2, 16
; GFX7-NEXT:    v_and_b32_e32 v7, s4, v8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 12, v0
; GFX7-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX7-NEXT:    v_and_b32_e32 v7, s4, v8
; GFX7-NEXT:    v_and_b32_e32 v13, 15, v0
; GFX7-NEXT:    v_or_b32_e32 v7, v13, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 16, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 16, v7
; GFX7-NEXT:    v_and_b32_e32 v6, 15, v6
; GFX7-NEXT:    v_and_b32_e32 v7, 15, v7
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v6, v6, v7, v16
; GFX7-NEXT:    v_bfe_u32 v12, v0, 8, 4
; GFX7-NEXT:    v_mad_u32_u24 v6, v8, v13, v6
; GFX7-NEXT:    v_bfe_u32 v14, v0, 20, 4
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 12, 4
; GFX7-NEXT:    v_alignbit_b32 v0, v14, v0, 16
; GFX7-NEXT:    v_mad_u32_u24 v5, v5, v12, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 16, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v14, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    v_mad_u32_u24 v4, v4, v11, v5
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v4
; GFX7-NEXT:    v_mad_u32_u24 v0, v15, v14, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v9, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_acc16_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_load_ushort v18, v[2:3]
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_and_b32_e32 v1, 15, v4
; GFX8-NEXT:    v_bfe_u32 v5, v4, 4, 4
; GFX8-NEXT:    v_bfe_u32 v6, v4, 8, 4
; GFX8-NEXT:    v_bfe_u32 v7, v4, 12, 4
; GFX8-NEXT:    v_bfe_u32 v8, v4, 16, 4
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v11, 15, v0
; GFX8-NEXT:    v_bfe_u32 v12, v0, 4, 4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v1, v1, v11, v18
; GFX8-NEXT:    v_bfe_u32 v13, v0, 8, 4
; GFX8-NEXT:    v_mad_u16 v1, v5, v12, v1
; GFX8-NEXT:    v_bfe_u32 v14, v0, 12, 4
; GFX8-NEXT:    v_mad_u16 v1, v6, v13, v1
; GFX8-NEXT:    v_bfe_u32 v15, v0, 16, 4
; GFX8-NEXT:    v_mad_u16 v1, v7, v14, v1
; GFX8-NEXT:    v_bfe_u32 v9, v4, 20, 4
; GFX8-NEXT:    v_bfe_u32 v16, v0, 20, 4
; GFX8-NEXT:    v_mad_u16 v1, v8, v15, v1
; GFX8-NEXT:    v_bfe_u32 v10, v4, 24, 4
; GFX8-NEXT:    v_bfe_u32 v17, v0, 24, 4
; GFX8-NEXT:    v_mad_u16 v1, v9, v16, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 28, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 28, v0
; GFX8-NEXT:    v_mad_u16 v1, v10, v17, v1
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v1
; GFX8-NEXT:    flat_store_short v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_acc16_vecMul:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v3, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v4, v0, s[6:7]
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_bfe_u32 v0, v3, 24, 4
; GFX9-NEXT:    v_bfe_u32 v6, v3, 16, 4
; GFX9-NEXT:    v_bfe_u32 v8, v3, 8, 4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfe_u32 v11, v4, 24, 4
; GFX9-NEXT:    v_bfe_u32 v13, v4, 16, 4
; GFX9-NEXT:    v_bfe_u32 v15, v4, 8, 4
; GFX9-NEXT:    v_and_b32_e32 v17, 15, v4
; GFX9-NEXT:    v_and_b32_e32 v10, 15, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 28, v3
; GFX9-NEXT:    v_and_b32_e32 v0, v2, v0
; GFX9-NEXT:    v_bfe_u32 v7, v3, 20, 4
; GFX9-NEXT:    v_and_b32_e32 v6, v2, v6
; GFX9-NEXT:    v_bfe_u32 v9, v3, 12, 4
; GFX9-NEXT:    v_and_b32_e32 v8, v2, v8
; GFX9-NEXT:    v_bfe_u32 v3, v3, 4, 4
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 28, v4
; GFX9-NEXT:    v_bfe_u32 v14, v4, 20, 4
; GFX9-NEXT:    v_bfe_u32 v16, v4, 12, 4
; GFX9-NEXT:    v_bfe_u32 v4, v4, 4, 4
; GFX9-NEXT:    v_and_b32_e32 v17, v2, v17
; GFX9-NEXT:    v_and_b32_e32 v11, v2, v11
; GFX9-NEXT:    v_and_b32_e32 v13, v2, v13
; GFX9-NEXT:    v_and_b32_e32 v15, v2, v15
; GFX9-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-NEXT:    v_lshl_or_b32 v4, v4, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v2, v3, 16, v2
; GFX9-NEXT:    v_pk_mul_lo_u16 v2, v2, v4
; GFX9-NEXT:    global_load_ushort v4, v1, s[2:3]
; GFX9-NEXT:    v_lshl_or_b32 v0, v5, 16, v0
; GFX9-NEXT:    v_lshl_or_b32 v6, v7, 16, v6
; GFX9-NEXT:    v_lshl_or_b32 v5, v14, 16, v13
; GFX9-NEXT:    v_lshl_or_b32 v7, v16, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v8, v9, 16, v8
; GFX9-NEXT:    v_pk_mul_lo_u16 v3, v6, v5
; GFX9-NEXT:    v_pk_mul_lo_u16 v5, v8, v7
; GFX9-NEXT:    v_lshl_or_b32 v10, v12, 16, v11
; GFX9-NEXT:    v_pk_mul_lo_u16 v0, v0, v10
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v4, v2, v4
; GFX9-NEXT:    v_add_u16_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_add_u16_e32 v2, v2, v5
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_add_u16_e32 v2, v2, v3
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_add_u16_e32 v2, v2, v0
; GFX9-NEXT:    v_add_u16_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    global_store_short v1, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_acc16_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v2, 0xffff
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v4, v0, s[6:7]
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_bfe_u32 v0, v3, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v6, v3, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v8, v3, 8, 4
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_bfe_u32 v11, v4, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v13, v4, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v15, v4, 8, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v17, 15, v4
; GFX9-DL-NEXT:    v_and_b32_e32 v10, 15, v3
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 28, v3
; GFX9-DL-NEXT:    v_and_b32_e32 v0, v2, v0
; GFX9-DL-NEXT:    v_bfe_u32 v7, v3, 20, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v6, v2, v6
; GFX9-DL-NEXT:    v_bfe_u32 v9, v3, 12, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v8, v2, v8
; GFX9-DL-NEXT:    v_bfe_u32 v3, v3, 4, 4
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v12, 28, v4
; GFX9-DL-NEXT:    v_bfe_u32 v14, v4, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v16, v4, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v4, v4, 4, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v17, v2, v17
; GFX9-DL-NEXT:    v_and_b32_e32 v11, v2, v11
; GFX9-DL-NEXT:    v_and_b32_e32 v13, v2, v13
; GFX9-DL-NEXT:    v_and_b32_e32 v15, v2, v15
; GFX9-DL-NEXT:    v_and_b32_e32 v2, v2, v10
; GFX9-DL-NEXT:    v_lshl_or_b32 v4, v4, 16, v17
; GFX9-DL-NEXT:    v_lshl_or_b32 v2, v3, 16, v2
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v2, v2, v4
; GFX9-DL-NEXT:    global_load_ushort v4, v1, s[2:3]
; GFX9-DL-NEXT:    v_lshl_or_b32 v0, v5, 16, v0
; GFX9-DL-NEXT:    v_lshl_or_b32 v6, v7, 16, v6
; GFX9-DL-NEXT:    v_lshl_or_b32 v5, v14, 16, v13
; GFX9-DL-NEXT:    v_lshl_or_b32 v7, v16, 16, v15
; GFX9-DL-NEXT:    v_lshl_or_b32 v8, v9, 16, v8
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v3, v6, v5
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v5, v8, v7
; GFX9-DL-NEXT:    v_lshl_or_b32 v10, v12, 16, v11
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v0, v0, v10
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_add_u16_e32 v4, v2, v4
; GFX9-DL-NEXT:    v_add_u16_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_add_u16_e32 v2, v2, v5
; GFX9-DL-NEXT:    v_add_u16_sdwa v2, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_add_u16_e32 v2, v2, v3
; GFX9-DL-NEXT:    v_add_u16_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_add_u16_e32 v2, v2, v0
; GFX9-DL-NEXT:    v_add_u16_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    global_store_short v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_acc16_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ushort v3, v0, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_and_b32_e32 v7, 15, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v6, 15, v2
; GFX10-DL-NEXT:    v_bfe_u32 v9, v1, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v10, v2, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v12, v1, 8, 4
; GFX10-DL-NEXT:    v_and_b32_e32 v7, v4, v7
; GFX10-DL-NEXT:    v_and_b32_e32 v6, v4, v6
; GFX10-DL-NEXT:    v_bfe_u32 v13, v2, 8, 4
; GFX10-DL-NEXT:    v_bfe_u32 v11, v1, 16, 4
; GFX10-DL-NEXT:    v_and_b32_e32 v12, v4, v12
; GFX10-DL-NEXT:    v_lshl_or_b32 v7, v9, 16, v7
; GFX10-DL-NEXT:    v_lshl_or_b32 v6, v10, 16, v6
; GFX10-DL-NEXT:    v_bfe_u32 v9, v1, 12, 4
; GFX10-DL-NEXT:    v_bfe_u32 v10, v2, 12, 4
; GFX10-DL-NEXT:    v_and_b32_e32 v13, v4, v13
; GFX10-DL-NEXT:    v_bfe_u32 v5, v1, 24, 4
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v6, v7, v6
; GFX10-DL-NEXT:    v_bfe_u32 v7, v2, 16, 4
; GFX10-DL-NEXT:    v_lshl_or_b32 v9, v9, 16, v12
; GFX10-DL-NEXT:    v_lshl_or_b32 v10, v10, 16, v13
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v8, 28, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v12, 16, v6
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v6, v3
; GFX10-DL-NEXT:    v_bfe_u32 v1, v1, 20, 4
; GFX10-DL-NEXT:    v_and_b32_e32 v11, v4, v11
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v9, v9, v10
; GFX10-DL-NEXT:    v_bfe_u32 v6, v2, 20, 4
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v3, v12
; GFX10-DL-NEXT:    v_and_b32_e32 v7, v4, v7
; GFX10-DL-NEXT:    v_bfe_u32 v10, v2, 24, 4
; GFX10-DL-NEXT:    v_lshl_or_b32 v1, v1, 16, v11
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v3, v9
; GFX10-DL-NEXT:    v_lshl_or_b32 v6, v6, 16, v7
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v7, 16, v9
; GFX10-DL-NEXT:    v_and_b32_e32 v9, v4, v10
; GFX10-DL-NEXT:    v_and_b32_e32 v4, v4, v5
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v1, v1, v6
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-DL-NEXT:    v_lshl_or_b32 v2, v2, 16, v9
; GFX10-DL-NEXT:    v_lshl_or_b32 v4, v8, 16, v4
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v3, v1
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v2, v4, v2
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v1, v2
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-DL-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                              <8 x i4> addrspace(1)* %src2,
                                              i16 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %cvec1 = zext <8 x i4> %vec1 to <8 x i16>
  %cvec2 = zext <8 x i4> %vec2 to <8 x i16>

  %mul = mul <8 x i16> %cvec1, %cvec2
  %mul0 = extractelement <8 x i16> %mul, i64 0
  %mul1 = extractelement <8 x i16> %mul, i64 1
  %mul2 = extractelement <8 x i16> %mul, i64 2
  %mul3 = extractelement <8 x i16> %mul, i64 3
  %mul4 = extractelement <8 x i16> %mul, i64 4
  %mul5 = extractelement <8 x i16> %mul, i64 5
  %mul6 = extractelement <8 x i16> %mul, i64 6
  %mul7 = extractelement <8 x i16> %mul, i64 7

  %acc = load i16, i16 addrspace(1)* %dst, align 4
  %add1 = add i16 %mul0, %acc
  %add2 = add i16 %add1, %mul1
  %add3 = add i16 %add2, %mul2
  %add4 = add i16 %add3, %mul3
  %add5 = add i16 %add4, %mul4
  %add6 = add i16 %add5, %mul5
  %add7 = add i16 %add6, %mul6
  %add8 = add i16 %add7, %mul7

  store i16 %add8, i16 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Cleanup the code to generate MAD; pattern should be recognized then.
define amdgpu_kernel void @udot8_acc8_vecMul(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_acc8_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ubyte v16, off, s[0:3], 0
; GFX7-NEXT:    s_movk_i32 s4, 0xf00
; GFX7-NEXT:    v_mov_b32_e32 v3, 0xf00
; GFX7-NEXT:    s_movk_i32 s5, 0xf0f
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 28, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 4, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 4, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 12, v2
; GFX7-NEXT:    v_bfe_u32 v1, v2, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v5, 15, v2
; GFX7-NEXT:    v_bfe_u32 v7, v2, 16, 4
; GFX7-NEXT:    v_alignbit_b32 v2, v6, v2, 24
; GFX7-NEXT:    v_and_b32_e32 v6, s4, v9
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 4, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 4, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s4, v4
; GFX7-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX7-NEXT:    v_and_b32_e32 v6, v3, v9
; GFX7-NEXT:    v_bfe_u32 v10, v0, 8, 4
; GFX7-NEXT:    v_and_b32_e32 v3, v3, v11
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX7-NEXT:    v_or_b32_e32 v3, v10, v3
; GFX7-NEXT:    v_and_b32_e32 v12, 15, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v13, 28, v0
; GFX7-NEXT:    v_or_b32_e32 v6, v12, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v2, s5, v2
; GFX7-NEXT:    v_or_b32_e32 v3, v6, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v15, 12, v0
; GFX7-NEXT:    v_bfe_u32 v14, v0, 16, 4
; GFX7-NEXT:    v_alignbit_b32 v0, v13, v0, 24
; GFX7-NEXT:    v_and_b32_e32 v8, s4, v8
; GFX7-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX7-NEXT:    v_and_b32_e32 v4, s4, v15
; GFX7-NEXT:    v_and_b32_e32 v0, s5, v0
; GFX7-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v6, 15, v1
; GFX7-NEXT:    v_and_b32_e32 v12, 15, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    v_or_b32_e32 v4, v14, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_bfe_u32 v7, v1, 8, 4
; GFX7-NEXT:    v_bfe_u32 v13, v3, 8, 4
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v6, v6, v12, v16
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v10, 24, v3
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 4
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 4
; GFX7-NEXT:    v_mad_u32_u24 v6, v7, v13, v6
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v3, v6
; GFX7-NEXT:    v_and_b32_e32 v8, 15, v2
; GFX7-NEXT:    v_and_b32_e32 v14, 15, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v10, v1
; GFX7-NEXT:    v_bfe_u32 v9, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 8, 4
; GFX7-NEXT:    v_mad_u32_u24 v1, v8, v14, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v11, 24, v0
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 4
; GFX7-NEXT:    v_mad_u32_u24 v1, v9, v15, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v11, v0
; GFX7-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_acc8_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s7
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    flat_load_dword v2, v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_ubyte v5, v[0:1]
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_bfe_u32 v3, v4, 20, 4
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_u32 v13, v2, 20, 4
; GFX8-NEXT:    v_bfe_u32 v7, v4, 24, 4
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 28, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 28, v2
; GFX8-NEXT:    v_bfe_u32 v14, v2, 24, 4
; GFX8-NEXT:    v_mul_lo_u16_sdwa v3, v3, v13 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_bfe_u32 v6, v4, 16, 4
; GFX8-NEXT:    v_bfe_u32 v12, v2, 16, 4
; GFX8-NEXT:    v_bfe_u32 v9, v4, 8, 4
; GFX8-NEXT:    v_bfe_u32 v16, v2, 8, 4
; GFX8-NEXT:    v_bfe_u32 v10, v4, 12, 4
; GFX8-NEXT:    v_and_b32_e32 v11, 15, v4
; GFX8-NEXT:    v_bfe_u32 v17, v2, 12, 4
; GFX8-NEXT:    v_and_b32_e32 v18, 15, v2
; GFX8-NEXT:    v_bfe_u32 v4, v4, 4, 4
; GFX8-NEXT:    v_bfe_u32 v2, v2, 4, 4
; GFX8-NEXT:    v_mul_lo_u16_e32 v13, v7, v14
; GFX8-NEXT:    v_mul_lo_u16_sdwa v8, v8, v15 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_mul_lo_u16_e32 v19, v6, v12
; GFX8-NEXT:    v_mul_lo_u16_e32 v9, v9, v16
; GFX8-NEXT:    v_mul_lo_u16_sdwa v10, v10, v17 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_mul_lo_u16_e32 v11, v11, v18
; GFX8-NEXT:    v_mul_lo_u16_sdwa v4, v4, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v8, v13, v8
; GFX8-NEXT:    v_or_b32_e32 v9, v9, v10
; GFX8-NEXT:    v_or_b32_e32 v10, v11, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v8
; GFX8-NEXT:    v_or_b32_e32 v3, v19, v3
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v9
; GFX8-NEXT:    v_or_b32_e32 v4, v4, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 8, v3
; GFX8-NEXT:    v_lshrrev_b64 v[2:3], 24, v[2:3]
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 8, v4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_u16_e32 v3, v10, v5
; GFX8-NEXT:    v_add_u16_e32 v3, v3, v4
; GFX8-NEXT:    v_add_u16_e32 v3, v3, v9
; GFX8-NEXT:    v_add_u16_e32 v2, v3, v2
; GFX8-NEXT:    v_mad_u16 v2, v6, v12, v2
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v11
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v8
; GFX8-NEXT:    v_mad_u16 v2, v7, v14, v2
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v8
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_acc8_vecMul:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    global_load_ubyte v4, v3, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_bfe_u32 v0, v1, 20, 4
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_bfe_u32 v12, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v6, v1, 24, 4
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 28, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 28, v2
; GFX9-NEXT:    v_bfe_u32 v13, v2, 24, 4
; GFX9-NEXT:    v_mul_lo_u16_sdwa v0, v0, v12 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_bfe_u32 v5, v1, 16, 4
; GFX9-NEXT:    v_bfe_u32 v11, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v8, v1, 8, 4
; GFX9-NEXT:    v_bfe_u32 v15, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v9, v1, 12, 4
; GFX9-NEXT:    v_and_b32_e32 v10, 15, v1
; GFX9-NEXT:    v_bfe_u32 v16, v2, 12, 4
; GFX9-NEXT:    v_and_b32_e32 v17, 15, v2
; GFX9-NEXT:    v_bfe_u32 v1, v1, 4, 4
; GFX9-NEXT:    v_bfe_u32 v2, v2, 4, 4
; GFX9-NEXT:    v_mul_lo_u16_e32 v12, v6, v13
; GFX9-NEXT:    v_mul_lo_u16_sdwa v7, v7, v14 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_mul_lo_u16_e32 v18, v5, v11
; GFX9-NEXT:    v_mul_lo_u16_sdwa v2, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_mul_lo_u16_e32 v8, v8, v15
; GFX9-NEXT:    v_mul_lo_u16_sdwa v9, v9, v16 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_mul_lo_u16_e32 v10, v10, v17
; GFX9-NEXT:    v_or_b32_e32 v7, v12, v7
; GFX9-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX9-NEXT:    v_or_b32_e32 v1, v18, v0
; GFX9-NEXT:    v_or_b32_e32 v9, v10, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 8, v1
; GFX9-NEXT:    v_lshrrev_b64 v[0:1], 24, v[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 8, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v1, v9, v4
; GFX9-NEXT:    v_add_u16_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v1, v1, v8
; GFX9-NEXT:    v_add_u16_e32 v0, v1, v0
; GFX9-NEXT:    v_mad_legacy_u16 v0, v5, v11, v0
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 8, v7
; GFX9-NEXT:    v_mad_legacy_u16 v0, v6, v13, v0
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v7
; GFX9-NEXT:    global_store_byte v3, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_acc8_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ubyte v4, v3, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_bfe_u32 v0, v1, 20, 4
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_bfe_u32 v12, v2, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v6, v1, 24, 4
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 28, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v14, 28, v2
; GFX9-DL-NEXT:    v_bfe_u32 v13, v2, 24, 4
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v0, v0, v12 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-DL-NEXT:    v_bfe_u32 v5, v1, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v11, v2, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v8, v1, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v15, v2, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v9, v1, 12, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v10, 15, v1
; GFX9-DL-NEXT:    v_bfe_u32 v16, v2, 12, 4
; GFX9-DL-NEXT:    v_and_b32_e32 v17, 15, v2
; GFX9-DL-NEXT:    v_bfe_u32 v1, v1, 4, 4
; GFX9-DL-NEXT:    v_bfe_u32 v2, v2, 4, 4
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v12, v6, v13
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v7, v7, v14 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v18, v5, v11
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v2, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v8, v8, v15
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v9, v9, v16 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v10, v10, v17
; GFX9-DL-NEXT:    v_or_b32_e32 v7, v12, v7
; GFX9-DL-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX9-DL-NEXT:    v_or_b32_e32 v1, v18, v0
; GFX9-DL-NEXT:    v_or_b32_e32 v9, v10, v2
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX9-DL-NEXT:    v_or_b32_sdwa v1, v1, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; GFX9-DL-NEXT:    v_or_b32_e32 v2, v2, v0
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v10, 8, v1
; GFX9-DL-NEXT:    v_lshrrev_b64 v[0:1], 24, v[0:1]
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v2, 8, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_add_u16_e32 v1, v9, v4
; GFX9-DL-NEXT:    v_add_u16_e32 v1, v1, v2
; GFX9-DL-NEXT:    v_add_u16_e32 v1, v1, v8
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v1, v0
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v5, v11, v0
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v10
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 8, v7
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v6, v13, v0
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v7
; GFX9-DL-NEXT:    global_store_byte v3, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_acc8_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    global_load_ubyte v3, v4, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_bfe_u32 v9, v1, 12, 4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_bfe_u32 v10, v2, 12, 4
; GFX10-DL-NEXT:    v_bfe_u32 v8, v1, 8, 4
; GFX10-DL-NEXT:    v_bfe_u32 v13, v2, 8, 4
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v7, 28, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v14, 28, v2
; GFX10-DL-NEXT:    v_mul_lo_u16 v9, v9, v10
; GFX10-DL-NEXT:    v_bfe_u32 v5, v1, 16, 4
; GFX10-DL-NEXT:    v_mul_lo_u16 v8, v8, v13
; GFX10-DL-NEXT:    v_bfe_u32 v0, v1, 20, 4
; GFX10-DL-NEXT:    v_bfe_u32 v6, v1, 24, 4
; GFX10-DL-NEXT:    v_and_b32_e32 v11, 15, v1
; GFX10-DL-NEXT:    v_lshlrev_b16 v9, 8, v9
; GFX10-DL-NEXT:    v_bfe_u32 v1, v1, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v15, v2, 4, 4
; GFX10-DL-NEXT:    v_mul_lo_u16 v7, v7, v14
; GFX10-DL-NEXT:    v_bfe_u32 v10, v2, 20, 4
; GFX10-DL-NEXT:    v_bfe_u32 v13, v2, 24, 4
; GFX10-DL-NEXT:    v_bfe_u32 v12, v2, 16, 4
; GFX10-DL-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX10-DL-NEXT:    v_mul_lo_u16 v1, v1, v15
; GFX10-DL-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX10-DL-NEXT:    v_mul_lo_u16 v9, v0, v10
; GFX10-DL-NEXT:    v_mul_lo_u16 v10, v6, v13
; GFX10-DL-NEXT:    v_lshlrev_b16 v7, 8, v7
; GFX10-DL-NEXT:    v_mul_lo_u16 v2, v11, v2
; GFX10-DL-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 16, v8
; GFX10-DL-NEXT:    v_mul_lo_u16 v11, v5, v12
; GFX10-DL-NEXT:    v_or_b32_e32 v7, v10, v7
; GFX10-DL-NEXT:    v_lshlrev_b16 v9, 8, v9
; GFX10-DL-NEXT:    v_or_b32_sdwa v10, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-DL-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX10-DL-NEXT:    v_or_b32_e32 v2, v11, v9
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v9, 16, v7
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v10, 8, v10
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v1, v3
; GFX10-DL-NEXT:    v_or_b32_sdwa v1, v2, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-DL-NEXT:    v_add_nc_u16 v9, v3, v10
; GFX10-DL-NEXT:    v_lshrrev_b64 v[2:3], 24, v[0:1]
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX10-DL-NEXT:    v_add_nc_u16 v0, v9, v8
; GFX10-DL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-DL-NEXT:    v_mad_u16 v0, v5, v12, v0
; GFX10-DL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v1, 8, v7
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v13, v0
; GFX10-DL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-DL-NEXT:    global_store_byte v4, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                             <8 x i4> addrspace(1)* %src2,
                                             i8 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %cvec1 = zext <8 x i4> %vec1 to <8 x i8>
  %cvec2 = zext <8 x i4> %vec2 to <8 x i8>

  %mul = mul <8 x i8> %cvec1, %cvec2
  %mul0 = extractelement <8 x i8> %mul, i64 0
  %mul1 = extractelement <8 x i8> %mul, i64 1
  %mul2 = extractelement <8 x i8> %mul, i64 2
  %mul3 = extractelement <8 x i8> %mul, i64 3
  %mul4 = extractelement <8 x i8> %mul, i64 4
  %mul5 = extractelement <8 x i8> %mul, i64 5
  %mul6 = extractelement <8 x i8> %mul, i64 6
  %mul7 = extractelement <8 x i8> %mul, i64 7

  %acc = load i8, i8 addrspace(1)* %dst, align 4
  %add1 = add i8 %mul0, %acc
  %add2 = add i8 %add1, %mul1
  %add3 = add i8 %add2, %mul2
  %add4 = add i8 %add3, %mul3
  %add5 = add i8 %add4, %mul4
  %add6 = add i8 %add5, %mul5
  %add7 = add i8 %add6, %mul6
  %add8 = add i8 %add7, %mul7

  store i8 %add8, i8 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Once the adictional "and+add" are removed, the pattern will be recognized.
define amdgpu_kernel void @udot8_acc4_vecMul(<8 x i4> addrspace(1)* %src1,
; GFX7-LABEL: udot8_acc4_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GFX7-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s14, -1
; GFX7-NEXT:    s_mov_b32 s15, 0xe8f000
; GFX7-NEXT:    s_add_u32 s12, s12, s3
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ubyte v16, off, s[0:3], 0
; GFX7-NEXT:    s_addc_u32 s13, s13, 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 28, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 24, 4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v2, 15, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 28, v0
; GFX7-NEXT:    v_bfe_u32 v10, v0, 24, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 4, 4
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v16
; GFX7-NEXT:    v_mad_u32_u24 v0, v8, v15, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v7, v14, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v13, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v5, v12, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v11, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v10, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v9, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX7-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_acc4_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX8-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    s_mov_b32 s10, -1
; GFX8-NEXT:    s_mov_b32 s11, 0xe80000
; GFX8-NEXT:    s_add_u32 s8, s8, s3
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, 15, v4
; GFX8-NEXT:    v_bfe_u32 v5, v4, 4, 4
; GFX8-NEXT:    v_bfe_u32 v6, v4, 8, 4
; GFX8-NEXT:    v_bfe_u32 v7, v4, 12, 4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v11, 15, v0
; GFX8-NEXT:    v_bfe_u32 v12, v0, 4, 4
; GFX8-NEXT:    v_bfe_u32 v13, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v14, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v8, v4, 16, 4
; GFX8-NEXT:    v_bfe_u32 v15, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v9, v4, 20, 4
; GFX8-NEXT:    v_bfe_u32 v10, v4, 24, 4
; GFX8-NEXT:    v_bfe_u32 v16, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v17, v0, 24, 4
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 28, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 28, v0
; GFX8-NEXT:    v_mul_u32_u24_e32 v0, v4, v0
; GFX8-NEXT:    v_mul_u32_u24_e32 v4, v10, v17
; GFX8-NEXT:    flat_load_ubyte v10, v[2:3]
; GFX8-NEXT:    v_mul_u32_u24_e32 v1, v1, v11
; GFX8-NEXT:    v_mul_u32_u24_e32 v5, v5, v12
; GFX8-NEXT:    v_mul_u32_u24_e32 v6, v6, v13
; GFX8-NEXT:    v_mul_u32_u24_e32 v7, v7, v14
; GFX8-NEXT:    v_mul_u32_u24_e32 v8, v8, v15
; GFX8-NEXT:    v_mul_u32_u24_e32 v9, v9, v16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v10
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v6
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v7
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v8
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v9
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v4
; GFX8-NEXT:    v_add_u16_e32 v0, v1, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX8-NEXT:    flat_store_byte v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_acc4_vecMul:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-NEXT:    s_mov_b32 s10, -1
; GFX9-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-NEXT:    s_add_u32 s8, s8, s3
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v10, 15, v3
; GFX9-NEXT:    v_bfe_u32 v4, v2, 4, 4
; GFX9-NEXT:    v_bfe_u32 v11, v3, 4, 4
; GFX9-NEXT:    v_bfe_u32 v5, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v12, v3, 8, 4
; GFX9-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v13, v3, 12, 4
; GFX9-NEXT:    v_bfe_u32 v7, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v14, v3, 16, 4
; GFX9-NEXT:    v_bfe_u32 v8, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v9, v2, 24, 4
; GFX9-NEXT:    v_bfe_u32 v15, v3, 20, 4
; GFX9-NEXT:    v_bfe_u32 v16, v3, 24, 4
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 28, v3
; GFX9-NEXT:    v_mul_u32_u24_e32 v2, v2, v3
; GFX9-NEXT:    v_mul_u32_u24_e32 v3, v9, v16
; GFX9-NEXT:    global_load_ubyte v9, v1, s[2:3]
; GFX9-NEXT:    v_mul_u32_u24_e32 v0, v0, v10
; GFX9-NEXT:    v_mul_u32_u24_e32 v4, v4, v11
; GFX9-NEXT:    v_mul_u32_u24_e32 v5, v5, v12
; GFX9-NEXT:    v_mul_u32_u24_e32 v6, v6, v13
; GFX9-NEXT:    v_mul_u32_u24_e32 v7, v7, v14
; GFX9-NEXT:    v_mul_u32_u24_e32 v8, v8, v15
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v9
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v5
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v6
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v7
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v8
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v3
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_acc4_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX9-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX9-DL-NEXT:    s_mov_b32 s10, -1
; GFX9-DL-NEXT:    s_mov_b32 s11, 0xe00000
; GFX9-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_and_b32_e32 v0, 15, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_and_b32_e32 v10, 15, v3
; GFX9-DL-NEXT:    v_bfe_u32 v4, v2, 4, 4
; GFX9-DL-NEXT:    v_bfe_u32 v11, v3, 4, 4
; GFX9-DL-NEXT:    v_bfe_u32 v5, v2, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v12, v3, 8, 4
; GFX9-DL-NEXT:    v_bfe_u32 v6, v2, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v13, v3, 12, 4
; GFX9-DL-NEXT:    v_bfe_u32 v7, v2, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v14, v3, 16, 4
; GFX9-DL-NEXT:    v_bfe_u32 v8, v2, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v9, v2, 24, 4
; GFX9-DL-NEXT:    v_bfe_u32 v15, v3, 20, 4
; GFX9-DL-NEXT:    v_bfe_u32 v16, v3, 24, 4
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v3, 28, v3
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v2, v2, v3
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v3, v9, v16
; GFX9-DL-NEXT:    global_load_ubyte v9, v1, s[2:3]
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v0, v0, v10
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v4, v4, v11
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v5, v5, v12
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v6, v6, v13
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v7, v7, v14
; GFX9-DL-NEXT:    v_mul_u32_u24_e32 v8, v8, v15
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v9
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v5
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v6
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v7
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v8
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v3
; GFX9-DL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-DL-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_acc4_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_mov_b32 s8, SCRATCH_RSRC_DWORD0
; GFX10-DL-NEXT:    s_mov_b32 s9, SCRATCH_RSRC_DWORD1
; GFX10-DL-NEXT:    s_mov_b32 s10, -1
; GFX10-DL-NEXT:    s_mov_b32 s11, 0x31c16000
; GFX10-DL-NEXT:    s_add_u32 s8, s8, s3
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ubyte v3, v0, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_and_b32_e32 v4, 15, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v5, 15, v2
; GFX10-DL-NEXT:    v_bfe_u32 v6, v1, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v7, v2, 4, 4
; GFX10-DL-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v4, v4, v5
; GFX10-DL-NEXT:    v_bfe_u32 v5, v1, 8, 4
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v6, v6, v7
; GFX10-DL-NEXT:    v_bfe_u32 v7, v2, 12, 4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v4, v3
; GFX10-DL-NEXT:    v_bfe_u32 v4, v1, 12, 4
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v5, v5, v8
; GFX10-DL-NEXT:    v_bfe_u32 v8, v2, 16, 4
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v3, v6
; GFX10-DL-NEXT:    v_bfe_u32 v6, v1, 16, 4
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v4, v4, v7
; GFX10-DL-NEXT:    v_bfe_u32 v7, v2, 20, 4
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v3, v5
; GFX10-DL-NEXT:    v_bfe_u32 v5, v1, 20, 4
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v6, v6, v8
; GFX10-DL-NEXT:    v_bfe_u32 v8, v2, 24, 4
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v3, v4
; GFX10-DL-NEXT:    v_bfe_u32 v4, v1, 24, 4
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v5, v5, v7
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v1, 28, v1
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v3, v6
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v4, v4, v8
; GFX10-DL-NEXT:    v_mul_u32_u24_e32 v1, v1, v2
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v3, v5
; GFX10-DL-NEXT:    v_add_nc_u16 v2, v3, v4
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v2, v1
; GFX10-DL-NEXT:    v_and_b32_e32 v1, 15, v1
; GFX10-DL-NEXT:    global_store_byte v0, v1, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
                                             <8 x i4> addrspace(1)* %src2,
                                             i4 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src1, i32 %idx
  %vec1 = load <8 x i4>, <8 x i4> addrspace(1)* %gep1
  %gep2 = getelementptr <8 x i4>, <8 x i4> addrspace(1)* %src2, i32 %idx
  %vec2 = load <8 x i4>, <8 x i4> addrspace(1)* %gep2

  %mul = mul <8 x i4> %vec1, %vec2
  %mul0 = extractelement <8 x i4> %mul, i64 0
  %mul1 = extractelement <8 x i4> %mul, i64 1
  %mul2 = extractelement <8 x i4> %mul, i64 2
  %mul3 = extractelement <8 x i4> %mul, i64 3
  %mul4 = extractelement <8 x i4> %mul, i64 4
  %mul5 = extractelement <8 x i4> %mul, i64 5
  %mul6 = extractelement <8 x i4> %mul, i64 6
  %mul7 = extractelement <8 x i4> %mul, i64 7

  %acc = load i4, i4 addrspace(1)* %dst, align 4
  %add1 = add i4 %mul0, %acc
  %add2 = add i4 %add1, %mul1
  %add3 = add i4 %add2, %mul2
  %add4 = add i4 %add3, %mul3
  %add5 = add i4 %add4, %mul4
  %add6 = add i4 %add5, %mul5
  %add7 = add i4 %add6, %mul6
  %add8 = add i4 %add7, %mul7

  store i4 %add8, i4 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @udot8_variant1(i32 addrspace(1)* %v1addr,
; GFX7-LABEL: udot8_variant1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 15, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 4, 4
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v9, 15, v0
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 4
; GFX7-NEXT:    v_bfe_u32 v5, v2, 12, 4
; GFX7-NEXT:    v_bfe_u32 v6, v2, 16, 4
; GFX7-NEXT:    v_bfe_u32 v7, v2, 20, 4
; GFX7-NEXT:    v_bfe_u32 v8, v2, 24, 4
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX7-NEXT:    v_bfe_u32 v10, v0, 4, 4
; GFX7-NEXT:    v_bfe_u32 v11, v0, 8, 4
; GFX7-NEXT:    v_bfe_u32 v12, v0, 12, 4
; GFX7-NEXT:    v_bfe_u32 v13, v0, 16, 4
; GFX7-NEXT:    v_bfe_u32 v14, v0, 20, 4
; GFX7-NEXT:    v_bfe_u32 v15, v0, 24, 4
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 28, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v9, v1, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v10, v3, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v11, v4, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v12, v5, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v13, v6, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v14, v7, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v15, v8, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot8_variant1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, 15, v3
; GFX8-NEXT:    v_bfe_u32 v4, v3, 4, 4
; GFX8-NEXT:    v_bfe_u32 v6, v3, 8, 4
; GFX8-NEXT:    v_bfe_u32 v8, v3, 12, 4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 15, v0
; GFX8-NEXT:    v_bfe_u32 v5, v0, 4, 4
; GFX8-NEXT:    v_bfe_u32 v7, v0, 8, 4
; GFX8-NEXT:    v_bfe_u32 v9, v0, 12, 4
; GFX8-NEXT:    v_bfe_u32 v10, v3, 16, 4
; GFX8-NEXT:    v_bfe_u32 v11, v0, 16, 4
; GFX8-NEXT:    v_bfe_u32 v12, v3, 20, 4
; GFX8-NEXT:    v_bfe_u32 v14, v3, 24, 4
; GFX8-NEXT:    v_bfe_u32 v13, v0, 20, 4
; GFX8-NEXT:    v_bfe_u32 v15, v0, 24, 4
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 28, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 28, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v2, v1, s2
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v3, v1
; GFX8-NEXT:    v_mad_u32_u24 v0, v5, v4, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v7, v6, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v9, v8, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v11, v10, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v13, v12, v0
; GFX8-NEXT:    v_mad_u32_u24 v2, v15, v14, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: udot8_variant1:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_and_b32_e32 v3, 15, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v4, 15, v2
; GFX9-NEXT:    v_bfe_u32 v5, v1, 4, 4
; GFX9-NEXT:    v_bfe_u32 v6, v2, 4, 4
; GFX9-NEXT:    v_bfe_u32 v7, v1, 8, 4
; GFX9-NEXT:    v_bfe_u32 v8, v2, 8, 4
; GFX9-NEXT:    v_bfe_u32 v9, v1, 12, 4
; GFX9-NEXT:    v_bfe_u32 v10, v2, 12, 4
; GFX9-NEXT:    v_bfe_u32 v11, v1, 16, 4
; GFX9-NEXT:    v_bfe_u32 v12, v2, 16, 4
; GFX9-NEXT:    v_bfe_u32 v13, v1, 20, 4
; GFX9-NEXT:    v_bfe_u32 v15, v1, 24, 4
; GFX9-NEXT:    v_bfe_u32 v14, v2, 20, 4
; GFX9-NEXT:    v_bfe_u32 v16, v2, 24, 4
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 28, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 28, v2
; GFX9-NEXT:    v_mul_u32_u24_e32 v3, v4, v3
; GFX9-NEXT:    v_mul_u32_u24_e32 v1, v2, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v4, v6, v5
; GFX9-NEXT:    v_mul_u32_u24_e32 v5, v8, v7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add3_u32 v1, v3, s0, v1
; GFX9-NEXT:    v_mul_u32_u24_e32 v6, v10, v9
; GFX9-NEXT:    v_mul_u32_u24_e32 v7, v12, v11
; GFX9-NEXT:    v_add3_u32 v1, v1, v4, v5
; GFX9-NEXT:    v_mul_u32_u24_e32 v8, v14, v13
; GFX9-NEXT:    v_mul_u32_u24_e32 v9, v16, v15
; GFX9-NEXT:    v_add3_u32 v1, v1, v6, v7
; GFX9-NEXT:    v_add3_u32 v1, v1, v8, v9
; GFX9-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot8_variant1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot8_u32_u4 v0, v3, v2, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot8_variant1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot8_u32_u4 v1, v2, v1, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                          i32 addrspace(1)* %v2addr,
                                          i32 addrspace(1)* %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr i32, i32 addrspace(1)* %v1addr, i32 %idx
  %v1 = load i32, i32 addrspace(1)* %gep1, align 4
  %gep2 = getelementptr i32, i32 addrspace(1)* %v2addr, i32 %idx
  %v2 = load i32, i32 addrspace(1)* %gep2, align 4
  %and = and i32 %v1, 15
  %and1 = and i32 %v2, 15
  %mul1 = mul nuw nsw i32 %and1, %and

  %shr = lshr i32 %v1, 4
  %and2 = and i32 %shr, 15
  %shr3 = lshr i32 %v2, 4
  %and4 = and i32 %shr3, 15
  %mul2 = mul nuw nsw i32 %and4, %and2

  %shr6 = lshr i32 %v1, 8
  %and7 = and i32 %shr6, 15
  %shr8 = lshr i32 %v2, 8
  %and9 = and i32 %shr8, 15
  %mul3 = mul nuw nsw i32 %and9, %and7

  %shr12 = lshr i32 %v1, 12
  %and13 = and i32 %shr12, 15
  %shr14 = lshr i32 %v2, 12
  %and15 = and i32 %shr14, 15
  %mul4 = mul nuw nsw i32 %and15, %and13

  %shr18 = lshr i32 %v1, 16
  %and19 = and i32 %shr18, 15
  %shr20 = lshr i32 %v2, 16
  %and21 = and i32 %shr20, 15
  %mul5 = mul nuw nsw i32 %and21, %and19

  %shr24 = lshr i32 %v1, 20
  %and25 = and i32 %shr24, 15
  %shr26 = lshr i32 %v2, 20
  %and27 = and i32 %shr26, 15
  %mul6 = mul nuw nsw i32 %and27, %and25

  %shr30 = lshr i32 %v1, 24
  %and31 = and i32 %shr30, 15
  %shr32 = lshr i32 %v2, 24
  %and33 = and i32 %shr32, 15
  %mul7 = mul nuw nsw i32 %and33, %and31

  %shr36 = lshr i32 %v1, 28
  %shr37 = lshr i32 %v2, 28
  %mul8 = mul nuw nsw i32 %shr37, %shr36
  %acc = load i32, i32 addrspace(1)* %dst, align 4

  %add1 = add i32 %mul1, %acc
  %add2 = add i32 %add1, %mul8
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3
  %add5 = add i32 %add4, %mul4
  %add6 = add i32 %add5, %mul5
  %add7 = add i32 %add6, %mul6
  %add8 = add i32 %add7, %mul7
  store i32 %add8, i32 addrspace(1)* %dst, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
