Links
=====

This page contains links to external resources on how to use LLDB. Being listed
on this page is not an endorsement.

## Blog Posts

### [Dancing in the Debugger — A Waltz with LLDB (2014) ](https://www.objc.io/issues/19-debugging/lldb-debugging/)

A high level overview of LLDB with a focus on debugging Objective-C code.

## Videos

### [LLDB: Beyond "po" (2019)](https://developer.apple.com/videos/play/wwdc2019/429/)

LLDB is a powerful tool for exploring and debugging your app at runtime.
Discover the various ways to display values in your app, how to format custom
data types, and how to extend LLDB using your own Python 3 scripts.

### [Advanced Debugging with Xcode and LLDB (2018)](https://developer.apple.com/videos/play/wwdc2018/412/)

Discover advanced techniques, and tips and tricks for enhancing your Xcode
debugging workflows. Learn how to take advantage of LLDB and custom breakpoints
for more powerful debugging. Get the most out of Xcode's view debugging tools
to solve UI issues in your app more efficiently.

### [Debugging with LLDB (2012)](https://developer.apple.com/videos/play/wwdc2012/415/)

LLDB is the next-generation debugger for macOS and iOS. Get an introduction to
using LLDB via the console interface and within Xcode's graphical debugger. The
team that created LLDB will demonstrate the latest features and improvements,
helping you track down bugs more efficiently than ever before.

### [Migrating from GDB to LLDB (2011)](https://developer.apple.com/videos/play/wwdc2011/321/)

LLDB is the next-generation debugger for macOS and iOS. Discover why you'll
want to start using LLDB in your own development, get expert tips from the team
that created LLDB, and see how it will help you track down bugs more
efficiently than ever before.

## Books

### [Advanced Apple Debugging & Reverse Engineering (2018)](https://www.raywenderlich.com/books/advanced-apple-debugging-reverse-engineering/)

A book about using LLDB on Apple platforms.

## Extensions

### [facebook/chisel](https://github.com/facebook/chisel)

Chisel is a collection of LLDB commands to assist in the debugging of iOS apps.

### [DerekSelander/LLDB](https://github.com/DerekSelander/LLDB)

A collection of LLDB aliases/regexes and Python scripts.
