.\" Copyright (c) 1989, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.\" Copyright 1989, Digital Equipment Corporation.
.\" Permission to use, copy, modify, distribute, and sell this documentation
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Digital Equipment Corporation makes no representations
.\" about the suitability for any purpose of the information in
.\" this document.  This documentation is provided "as is"
.\" without express or implied warranty.
.\"
.de EX
.nf
.ft CW
..
.de EE
.ft
.fi
..
.TH XMBUF __libmansuffix__ 1994-04-17 __xorgversion__
.SH NAME
XmbufQueryExtension, XmbufGetVersion, XmbufCreateBuffers, XmbufDestroyBuffers,
XmbufDisplayBuffers, XmbufGetWindowAttributes, XmbufChangeWindowAttributes,
XmbufGetBufferAttributes, XmbufChangeBufferAttributes, XmbufGetScreenInfo,
XmbufCreateStereoWindow - X multibuffering functions
.SH SYNTAX
.EX
\&#include <X11/extensions/multibuf.h>
.sp
Bool XmbufQueryExtension(
    Display *dpy,
    int *event_base_return,
    int *error_base_return);
.sp
Status XmbufGetVersion(
    Display *dpy,
    int *major_version_return,
    int *minor_version_return);
.sp
int XmbufCreateBuffers(
    Display *dpy,
    Window window,
    int count,
    int update_action,
    int update_hint,
    Multibuffer *buffers_update);
.sp
void XmbufDestroyBuffers(
    Display *dpy,
    Window window);
.sp
void XmbufDisplayBuffers(
    Display *dpy,
    int count,
    Multibuffer *buffers,
    int min_delay,
    int max_delay);
.sp
Status XmbufGetWindowAttributes(
    Display *dpy,
    Window window,
    XmbufWindowAttributes *attributes);
.sp
void XmbufChangeWindowAttributes(
    Display *dpy,
    Window window,
    unsigned long valuemask,
    XmbufSetWindowAttributes *attributes);
.sp
Status XmbufGetBufferAttributes(
    Display *dpy,
    Multibuffer buffer,
    XmbufBufferAttributes *attributes);
.sp
void XmbufChangeBufferAttributes(
    Display *dpy,
    Multibuffer buffer,
    unsigned long valuemask,
    XmbufSetBufferAttributes *attributes);
.sp
Status XmbufGetScreenInfo(
    Display *dpy,
    Drawable drawable,
    int *nmono_return,
    XmbufBufferInfo **mono_info_return,
    int *nstereo_return,
    XmbufBufferInfo **stereo_info_return);
.sp
Window XmbufCreateStereoWindow(
    Display *dpy,
    Window parent,
    int x,
    int y,
    unsigned int width,
    unsigned int height,
    unsigned int border_width,
    int depth,
    unsigned int class,                 /\&* InputOutput, InputOnly*/
    Visual *visual,
    unsigned long valuemask,
    XSetWindowAttributes *attributes,
    Multibuffer *left_return,
    Multibuffer *right_return);
.EE
.SH STRUCTURES
\fIEvents:\fP
.EX
typedef struct {
    int type;   /\&* of event */
    unsigned long serial;       /\&* # of last request processed by server */
    int send_event;     /\&* true if this came from a SendEvent request */
    Display *display;   /\&* Display the event was read from */
    Multibuffer buffer; /\&* buffer of event */
    int state;  /\&* see Clobbered constants above */
} XmbufClobberNotifyEvent;
.sp
typedef struct {
    int type;   /\&* of event */
    unsigned long serial;       /\&* # of last request processed by server */
    int send_event;     /\&* true if this came from a SendEvent request */
    Display *display;   /\&* Display the event was read from */
    Multibuffer buffer; /\&* buffer of event */
} XmbufUpdateNotifyEvent;
.EE
.PP
\fIPer-window attributes that can be got:\fP
.EX
typedef struct {
    int displayed_index;	/\&* which buffer is being displayed */
    int update_action;	/\&* Undefined, Background, Untouched, Copied */
    int update_hint;	/\&* Frequent, Intermittent, Static */
    int window_mode;	/\&* Mono, Stereo */
    int nbuffers;	/\&* Number of buffers */
    Multibuffer *buffers;	/\&* Buffers */
} XmbufWindowAttributes;
.EE
.PP
\fIPer-window attributes that can be set:\fP
.EX
typedef struct {
    int update_hint;	/\&* Frequent, Intermittent, Static */
} XmbufSetWindowAttributes;
.EE
.PP
\fIPer-buffer attributes that can be got:\fP
.EX
typedef struct {
    Window window;	/\&* which window this belongs to */
    unsigned long event_mask;	/\&* events that have been selected */
    int buffer_index;	/\&* which buffer is this */
    int side;	/\&* Mono, Left, Right */
} XmbufBufferAttributes;
.EE
.PP
\fIPer-buffer attributes that can be set:\fP
.EX
typedef struct {
    unsigned long event_mask;	/\&* events that have been selected */
} XmbufSetBufferAttributes;
.EE
.PP
\fIPer-screen buffer info (there will be lists of them):\fP
.EX
typedef struct {
    VisualID visualid;	/\&* visual usable at this depth */
    int max_buffers;	/\&* most buffers for this visual */
    int depth;	/\&* depth of buffers to be created */
} XmbufBufferInfo;
.EE
.SH DESCRIPTION
The application programming library for the
\fIX11 Double-Buffering, Multi-Buffering, and Stereo Extension\fP
contains the interfaces described below.
With the exception of
.BR XmbufQueryExtension ,
if any of these routines are
called with a display that does not support the extension, the
ExtensionErrorHandler (which can be set with
.B XSetExtensionErrorHandler
and functions the same way as
.BR XSetErrorHandler )
will be called and the function will then return.
.PP
.B XmbufQueryExtension
returns
.B True
if the multibuffering/stereo extension is available on the given display.
If the extension exists, the value of the first event
code (which should be added to the event type constants
.B MultibufferClobberNotify
and
.B MultibufferUpdateNotify
to get the actual values) is stored into
.I event_base_return
and the value of the first error code
(which should be added to the error type constant
.B MultibufferBadBuffer
to get the actual value) is stored into
.IR error_base_return .
.PP
.B XmbufGetVersion
gets the major and minor version numbers of the extension.
The return
value is zero if an error occurs or non-zero if no error happens.
.PP
.B XmbufCreateBuffers
requests that
.I count
buffers be created with the given
.I update_action
and
.I update_hint
and be associated with the indicated
.IR window .
The number of buffers created is returned (zero if an error occurred)
and
.I buffers_update
is filled in with that many Multibuffer identifiers.
.PP
.B XmbufDestroyBuffers
destroys the buffers associated with the given
.IR window .
.PP
.B XmbufDisplayBuffers
displays the indicated buffers their appropriate windows within
.I max_delay
milliseconds after
.I min_delay
milliseconds have passed.
No two buffers may be associated with the same window or else a Match
error is generated.
.PP
.B XmbufGetWindowAttributes
gets the multibuffering attributes that apply to all buffers associated
with the given
.IR window .
The list of
.I attributes
returned may be freed with
.BR XFree .
Returns non-zero on success and zero if an error occurs.
.PP
.B XmbufChangeWindowAttributes
sets the multibuffering attributes
that apply to all buffers associated
with the given window.
This is currently limited to the
.IR update_hint .
.PP
.B XmbufGetBufferAttributes
gets the attributes for the indicated buffer.
Returns non-zero on success and zero if an error occurs.
.PP
.B XmbufChangeBufferAttributes
sets the
.I attributes
for the indicated
.IR buffer .
This is currently limited to the
.IR event_mask .
.PP
.B XmbufGetScreenInfo
gets the parameters controlling how mono and stereo windows may be
created on the screen of the given
.IR drawable .
The numbers of sets of visual and depths are returned in
.I nmono_return
and
.IR nstereo_return .
If
.I nmono_return
is greater than zero, then
.I mono_info_return
is set to the address of an array of
.B XmbufBufferInfo
structures describing the
various visuals and depths that may be used.
Otherwise,
.I mono_info_return
is set to NULL.
Similarly,
.I stereo_info_return
is set according to
.IR nstereo_return .
The storage returned in
.I mono_info_return
and
.I stereo_info_return
may be released by
.BR XFree .
If no errors are encountered, non-zero will be returned.
.PP
.B XmbufCreateStereoWindow
creates a stereo window in the same way that
.B XCreateWindow
creates a mono window.
The buffer ids for the left and right buffers are returned in
.I left_return
and
.IR right_return ,
respectively.
If an extension error handler that returns is installed,
.B None
will be returned if the extension is not available on this display.
.SH PREDEFINED VALUES
Update_action field:
.RS
.nf
.B MultibufferUpdateActionUndefined
.B MultibufferUpdateActionBackground
.B MultibufferUpdateActionUntouched
.B MultibufferUpdateActionCopied
.fi
.RE
.sp
Update_hint field:
.RS
.nf
.B MultibufferUpdateHintFrequent
.B MultibufferUpdateHintIntermittent
.B MultibufferUpdateHintStatic
.fi
.RE
.sp
Valuemask fields:
.RS
.nf
.B MultibufferWindowUpdateHint
.B MultibufferBufferEventMask
.fi
.RE
.sp
Mono vs. stereo and left vs. right:
.RS
.nf
.B MultibufferModeMono
.B MultibufferModeStereo
.B MultibufferSideMono
.B MultibufferSideLeft
.B MultibufferSideRight
.fi
.RE
.sp
Clobber state:
.RS
.nf
.B MultibufferUnclobbered
.B MultibufferPartiallyClobbered
.B MultibufferFullyClobbered
.fi
.RE
.sp
Event stuff:
.RS
.nf
.B MultibufferClobberNotifyMask
.B MultibufferUpdateNotifyMask
.B MultibufferClobberNotify
.B MultibufferUpdateNotify
.B MultibufferNumberEvents
.B MultibufferBadBuffer
.B MultibufferNumberErrors
.fi
.RE
.SH BUGS
This manual page needs more work.
.SH SEE ALSO
\fIExtending X for Double Buffering, Multi-Buffering, and Stereo\fP
