/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import org.gnu.pilotlink.Record;

public class AddressRecord
extends Record {
    String[] fields;
    int[] labelIds;
    int showPhone;

    public AddressRecord(Record record) {
        super(record);
    }

    public AddressRecord() {
        this.labelIds = new int[5];
        this.fields = new String[20];
    }

    @Override
    public void setBuffer(byte[] byArray) {
        this.labelIds = new int[5];
        this.fields = new String[20];
        if (byArray.length < 5) {
            System.out.println("Wrong sized buffer for address...");
            return;
        }
        this.showPhone = this.hi(byArray[1]);
        this.labelIds[4] = this.lo(byArray[1]);
        this.labelIds[3] = this.hi(byArray[2]);
        this.labelIds[2] = this.lo(byArray[2]);
        this.labelIds[1] = this.hi(byArray[3]);
        this.labelIds[0] = this.lo(byArray[3]);
        long l = byArray[4] * 256 * 256 * 256 + byArray[5] * 256 * 256 + byArray[6] * 256 + byArray[7];
        int n = byArray.length - 9;
        int n2 = 9;
        for (int i = 0; i < 19; ++i) {
            if ((l & (long)(1 << i)) != 0L) {
                if (n < 1) {
                    return;
                }
                this.fields[i] = AddressRecord.getStringAt(byArray, n2);
                n -= this.fields[i].length() + 1;
                n2 += this.fields[i].length() + 1;
                continue;
            }
            this.fields[i] = null;
        }
        this.setSize(byArray.length);
    }

    @Override
    public int getSize() {
        return this.getBuffer().length;
    }

    @Override
    public byte[] getBuffer() {
        int n = 9;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == null) continue;
            n += this.fields[i].length() + 1;
        }
        byte[] byArray = new byte[n];
        byArray[1] = (byte)((byte)this.showPhone << 4 | (byte)this.labelIds[4]);
        byArray[2] = (byte)(this.labelIds[3] << 4 | (byte)this.labelIds[2]);
        byArray[3] = (byte)(this.labelIds[1] << 4 | (byte)this.labelIds[0]);
        int n2 = 9;
        long l = 0L;
        for (int i = 0; i < 19; ++i) {
            if (this.fields[i] == null) continue;
            l |= (long)(1 << i);
            int n3 = this.fields[i].length() + 1;
            Record.setStringAt(byArray, this.fields[i], n2);
            n2 += n3;
        }
        AddressRecord.setLongAt(byArray, l, 4);
        return byArray;
    }

    private int hi(byte by) {
        return (by & 0xF0) >> 4;
    }

    private int lo(byte by) {
        return by & 0xF;
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public int getLabelId(int n) {
        if (n > 5) {
            return 0;
        }
        return this.labelIds[n];
    }

    public void setField(String string, int n) {
        if (n > 19) {
            return;
        }
        this.fields[n] = string;
        this.setSize(this.getBuffer().length);
    }

    public void setLabelId(int n, int n2) {
        if (n2 > 5) {
            return;
        }
        this.labelIds[n2] = n;
        this.setSize(this.getBuffer().length);
    }
}

