###############################################################################
# Copyright (c) 2025, The OpenBLAS Project
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the OpenBLAS project nor the names of
#    its contributors may be used to endorse or promote products
#    derived from this software without specific prior written permission.
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE OPENBLAS PROJECT OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
###############################################################################
##
## Author: Hank Anderson <hank@statease.com>
## Description: Ported from portion of OpenBLAS/Makefile.system
##              Sets C related variables.
include(CheckCCompilerFlag)

if (${CMAKE_C_COMPILER_ID} MATCHES "IntelLLVM")
  set(CCOMMON_OPT "${CCOMMON_OPT} -fp-model=consistent")
  set(GCC_VERSION 100)
endif ()

if (${CMAKE_C_COMPILER_ID} STREQUAL "GNU" OR ${CMAKE_C_COMPILER_ID} STREQUAL "LSB" OR ${CMAKE_C_COMPILER_ID} MATCHES "Clang")
  set(CCOMMON_OPT "${CCOMMON_OPT} -Wall")
  set(COMMON_PROF "${COMMON_PROF} -fno-inline")
  set(NO_UNINITIALIZED_WARN "-Wno-uninitialized")
  set(GCC_VERSION ${CMAKE_C_COMPILER_VERSION})

  if (QUIET_MAKE)
    set(CCOMMON_OPT "${CCOMMON_OPT} ${NO_UNINITIALIZED_WARN} -Wno-unused")
  endif ()

  if (NO_BINARY_MODE)

    if (MIPS32)
        set(CCOMMON_OPT "${CCOMMON_OPT} -mabi=32")
      set(BINARY_DEFINED 1)
    endif ()

    if (MIPS64)
      if (BINARY64)
        set(CCOMMON_OPT "${CCOMMON_OPT} -mabi=64")
      else ()
        set(CCOMMON_OPT "${CCOMMON_OPT} -mabi=n32")
      endif ()
      set(BINARY_DEFINED 1)
    endif ()

    if (${CORE} STREQUAL "LOONGSON3A" OR ${CORE} STREQUAL "LOONGSON3B")
      set(CCOMMON_OPT "${CCOMMON_OPT} -march=mips64")
      set(FCOMMON_OPT "${FCOMMON_OPT} -march=mips64")
    endif ()

    if (LOONGARCH64)
      if (BINARY64)
	CHECK_C_COMPILER_FLAG("-mabi=lp64d" COMPILER_SUPPORT_LP64D_ABI)
        if(COMPILER_SUPPORT_LP64D_ABI)
	  set(CCOMMON_OPT "${CCOMMON_OPT} -mabi=lp64d")
	else()
	  set(CCOMMON_OPT "${CCOMMON_OPT} -mabi=lp64")
	endif ()
      else ()
	CHECK_C_COMPILER_FLAG("-mabi=ilp32d" COMPILER_SUPPORT_ILP32D_ABI)
	if(COMPILER_SUPPORT_ILP32D_ABI)
	  set(CCOMMON_OPT "${CCOMMON_OPT} -mabi=ilp32d")
	else()
	  set(CCOMMON_OPT "${CCOMMON_OPT} -mabi=lp32")
	endif ()
      endif ()
      set(BINARY_DEFINED 1)
    endif ()

    if (ZARCH)
      set (BINARY_DEFINED 1)
	endif ()
 
    if (CMAKE_SYSTEM_NAME STREQUAL "AIX")
      set(BINARY_DEFINED 1)
    endif ()
  endif ()

  if (NOT BINARY_DEFINED)
    if (BINARY64)
      set(CCOMMON_OPT "${CCOMMON_OPT} -m64")
    else ()
      set(CCOMMON_OPT "${CCOMMON_OPT} -m32")
    endif ()
  endif ()
endif ()

if (${CMAKE_C_COMPILER_ID} STREQUAL "PGI")
  if (BINARY64)
    set(CCOMMON_OPT "${CCOMMON_OPT} -tp p7-64")
  else ()
    set(CCOMMON_OPT "${CCOMMON_OPT} -tp p7")
  endif ()
endif ()

if (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC")
  if (POWER)
    set(CCOMMON_OPT "${CCOMMON_OPT} -tp pwr8")
  elseif (X86_64)
    set(CCOMMON_OPT "${CCOMMON_OPT} -tp px")
  endif ()
endif ()

if (${CMAKE_C_COMPILER_ID} STREQUAL "PATHSCALE")
  if (BINARY64)
    set(CCOMMON_OPT "${CCOMMON_OPT} -m64")
  else ()
    set(CCOMMON_OPT "${CCOMMON_OPT} -m32")
  endif ()
endif ()

if (${CMAKE_C_COMPILER_ID} STREQUAL "OPEN64")

  if (MIPS64)

    if (NOT BINARY64)
      set(CCOMMON_OPT "${CCOMMON_OPT} -n32")
    else ()
      set(CCOMMON_OPT "${CCOMMON_OPT} -n64")
    endif ()

    if (${CORE} STREQUAL "LOONGSON3A")
      set(CCOMMON_OPT "${CCOMMON_OPT} -loongson3 -static")
    endif ()

    if (${CORE} STREQUAL "LOONGSON3B")
      set(CCOMMON_OPT "${CCOMMON_OPT} -loongson3 -static")
    endif ()

  else ()

    if (BINARY64)
      set(CCOMMON_OPT "${CCOMMON_OPT} -m32")
    else ()
      set(CCOMMON_OPT "${CCOMMON_OPT} -m64")
    endif ()
  endif ()
endif ()

if (${CMAKE_C_COMPILER_ID} STREQUAL "SUN")
  set(CCOMMON_OPT "${CCOMMON_OPT} -w")
  if (X86)
    set(CCOMMON_OPT "${CCOMMON_OPT} -m32")
  else ()
    set(CCOMMON_OPT "${CCOMMON_OPT} -m64")
  endif ()
endif ()

if (${CORE} STREQUAL SKYLAKEX)
  if (NOT DYNAMIC_ARCH)
    if (NOT NO_AVX512)
      set (CCOMMON_OPT "${CCOMMON_OPT} -march=skylake-avx512")
    endif ()
  endif ()
endif ()

if (${CORE} STREQUAL COOPERLAKE)
  if (NOT DYNAMIC_ARCH)
    if (NOT NO_AVX512)
      if (${GCC_VERSION} VERSION_GREATER 10.1 OR ${GCC_VERSION} VERSION_EQUAL 10.1)
        set (CCOMMON_OPT  "${CCOMMON_OPT} -march=cooperlake")
      else ()
        set (CCOMMON_OPT "${CCOMMON_OPT} -march=skylake-avx512")
      endif()  
    endif ()
  endif ()
endif ()

if (${CORE} STREQUAL SAPPHIRERAPIDS)
  if (NOT DYNAMIC_ARCH)
    if (NOT NO_AVX512)
      if (${GCC_VERSION} VERSION_GREATER 11.0 OR ${GCC_VERSION} VERSION_EQUAL 11.0)
        set (CCOMMON_OPT  "${CCOMMON_OPT} -march=sapphirerapids")
      else ()
        set (CCOMMON_OPT "${CCOMMON_OPT} -march=skylake-avx512")
      endif()  
    endif ()
  endif ()
endif ()

if (${CORE} STREQUAL ZEN)
  if (HAVE_AVX512VL)
    if (NOT DYNAMIC_ARCH)
      if (NOT NO_AVX512)
        if (${GCC_VERSION} VERSION_GREATER 13.0 OR ${GCC_VERSION} VERSION_EQUAL 13.0)
          set (CCOMMON_OPT  "${CCOMMON_OPT} -march=znver4")
        else ()
          set (CCOMMON_OPT "${CCOMMON_OPT} -march=skylake-avx512")
        endif ()
      endif ()
    endif ()
  endif ()
endif ()

if (${CORE} STREQUAL A64FX)
  if (NOT DYNAMIC_ARCH)
    if (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC" AND NOT NO_SVE)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=a64fx")
    elseif (${GCC_VERSION} VERSION_GREATER 11.0 OR ${GCC_VERSION} VERSION_EQUAL 11.0)
      set (CCOMMON_OPT  "${CCOMMON_OPT} -march=armv8.2-a+sve -mtune=a64fx")
    else ()
      set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.2-a+sve")
    endif()
  endif ()
endif ()

if (${CORE} STREQUAL NEOVERSEV2)
	if (NOT DYNAMIC_ARCH)
		if (${CMAKE_C_COMPILER_ID} STREQUAL "PGI" AND NOT NO_SVE)
			set (CCOMMON_OPT  "${CCOMMON_OPT} -Msve_intrinsics -march=armv8.5-a+sve+sve2+bf16 -mtune=neoverse-v2")
		elseif (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC" AND NOT NO_SVE)
			set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=neoverse-v2")
		else ()
			if (${GCC_VERSION} VERSION_GREATER 13.0 OR ${GCC_VERSION} VERSION_EQUAL 13.0)
				set (CCOMMON_OPT  "${CCOMMON_OPT} -mcpu=neoverse-v2")
			elseif (${GCC_VERSION} VERSION_GREATER 10.4 OR ${GCC_VERSION} VERSION_EQUAL 10.4)
				set (CCOMMON_OPT  "${CCOMMON_OPT} -march=armv8.4-a+sve+bf16 -mtune=neoverse-v1")
			else ()
				set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.2-a+sve+bf16")
			endif()
		endif ()
	endif ()
endif ()

if (${CORE} STREQUAL NEOVERSEN2)
  if (NOT DYNAMIC_ARCH)
    if (${CMAKE_C_COMPILER_ID} STREQUAL "PGI" AND NOT NO_SVE)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -Msve_intrinsics -march=armv8.5-a+sve+sve2+bf16 -mtune=neoverse-n2")
    elseif (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC" AND NOT NO_SVE)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=neoverse-v2")
    else ()
      if (${GCC_VERSION} VERSION_GREATER 11.1 OR ${GCC_VERSION} VERSION_EQUAL 11.1)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -march=armv8.5-a+sve+sve2+bf16 -mtune=neoverse-n2")
      else ()
	set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.2-a+sve+bf16")
      endif()
    endif ()
  endif ()
endif ()

if (${CORE} STREQUAL NEOVERSEV1)
  if (NOT DYNAMIC_ARCH)
    if (${CMAKE_C_COMPILER_ID} STREQUAL "PGI" AND NOT NO_SVE)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -Msve_intrinsics -march=armv8.4-a+sve+bf16 -mtune=neoverse-v1")
    elseif (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC" AND NOT NO_SVE)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=neoverse-v1")
    else ()
      if (${GCC_VERSION} VERSION_GREATER 10.4 OR ${GCC_VERSION} VERSION_EQUAL 10.4)
        set (CCOMMON_OPT  "${CCOMMON_OPT} -march=armv8.4-a+sve+bf16 -mtune=neoverse-v1")
      else ()
        set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.2-a+sve+bf16")
      endif()
    endif()
  endif ()
endif ()

if (${CORE} STREQUAL NEOVERSEN1)
  if (NOT DYNAMIC_ARCH)
    if (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC" AND NOT NO_SVE)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=neoverse-n1")
    elseif (${GCC_VERSION} VERSION_GREATER 9.4 OR ${GCC_VERSION} VERSION_EQUAL 9.4)
      set (CCOMMON_OPT  "${CCOMMON_OPT} -march=armv8.2-a -mtune=neoverse-n1")
    else ()
      set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.2-a")
    endif()
  endif ()
endif ()

if (${CORE} STREQUAL AMPEREONE)
  if (NOT DYNAMIC_ARCH)
    if (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC")
	set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=neoverse-n1")
    elseif (${GCC_VERSION} VERSION_GREATER 12.1)
      set (CCOMMON_OPT  "${CCOMMON_OPT} -march=armv8.6-a+crypto+crc+fp16+sha3+rng -mtune=ampereone")
    else ()
      set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.6-a+fp16")
    endif()
  endif ()
endif ()

if (${CORE} STREQUAL ARMV8SVE)
  if (NOT DYNAMIC_ARCH)
    if (${CMAKE_C_COMPILER_ID} STREQUAL "PGI" AND NOT NO_SVE)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -Msve_intrinsics -march=armv8-a+sve")
    elseif (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC" AND NOT NO_SVE)
	    set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=host")
    else ()
      set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8-a+sve")
    endif ()
  endif ()
endif ()

if (${CORE} STREQUAL ARMV9SME)
  if (NOT DYNAMIC_ARCH)
    if (${CMAKE_C_COMPILER_ID} STREQUAL "NVHPC" AND NOT NO_SVE)
	    set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=host")
    else ()
    set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv9-a+sme")
	if (${OSNAME} STREQUAL Windows AND ${CMAKE_C_COMPILER_ID} MATCHES "Clang" )
	set (CCOMMON_OPT "${CCOMMON_OPT} --aarch64-stack-hazard-size=0")
    endif ()
	endif ()
  endif ()
endif ()

if (${CORE} STREQUAL VORTEXM4)
  if (NOT DYNAMIC_ARCH)
    if (${CMAKE_C_COMPILER_ID} STREQUAL "NVC" AND NOT NO_SVE)
	    set (CCOMMON_OPT  "${CCOMMON_OPT} -tp=host")
    else ()
	  if (${CMAKE_C_COMPILER_ID} STREQUAL "AppleClang")
        set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.4-a+sme -mcpu=apple-m4")
	  else ()
	    set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.4-a -mcpu=apple-m4")
      endif ()
	endif ()
  endif ()
endif ()

if (${CORE} STREQUAL CORTEXA510)
  if (NOT DYNAMIC_ARCH)
    set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.4-a+sve")
  endif ()
endif ()

if (${CORE} STREQUAL CORTEXA710)
  if (NOT DYNAMIC_ARCH)
    set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.4-a+sve")
  endif ()
endif ()

if (${CORE} STREQUAL CORTEXX1)
  if (NOT DYNAMIC_ARCH)
    set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.2-a")
  endif ()
endif ()

if (${CORE} STREQUAL CORTEXX2)
  if (NOT DYNAMIC_ARCH)
    set (CCOMMON_OPT "${CCOMMON_OPT} -march=armv8.4-a+sve")
  endif ()
endif ()

if (${CORE} STREQUAL POWER10)
  if (NOT DYNAMIC_ARCH)
    if (${GCC_VERSION} VERSION_GREATER 10.2 OR ${GCC_VERSION} VERSION_EQUAL 10.2)
      set (CCOMMON_OPT  "${CCOMMON_OPT} -mcpu=power10 -mtune=power10 -mvsx -fno-fast-math")
    else ()
      message(FATAL_ERROR "Compiler GCC ${GCC_VERSION} does not support Power10." )
    endif()
  endif ()
endif ()

if (${CORE} STREQUAL POWER9)
  if (NOT DYNAMIC_ARCH)
    if (${GCC_VERSION} VERSION_GREATER 5.0 OR ${GCC_VERSION} VERSION_EQUAL 5.0)
      set (CCOMMON_OPT  "${CCOMMON_OPT} -mcpu=power9 -mtune=power9 -mvsx -fno-fast-math")
    else ()
      set (CCOMMON_OPT  "${CCOMMON_OPT} -mcpu=power8 -mtune=power8 -mvsx -fno-fast-math")
      message(WARNING "Compiler GCC ${GCC_VERSION} does not fully support Power9.")
    endif ()
  endif ()
endif ()

if (${CORE} STREQUAL POWER8)
  if (NOT DYNAMIC_ARCH)
    set (CCOMMON_OPT  "${CCOMMON_OPT} -mcpu=power8 -mtune=power8 -mvsx -fno-fast-math")
  endif ()
endif ()

# With -mcpu=970 added it compiles, but library is broken, at least on macOS. If someone
# tests on *BSD or Linux and adds this flag, please make sure it is not used for macOS case.
if (${CORE} STREQUAL PPC970)
  if (NOT DYNAMIC_ARCH)
    set (CCOMMON_OPT  "${CCOMMON_OPT} -mtune=970 -maltivec -fno-fast-math")
  endif ()
  if (APPLE)
    set (CCOMMON_OPT  "${CCOMMON_OPT} -force_cpusubtype_ALL")
  endif ()
endif ()

# -mcpu=G4 seems to work fine, but perhaps avoid it for the sake of consistency?
if (${CORE} STREQUAL PPCG4)
  if (NOT DYNAMIC_ARCH)
    set (CCOMMON_OPT  "${CCOMMON_OPT} -mtune=G4 -maltivec -fno-fast-math")
  endif ()
  if (APPLE)
    set (CCOMMON_OPT  "${CCOMMON_OPT} -force_cpusubtype_ALL")
  endif ()
endif ()


if ((${CORE} STREQUAL RISCV64_ZVL128B) OR (${CORE} STREQUAL RISCV64_ZVL256B))
  set (RISCV64_OPT "rv64imafdcv")
  if (BUILD_BFLOAT16)
    set (RISCV64_OPT "${RISCV64_OPT}_zvfbfwma")
  endif()
  if (BUILD_HFLOAT16)
    set (RISCV64_OPT "${RISCV64_OPT}_zvfh_zfh")
  endif()
  if (${CORE} STREQUAL RISCV64_ZVL256B)
    set (CCOMMON_OPT "${CCOMMON_OPT} -march=${RISCV64_OPT}_zvl256b -mabi=lp64d")
  endif()
  if (${CORE} STREQUAL RISCV64_ZVL128B)
    set (CCOMMON_OPT "${CCOMMON_OPT} -march=${RISCV64_OPT}_zvl128b -mabi=lp64d")
  endif()
endif()
if (${CORE} STREQUAL RISCV64_GENERIC)
  set (CCOMMON_OPT "${CCOMMON_OPT} -march=rv64imafdc -mabi=lp64d")
endif()
if (${CORE} STREQUAL x280)
  set (CCOMMON_OPT "${CCOMMON_OPT} -march=rv64imafdcv_zba_zbb_zfh_zvl512b -mabi=lp64d")
endif()


if (NOT DYNAMIC_ARCH)
	if (HAVE_AVX2)
        set (CCOMMON_OPT  "${CCOMMON_OPT} -mavx2")
	endif ()
	if (HAVE_AVX)
        set (CCOMMON_OPT  "${CCOMMON_OPT} -mavx")
	endif ()
	#	if (HAVE_FMA3)
	#set (CCOMMON_OPT  "${CCOMMON_OPT} -mfma")
	#endif ()
	if (HAVE_SSE)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -msse")
	endif ()
	if (HAVE_SSE2)
        set (CCOMMON_OPT  "${CCOMMON_OPT} -msse2")
	endif ()
	if (HAVE_SSE3)
        set (CCOMMON_OPT  "${CCOMMON_OPT} -msse3")
	endif ()
	if (HAVE_SSSE3)
        set (CCOMMON_OPT  "${CCOMMON_OPT} -mssse3")
	endif ()
	if (HAVE_SSE4_1)
	set (CCOMMON_OPT  "${CCOMMON_OPT} -msse4.1")
	endif ()
endif()
