/* Generated by re2c */

#include <stddef.h> /* size_t */
#include <stdio.h>
#include <stdlib.h> /* malloc, free */
#include <string.h> /* memcpy */

static void* read_file(const char* fname, size_t unit, size_t padding, size_t* pfsize) {
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if (f == NULL) goto error;

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) goto error;

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) goto error;

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) fclose(f);
    return NULL;
}

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }
#define YYEND() limit <= cursor

static int action_line16(unsigned* pkix, const YYKEYTYPE* keys, const YYCTYPE* start, const YYCTYPE* token, const YYCTYPE** cursor, YYKEYTYPE rule_act) {
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf(stderr,
            "warning: lex_line16: control flow is undefined"
            " for input at position %ld, rerun re2c with '-W'\n");
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf(stderr,
            "error: lex_line16: at position %ld (key %u):\n"
            "\texpected: match length %ld, rule %u\n"
            "\tactual:   match length %ld, rule %u\n",
            pos, kix, len_exp, rule_exp, len_act, rule_act);
        return 1;
    }
}

static int check_key_count_line16(unsigned have, unsigned used, unsigned need) {
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line16: not enough keys\n");
    return 1;
}

int lex_line16() {
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file("skeleton/repeat-07_default.c.line16.input", sizeof (YYCTYPE), padding, &input_len);
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file("skeleton/repeat-07_default.c.line16.keys", sizeof (YYKEYTYPE), 0, &keys_count);
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        {
            static const void* yytarget[256] = {
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy2, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy3, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy4, &&yy5, &&yy6, &&yy7, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1,
                &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1, &&yy1
            };
            goto *yytarget[yych];
        }
yy1:
        YYSKIP();
        status = check_key_count_line16(keys_count, i, 3)
             || action_line16(&i, keys, input, token, &cursor, 5);
        goto loop;
yy2:
        YYSKIP();
        status = check_key_count_line16(keys_count, i, 3)
             || action_line16(&i, keys, input, token, &cursor, 254);
        goto loop;
yy3:
        YYSKIP();
        status = check_key_count_line16(keys_count, i, 3)
             || action_line16(&i, keys, input, token, &cursor, 4);
        goto loop;
yy4:
        YYSKIP();
        status = check_key_count_line16(keys_count, i, 3)
             || action_line16(&i, keys, input, token, &cursor, 0);
        goto loop;
yy5:
        YYSKIP();
        status = check_key_count_line16(keys_count, i, 3)
             || action_line16(&i, keys, input, token, &cursor, 1);
        goto loop;
yy6:
        YYSKIP();
        status = check_key_count_line16(keys_count, i, 3)
             || action_line16(&i, keys, input, token, &cursor, 2);
        goto loop;
yy7:
        YYSKIP();
        status = check_key_count_line16(keys_count, i, 3)
             || action_line16(&i, keys, input, token, &cursor, 3);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line16: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line16: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }
#define YYEND() limit <= cursor

static int action_line34(unsigned* pkix, const YYKEYTYPE* keys, const YYCTYPE* start, const YYCTYPE* token, const YYCTYPE** cursor, YYKEYTYPE rule_act) {
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf(stderr,
            "warning: lex_line34: control flow is undefined"
            " for input at position %ld, rerun re2c with '-W'\n");
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf(stderr,
            "error: lex_line34: at position %ld (key %u):\n"
            "\texpected: match length %ld, rule %u\n"
            "\tactual:   match length %ld, rule %u\n",
            pos, kix, len_exp, rule_exp, len_act, rule_act);
        return 1;
    }
}

static int check_key_count_line34(unsigned have, unsigned used, unsigned need) {
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line34: not enough keys\n");
    return 1;
}

int lex_line34() {
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file("skeleton/repeat-07_default.c.line34.input", sizeof (YYCTYPE), padding, &input_len);
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file("skeleton/repeat-07_default.c.line34.keys", sizeof (YYKEYTYPE), 0, &keys_count);
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yych & ~0xFF) {
        } else {
            static const void* yytarget[256] = {
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9, &&yy10,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9, &&yy11,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9, &&yy12, &&yy13, &&yy14, &&yy15,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
                 &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9
            };
            goto *yytarget[yych];
        }
yy9:
        YYSKIP();
        status = check_key_count_line34(keys_count, i, 3)
             || action_line34(&i, keys, input, token, &cursor, 5);
        goto loop;
yy10:
        YYSKIP();
        status = check_key_count_line34(keys_count, i, 3)
             || action_line34(&i, keys, input, token, &cursor, 254);
        goto loop;
yy11:
        YYSKIP();
        status = check_key_count_line34(keys_count, i, 3)
             || action_line34(&i, keys, input, token, &cursor, 4);
        goto loop;
yy12:
        YYSKIP();
        status = check_key_count_line34(keys_count, i, 3)
             || action_line34(&i, keys, input, token, &cursor, 0);
        goto loop;
yy13:
        YYSKIP();
        status = check_key_count_line34(keys_count, i, 3)
             || action_line34(&i, keys, input, token, &cursor, 1);
        goto loop;
yy14:
        YYSKIP();
        status = check_key_count_line34(keys_count, i, 3)
             || action_line34(&i, keys, input, token, &cursor, 2);
        goto loop;
yy15:
        YYSKIP();
        status = check_key_count_line34(keys_count, i, 3)
             || action_line34(&i, keys, input, token, &cursor, 3);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line34: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line34: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned int
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { goto loop_end; }
#define YYEND() limit <= cursor

static int action_line52(unsigned* pkix, const YYKEYTYPE* keys, const YYCTYPE* start, const YYCTYPE* token, const YYCTYPE** cursor, YYKEYTYPE rule_act) {
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf(stderr,
            "warning: lex_line52: control flow is undefined"
            " for input at position %ld, rerun re2c with '-W'\n");
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf(stderr,
            "error: lex_line52: at position %ld (key %u):\n"
            "\texpected: match length %ld, rule %u\n"
            "\tactual:   match length %ld, rule %u\n",
            pos, kix, len_exp, rule_exp, len_act, rule_act);
        return 1;
    }
}

static int check_key_count_line52(unsigned have, unsigned used, unsigned need) {
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line52: not enough keys\n");
    return 1;
}

int lex_line52() {
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file("skeleton/repeat-07_default.c.line52.input", sizeof (YYCTYPE), padding, &input_len);
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u) + (p[2] << 16u) + (p[3] << 24u);
    }

    keys = (YYKEYTYPE *) read_file("skeleton/repeat-07_default.c.line52.keys", sizeof (YYKEYTYPE), 0, &keys_count);
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    i = 0;
loop:
    if (!(status == 0 && cursor < eof && i < keys_count)) goto loop_end;
    {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yych & ~0xFF) {
        } else {
            static const void* yytarget[256] = {
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy18, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy19, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy20, &&yy21, &&yy22, &&yy23, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17,
                &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17, &&yy17
            };
            goto *yytarget[yych];
        }
yy17:
        YYSKIP();
        status = check_key_count_line52(keys_count, i, 3)
             || action_line52(&i, keys, input, token, &cursor, 5);
        goto loop;
yy18:
        YYSKIP();
        status = check_key_count_line52(keys_count, i, 3)
             || action_line52(&i, keys, input, token, &cursor, 254);
        goto loop;
yy19:
        YYSKIP();
        status = check_key_count_line52(keys_count, i, 3)
             || action_line52(&i, keys, input, token, &cursor, 4);
        goto loop;
yy20:
        YYSKIP();
        status = check_key_count_line52(keys_count, i, 3)
             || action_line52(&i, keys, input, token, &cursor, 0);
        goto loop;
yy21:
        YYSKIP();
        status = check_key_count_line52(keys_count, i, 3)
             || action_line52(&i, keys, input, token, &cursor, 1);
        goto loop;
yy22:
        YYSKIP();
        status = check_key_count_line52(keys_count, i, 3)
             || action_line52(&i, keys, input, token, &cursor, 2);
        goto loop;
yy23:
        YYSKIP();
        status = check_key_count_line52(keys_count, i, 3)
             || action_line52(&i, keys, input, token, &cursor, 3);
        goto loop;

    }
loop_end:
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line52: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line52: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

int main() {
    if (lex_line16() != 0) return 1;
    if (lex_line34() != 0) return 1;
    if (lex_line52() != 0) return 1;
    return 0;
}
 	
 !"#$%&'()*+,-./023456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`efghijklmnopqrstuvwxyz{|}~
1abcd           	   
                     ! " # $ % & ' ( ) * + , - . / 0 1 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` e eeeeeeeee	e
eee
eeeeeeeeeeeeeeeeeee e!e"e#e$e%e&e'e(e)e*e+e,e-e.e/e0e1e2e3e4e5e6e7e8e9e:e;e<e=e>e?e@eAeBeCeDeEeFeGeHeIeJeKeLeMeNeOePeQeReSeTeUeVeWeXeYeZe[e\e]e^e_e`eaebecedeeefegeheiejekelemeneoepeqereseteuevewexeyeze{e|e}e~eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
 2 a b c d                              	         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   e   e  e"  e3  eD  eU  ef  ew  e  e  e  e  e  e  e  e  e e! e2 eC eT ee ev e e e e e e e e e e  e1 eB eS ed eu e e e e e e e e e e e0 eA eR ec et e e e e e e e e e
 e e/ e@ eQ eb es e e e e e e e e e e e. e? eP ea er e e e e e e e e e e e- e> eO e` eq e e e e e e e e e
 e e, e= eN e_ ep e e e e e e e e e	 e e+ e< eM e^ eo e e e e e e e e e	 e	 e*	 e;	 eL	 e]	 en	 e	 e	 e	 e	 e	 e	 e	 e	 e
 e
 e)
 e:
 eK
 e\
 em
 e~
 e
 e
 e
 e
 e
 e
 e
 e e e( e9 eJ e[ el e} e e e e e e e e e e' e8 eI eZ ek e| e e e e e e e e
 e
 e&
 e7
 eH
 eY
 ej
 e{
 e
 e
 e
 e
 e
 e
 e
 e e e% e6 eG eX ei ez e e e e e e e e e e$ e5 eF eW eh ey e e e e e e e e e e# e4 eE eV eg ex e e e e e e e  
   3   a   b   c   d    