// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +xcvalu -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg | FileCheck %s

#include <stdint.h>

// CHECK-LABEL: @test_abs(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.abs.i32(i32 [[A:%.*]], i1 true)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_abs(int a) {
  return __builtin_abs(a);
}

// CHECK-LABEL: @test_alu_sle(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = icmp sle i32 [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    [[SLE:%.*]] = zext i1 [[TMP0]] to i32
// CHECK-NEXT:    ret i32 [[SLE]]
//
int test_alu_sle(int32_t a, int32_t b) {
  return __builtin_riscv_cv_alu_sle(a, b);
}

// CHECK-LABEL: @test_alu_sleu(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = icmp ule i32 [[A:%.*]], [[B:%.*]]
// CHECK-NEXT:    [[SLEU:%.*]] = zext i1 [[TMP0]] to i32
// CHECK-NEXT:    ret i32 [[SLEU]]
//
int test_alu_sleu(uint32_t a, uint32_t b) {
  return __builtin_riscv_cv_alu_sleu(a, b);
}

// CHECK-LABEL: @test_alu_exths(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV:%.*]] = sext i16 [[A:%.*]] to i32
// CHECK-NEXT:    [[TMP0:%.*]] = trunc i32 [[CONV]] to i16
// CHECK-NEXT:    [[EXTHS:%.*]] = sext i16 [[TMP0]] to i32
// CHECK-NEXT:    ret i32 [[EXTHS]]
//
int test_alu_exths(int16_t a) {
  return __builtin_riscv_cv_alu_exths(a);
}

// CHECK-LABEL: @test_alu_exthz(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV:%.*]] = zext i16 [[A:%.*]] to i32
// CHECK-NEXT:    [[TMP0:%.*]] = trunc i32 [[CONV]] to i16
// CHECK-NEXT:    [[EXTHZ:%.*]] = zext i16 [[TMP0]] to i32
// CHECK-NEXT:    ret i32 [[EXTHZ]]
//
int test_alu_exthz(uint16_t a) {
  return __builtin_riscv_cv_alu_exthz(a);
}

// CHECK-LABEL: @test_alu_extbs(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[A:%.*]] to i32
// CHECK-NEXT:    [[TMP0:%.*]] = trunc i32 [[CONV]] to i8
// CHECK-NEXT:    [[EXTBS:%.*]] = sext i8 [[TMP0]] to i32
// CHECK-NEXT:    ret i32 [[EXTBS]]
//
int test_alu_extbs(int8_t a) {
  return __builtin_riscv_cv_alu_extbs(a);
}

// CHECK-LABEL: @test_alu_extbz(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[A:%.*]] to i32
// CHECK-NEXT:    [[TMP0:%.*]] = trunc i32 [[CONV]] to i8
// CHECK-NEXT:    [[EXTBZ:%.*]] = zext i8 [[TMP0]] to i32
// CHECK-NEXT:    ret i32 [[EXTBZ]]
//
int test_alu_extbz(uint8_t a) {
  return __builtin_riscv_cv_alu_extbz(a);
}

// CHECK-LABEL: @test_alu_clip(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.clip(i32 [[A:%.*]], i32 15)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_clip(int32_t a) {
  return __builtin_riscv_cv_alu_clip(a, 15);
}

// CHECK-LABEL: @test_alu_clipu(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.clipu(i32 [[A:%.*]], i32 15)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_clipu(uint32_t a) {
  return __builtin_riscv_cv_alu_clipu(a, 15);
}

// CHECK-LABEL: @test_alu_addN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.addN(i32 [[A:%.*]], i32 [[B:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_addN(int32_t a, int32_t b) {
  return __builtin_riscv_cv_alu_addN(a, b, 0);
}

// CHECK-LABEL: @test_alu_adduN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.adduN(i32 [[A:%.*]], i32 [[B:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_adduN(uint32_t a, uint32_t b) {
  return __builtin_riscv_cv_alu_adduN(a, b, 0);
}

// CHECK-LABEL: @test_alu_addRN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.addRN(i32 [[A:%.*]], i32 [[B:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_addRN(int32_t a, int32_t b) {
  return __builtin_riscv_cv_alu_addRN(a, b, 0);
}

// CHECK-LABEL: @test_alu_adduRN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.adduRN(i32 [[A:%.*]], i32 [[B:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_adduRN(uint32_t a, uint32_t b) {
  return __builtin_riscv_cv_alu_adduRN(a, b, 0);
}

// CHECK-LABEL: @test_alu_subN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.subN(i32 [[A:%.*]], i32 [[B:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_subN(int32_t a, int32_t b) {
  return __builtin_riscv_cv_alu_subN(a, b, 0);
}

// CHECK-LABEL: @test_alu_subuN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.subuN(i32 [[A:%.*]], i32 [[B:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_subuN(uint32_t a, uint32_t b) {
  return __builtin_riscv_cv_alu_subuN(a, b, 0);
}

// CHECK-LABEL: @test_alu_subRN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.subRN(i32 [[A:%.*]], i32 [[B:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_subRN(int32_t a, int32_t b) {
  return __builtin_riscv_cv_alu_subRN(a, b, 0);
}

// CHECK-LABEL: @test_alu_subuRN(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.riscv.cv.alu.subuRN(i32 [[A:%.*]], i32 [[B:%.*]], i32 0)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_alu_subuRN(uint32_t a, uint32_t b) {
  return __builtin_riscv_cv_alu_subuRN(a, b, 0);
}
